/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class TXTRecord
extends Record {
    private Vector strings;

    TXTRecord(Name _name, short _dclass, int _ttl, int length, DataByteInputStream in) throws IOException {
        super(_name, (short)16, _dclass, _ttl);
        if (in == null) {
            return;
        }
        int count = 0;
        this.strings = new Vector();
        while (count < length) {
            byte len = in.readByte();
            byte[] b = new byte[len];
            in.read(b);
            count += len + 1;
            this.strings.addElement(new String(b));
        }
    }

    public TXTRecord(Name _name, short _dclass, int _ttl, String _string) throws IOException {
        super(_name, (short)16, _dclass, _ttl);
        this.strings = new Vector();
        this.strings.addElement(_string);
    }

    public TXTRecord(Name _name, short _dclass, int _ttl, Vector _strings) throws IOException {
        super(_name, (short)16, _dclass, _ttl);
        this.strings = _strings;
    }

    TXTRecord(Name _name, short _dclass, int _ttl, MyStringTokenizer st, Name origin) throws IOException {
        super(_name, (short)16, _dclass, _ttl);
        this.strings = new Vector();
        while (st.hasMoreTokens()) {
            this.strings.addElement(st.nextToken());
        }
    }

    public Vector getStrings() {
        return this.strings;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.strings != null) {
            Enumeration e = this.strings.elements();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                sb.append("\"");
                sb.append(s);
                if (!e.hasMoreElements()) continue;
                sb.append("\" ");
            }
        }
        return sb.toString();
    }

    void rrToWire(DataByteOutputStream out, Compression c) throws IOException {
        if (this.strings == null) {
            return;
        }
        Enumeration e = this.strings.elements();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            out.writeString(s);
        }
    }
}

