/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class NAPTRRecord
extends Record {
    private short order;
    private short preference;
    private String flags;
    private String service;
    private String regexp;
    private Name replacement;

    private NAPTRRecord() {
    }

    public NAPTRRecord(Name _name, short _dclass, int _ttl, int _order, int _preference, String _flags, String _service, String _regexp, Name _replacement) {
        super(_name, (short)35, _dclass, _ttl);
        this.order = (short)_order;
        this.preference = (short)_preference;
        this.flags = _flags;
        this.service = _service;
        this.regexp = _regexp;
        this.replacement = _replacement;
        if (Options.check("verbose")) {
            System.err.println(" NAPTR Set Member Constructor: " + this.toString());
        }
    }

    NAPTRRecord(Name _name, short _dclass, int _ttl, int length, DataByteInputStream in) throws IOException {
        super(_name, (short)35, _dclass, _ttl);
        if (in == null) {
            return;
        }
        this.order = (short)in.readUnsignedShort();
        this.preference = (short)in.readUnsignedShort();
        this.flags = in.readString();
        this.service = in.readString();
        this.regexp = in.readString();
        this.replacement = new Name(in);
    }

    NAPTRRecord(Name _name, short _dclass, int _ttl, MyStringTokenizer st, Name origin) throws IOException {
        super(_name, (short)35, _dclass, _ttl);
        this.order = Short.parseShort(st.nextToken());
        this.preference = Short.parseShort(st.nextToken());
        this.flags = st.nextToken();
        this.service = st.nextToken();
        this.regexp = st.nextToken();
        this.replacement = new Name(st.nextToken(), origin);
        if (Options.check("verbose")) {
            System.err.println(" NAPTR MyStringTokenizer Constructor: " + this.toString());
        }
    }

    public String getFlags() {
        return this.flags;
    }

    public short getOrder() {
        return this.order;
    }

    public short getPreference() {
        return this.preference;
    }

    public String getRegexp() {
        return this.regexp;
    }

    public Name getReplacement() {
        return this.replacement;
    }

    public String getService() {
        return this.service;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.replacement != null) {
            sb.append(this.order);
            sb.append(" ");
            sb.append(this.preference);
            sb.append(" ");
            sb.append(this.flags);
            sb.append(" ");
            sb.append(this.service);
            sb.append(" ");
            sb.append(this.regexp);
            sb.append(" ");
            sb.append(this.replacement);
        }
        if (Options.check("verbose")) {
            System.err.println(" NAPTR toString(): : " + sb.toString());
        }
        return sb.toString();
    }

    void rrToWire(DataByteOutputStream out, Compression c) throws IOException {
        if (this.replacement == null && this.regexp == null) {
            return;
        }
        out.writeShort(this.order);
        out.writeShort(this.preference);
        out.writeString(this.flags);
        out.writeString(this.service);
        out.writeString(this.regexp);
        this.replacement.toWire(out, null);
        if (Options.check("verbose")) {
            System.err.println(" NAPTR rrToWire(): " + this.toString());
        }
    }

    void rrToWireCanonical(DataByteOutputStream out) throws IOException {
        if (this.replacement == null && this.regexp == null) {
            return;
        }
        out.writeShort(this.order);
        out.writeShort(this.preference);
        out.writeString(this.flags);
        out.writeString(this.service);
        out.writeString(this.regexp);
        this.replacement.toWireCanonical(out);
        if (Options.check("verbose")) {
            System.err.println(" NAPTR rrToWireCanonical(): " + this.toString());
        }
    }
}

