/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Header;
import org.xbill.DNS.Name;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.Section;
import org.xbill.DNS.TSIGRecord;
import org.xbill.DNS.Type;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;

public class Message
implements Cloneable {
    private Header header;
    private Vector[] sections = new Vector[4];
    private int size;
    private byte[] wireFormat;
    private boolean frozen;
    boolean TSIGsigned;
    boolean TSIGverified;

    public Message() {
        this(Header.randomID());
    }

    public Message(int id) {
        int i = 0;
        while (i < 4) {
            this.sections[i] = new Vector();
            ++i;
        }
        this.header = new Header(id);
        this.wireFormat = null;
        this.frozen = false;
    }

    Message(DataByteInputStream in) throws IOException {
        this();
        this.header = new Header(in);
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < this.header.getCount(i)) {
                Record rec = Record.fromWire(in, i);
                this.sections[i].addElement(rec);
                ++j;
            }
            ++i;
        }
        this.size = in.getPos();
    }

    public Message(byte[] b) throws IOException {
        this(new DataByteInputStream(b));
    }

    public void addRecord(Record r, int section) {
        this.sections[section].addElement(r);
        this.header.incCount(section);
    }

    public Object clone() {
        Message m = new Message();
        int i = 0;
        while (i < this.sections.length) {
            m.sections[i] = (Vector)this.sections[i].clone();
            ++i;
        }
        m.header = (Header)this.header.clone();
        m.size = this.size;
        return m;
    }

    public boolean findRecord(Record r) {
        return this.sections[1].contains(r) || this.sections[2].contains(r) || this.sections[3].contains(r);
    }

    public boolean findRecord(Record r, int section) {
        return this.sections[section].contains(r);
    }

    public boolean findRRset(Name name, short type) {
        return this.findRRset(name, type, 1) || this.findRRset(name, type, 2) || this.findRRset(name, type, 3);
    }

    public boolean findRRset(Name name, short type, int section) {
        int i = 0;
        while (i < this.sections[section].size()) {
            Record r = (Record)this.sections[section].elementAt(i);
            if (r.getType() == type && name.equals(r.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void freeze() {
        this.frozen = true;
    }

    public Header getHeader() {
        return this.header;
    }

    public OPTRecord getOPT() {
        Record[] additional = this.getSectionArray(3);
        int i = 0;
        while (i < additional.length) {
            if (additional[i] instanceof OPTRecord) {
                return (OPTRecord)additional[i];
            }
            ++i;
        }
        return null;
    }

    public Record getQuestion() {
        try {
            return (Record)this.sections[0].firstElement();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public short getRcode() {
        short rcode = this.header.getRcode();
        OPTRecord opt = this.getOPT();
        if (opt != null) {
            rcode = (short)(rcode + (short)(opt.getExtendedRcode() << 4));
        }
        return rcode;
    }

    public Enumeration getSection(int section) {
        return this.sections[section].elements();
    }

    public Record[] getSectionArray(int section) {
        int size = this.sections[section].size();
        Record[] records = new Record[size];
        int i = 0;
        while (i < size) {
            records[i] = (Record)this.sections[section].elementAt(i);
            ++i;
        }
        return records;
    }

    public TSIGRecord getTSIG() {
        int count = this.header.getCount(3);
        if (count == 0) {
            return null;
        }
        Vector v = this.sections[3];
        Record rec = (Record)v.elementAt(count - 1);
        if (rec.type != 250) {
            return null;
        }
        return (TSIGRecord)rec;
    }

    public boolean isSigned() {
        return this.TSIGsigned;
    }

    public boolean isVerified() {
        return this.TSIGverified;
    }

    public static Message newQuery(Record r) {
        Message m = new Message();
        m.header.setOpcode((byte)0);
        m.header.setFlag(7);
        m.addRecord(r, 0);
        return m;
    }

    public static Message newUpdate(Name zone) {
        Message m = new Message();
        m.header.setOpcode((byte)5);
        Record soa = Record.newRecord(zone, (short)6, (short)1);
        m.addRecord(soa, 0);
        return m;
    }

    public int numBytes() {
        return this.size;
    }

    public void removeAllRecords(int section) {
        this.sections[section].setSize(0);
        this.header.setCount(section, 0);
    }

    public boolean removeRecord(Record r, int section) {
        if (this.sections[section].removeElement(r)) {
            this.header.decCount(section);
            return true;
        }
        return false;
    }

    public String sectionToString(int i) {
        if (i > 3) {
            return null;
        }
        Enumeration e = this.getSection(i);
        StringBuffer sb = new StringBuffer();
        while (e.hasMoreElements()) {
            Record rec = (Record)e.nextElement();
            if (i == 0) {
                sb.append(";;\t" + rec.name);
                sb.append(", type = " + Type.string(rec.type));
                sb.append(", class = " + DClass.string(rec.dclass));
            } else {
                sb.append(rec);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public void setHeader(Header h) {
        this.header = h;
    }

    public void thaw() {
        this.frozen = false;
        this.wireFormat = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        OPTRecord opt = this.getOPT();
        if (opt != null) {
            sb.append(String.valueOf(this.header.toStringWithRcode(this.getRcode())) + "\n");
        } else {
            sb.append(this.header + "\n");
        }
        if (this.isSigned()) {
            sb.append(";; TSIG ");
            if (this.isVerified()) {
                sb.append("ok");
            } else {
                sb.append("invalid");
            }
            sb.append('\n');
        }
        int i = 0;
        while (i < 4) {
            if (this.header.getOpcode() != 5) {
                sb.append(";; " + Section.longString(i) + ":\n");
            } else {
                sb.append(";; " + Section.updString(i) + ":\n");
            }
            sb.append(String.valueOf(this.sectionToString(i)) + "\n");
            ++i;
        }
        sb.append(";; done (" + this.numBytes() + " bytes)");
        return sb.toString();
    }

    public byte[] toWire() throws IOException {
        if (this.frozen && this.wireFormat != null) {
            return this.wireFormat;
        }
        DataByteOutputStream out = new DataByteOutputStream();
        this.toWire(out);
        this.size = out.getPos();
        if (this.frozen) {
            this.wireFormat = out.toByteArray();
            return this.wireFormat;
        }
        return out.toByteArray();
    }

    void toWire(DataByteOutputStream out) throws IOException {
        this.header.toWire(out);
        Compression c = new Compression();
        int i = 0;
        while (i < 4) {
            if (this.sections[i].size() != 0) {
                int j = 0;
                while (j < this.sections[i].size()) {
                    Record rec = (Record)this.sections[i].elementAt(j);
                    rec.toWire(out, i, c);
                    ++j;
                }
            }
            ++i;
        }
    }
}

