/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;
import org.xbill.DNS.utils.base64;

public class KEYRecord
extends Record {
    private short flags;
    private byte proto;
    private byte alg;
    private byte[] key;
    private int footprint = -1;
    public static final int FLAG_NOCONF = 32768;
    public static final int FLAG_NOAUTH = 16384;
    public static final int FLAG_NOKEY = 49152;
    public static final int OWNER_ZONE = 256;
    public static final int OWNER_HOST = 512;
    public static final int OWNER_USER = 0;
    public static final int PROTOCOL_TLS = 1;
    public static final int PROTOCOL_EMAIL = 2;
    public static final int PROTOCOL_DNSSEC = 3;
    public static final int PROTOCOL_IPSEC = 4;
    public static final int PROTOCOL_ANY = 255;

    private KEYRecord() {
    }

    public KEYRecord(Name _name, short _dclass, int _ttl, int _flags, int _proto, int _alg, byte[] _key) {
        super(_name, (short)25, _dclass, _ttl);
        this.flags = (short)_flags;
        this.proto = (byte)_proto;
        this.alg = (byte)_alg;
        this.key = _key;
    }

    KEYRecord(Name _name, short _dclass, int _ttl, int length, DataByteInputStream in) throws IOException {
        super(_name, (short)25, _dclass, _ttl);
        if (in == null) {
            return;
        }
        this.flags = in.readShort();
        this.proto = in.readByte();
        this.alg = in.readByte();
        if (length > 4) {
            this.key = new byte[length - 4];
            in.read(this.key);
        }
    }

    KEYRecord(Name _name, short _dclass, int _ttl, MyStringTokenizer st, Name origin) throws IOException {
        super(_name, (short)25, _dclass, _ttl);
        this.flags = (short)Integer.decode(st.nextToken()).intValue();
        this.proto = (byte)Integer.parseInt(st.nextToken());
        this.alg = (byte)Integer.parseInt(st.nextToken());
        this.key = (byte[])((this.flags & 0xC000) != 49152 ? base64.fromString(st.remainingTokens()) : null);
    }

    public byte getAlgorithm() {
        return this.alg;
    }

    public short getFlags() {
        return this.flags;
    }

    public short getFootprint() {
        if (this.footprint >= 0) {
            return (short)this.footprint;
        }
        int foot = 0;
        DataByteOutputStream out = new DataByteOutputStream();
        try {
            this.rrToWire(out, null);
        }
        catch (IOException iOException) {}
        byte[] rdata = out.toByteArray();
        if (this.alg == 1) {
            int d1 = rdata[rdata.length - 3] & 0xFF;
            int d2 = rdata[rdata.length - 2] & 0xFF;
            foot = (d1 << 8) + d2;
        } else {
            int d1;
            int i = 0;
            while (i < rdata.length - 1) {
                d1 = rdata[i] & 0xFF;
                int d2 = rdata[i + 1] & 0xFF;
                foot += (d1 << 8) + d2;
                i += 2;
            }
            if (i < rdata.length) {
                d1 = rdata[i] & 0xFF;
                foot += d1 << 8;
            }
            foot += foot >> 16 & 0xFFFF;
        }
        this.footprint = foot & 0xFFFF;
        return (short)this.footprint;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte getProtocol() {
        return this.proto;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.key != null || (this.flags & 0xC000) == 49152) {
            if (!Options.check("nohex")) {
                sb.append("0x");
                sb.append(Integer.toHexString(this.flags & 0xFFFF));
            } else {
                sb.append(this.flags & 0xFFFF);
            }
            sb.append(" ");
            sb.append(this.proto & 0xFF);
            sb.append(" ");
            sb.append(this.alg & 0xFF);
            if (this.key != null) {
                sb.append(" (\n");
                sb.append(base64.formatString(this.key, 64, "\t", true));
                sb.append(" ; key_tag = ");
                sb.append(this.getFootprint() & 0xFFFF);
            }
        }
        return sb.toString();
    }

    void rrToWire(DataByteOutputStream out, Compression c) throws IOException {
        if (this.key == null && (this.flags & 0xC000) != 49152) {
            return;
        }
        out.writeShort(this.flags);
        out.writeByte(this.proto);
        out.writeByte(this.alg);
        if (this.key != null) {
            out.write(this.key);
        }
    }
}

