/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.xbill.DNS.Address;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class ARecord
extends Record {
    private byte[] addr;

    private ARecord() {
    }

    ARecord(Name _name, short _dclass, int _ttl, int length, DataByteInputStream in) throws IOException {
        super(_name, (short)1, _dclass, _ttl);
        if (in == null) {
            return;
        }
        this.addr = new byte[4];
        in.read(this.addr);
    }

    public ARecord(Name _name, short _dclass, int _ttl, InetAddress _address) throws IOException {
        super(_name, (short)1, _dclass, _ttl);
        this.addr = _address.getAddress();
    }

    ARecord(Name _name, short _dclass, int _ttl, MyStringTokenizer st, Name origin) throws IOException {
        super(_name, (short)1, _dclass, _ttl);
        String s = st.nextToken();
        if (s.equals("@me@")) {
            try {
                InetAddress address = InetAddress.getLocalHost();
                if (address.equals(InetAddress.getByName("127.0.0.1"))) {
                    String msg = "InetAddress.getLocalHost() is broken.  Don't use @me@.";
                    throw new RuntimeException(msg);
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.addr = null;
            }
        } else {
            if (!Address.isDottedQuad(s)) {
                throw new IOException("Invalid dotted quad address");
            }
            this.addr = InetAddress.getByName(s).getAddress();
        }
    }

    public InetAddress getAddress() {
        String s = Address.toDottedQuad(this.addr);
        try {
            return InetAddress.getByName(s);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.addr != null) {
            int i = 0;
            while (i < this.addr.length) {
                sb.append(this.addr[i] & 0xFF);
                if (i < this.addr.length - 1) {
                    sb.append(".");
                }
                ++i;
            }
        }
        return sb.toString();
    }

    void rrToWire(DataByteOutputStream out, Compression c) throws IOException {
        if (this.addr == null) {
            return;
        }
        out.write(this.addr);
    }
}

