/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Inet6Address;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class AAAARecord
extends Record {
    private short prefixBits;
    private Inet6Address address;
    private Name prefix;

    private AAAARecord() {
    }

    public AAAARecord(Name _name, short _dclass, int _ttl, int _prefixBits, Inet6Address _address, Name _prefix) throws IOException {
        super(_name, (short)28, _dclass, _ttl);
        this.address = _address;
    }

    AAAARecord(Name _name, short _dclass, int _ttl, int length, DataByteInputStream in) throws IOException {
        super(_name, (short)28, _dclass, _ttl);
        if (in == null) {
            return;
        }
        byte[] data = new byte[16];
        in.read(data);
        this.address = new Inet6Address(data);
    }

    AAAARecord(Name _name, short _dclass, int _ttl, MyStringTokenizer st, Name origin) throws IOException {
        super(_name, (short)28, _dclass, _ttl);
        this.address = new Inet6Address(st.nextToken());
    }

    public Inet6Address getAddress() {
        return this.address;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.address != null) {
            sb.append(this.address);
        }
        return sb.toString();
    }

    void rrToWire(DataByteOutputStream out, Compression c) throws IOException {
        if (this.address == null) {
            return;
        }
        out.write(this.address.toBytes());
    }
}

