/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.storage;

import java.io.Serializable;
import net.zerotoaster.mta.storage.StorageRecord;

public class FetchmailRecord
extends StorageRecord
implements Serializable {
    public static final String KEYDATA_APPL_RECORD = "FETCHMAIL_RECORD";
    private String strUserFrom = null;
    private String strHost = null;
    private String strPassword = null;
    private String strUserTo = null;
    private int intPollFrequency = 0;

    public FetchmailRecord() {
        this.init();
    }

    public boolean equals(Object o) {
        if (!(o instanceof FetchmailRecord)) {
            return false;
        }
        FetchmailRecord fm = (FetchmailRecord)o;
        if (!fm.strUserFrom.equals(this.strUserFrom)) {
            return false;
        }
        if (!fm.strHost.equals(this.strHost)) {
            return false;
        }
        if (!fm.strPassword.equals(this.strPassword)) {
            return false;
        }
        if (!fm.strUserTo.equals(this.strUserTo)) {
            return false;
        }
        return fm.intPollFrequency == this.intPollFrequency;
    }

    public String getHost() {
        return this.strHost;
    }

    public String getPassword() {
        return this.strPassword;
    }

    public int getPollFrequency() {
        return this.intPollFrequency;
    }

    public String getUserFrom() {
        return this.strUserFrom;
    }

    public String getUserTo() {
        return this.strUserTo;
    }

    public void init() {
        this.strUserFrom = "";
        this.strHost = "";
        this.strPassword = "";
        this.strUserTo = "";
        this.intPollFrequency = 120;
    }

    public String recordExport() {
        StringBuffer strb = new StringBuffer();
        strb.append(this.strUserFrom);
        strb.append('\u0014');
        strb.append(this.strHost);
        strb.append('\u0014');
        strb.append(this.strPassword);
        strb.append('\u0014');
        strb.append(this.strUserTo);
        strb.append('\u0014');
        strb.append(this.intPollFrequency);
        strb.append('\u0014');
        return strb.toString();
    }

    public void recordImport(String str) {
        this.initTokenizer(str);
        this.strUserFrom = this.nextToken();
        this.strHost = this.nextToken();
        this.strPassword = this.nextToken();
        this.strUserTo = this.nextToken();
        this.intPollFrequency = this.nextTokenInteger();
    }

    public void setHost(String s) {
        this.strHost = s.toLowerCase().trim();
    }

    public void setPassword(String s) {
        this.strPassword = s.trim();
    }

    public void setPollFrequency(int i) {
        this.intPollFrequency = i;
    }

    public void setUserFrom(String s) {
        this.strUserFrom = s.toLowerCase().trim();
    }

    public void setUserTo(String s) {
        this.strUserTo = s.toLowerCase().trim();
    }

    public String toString() {
        return String.valueOf(this.getUserFrom()) + " " + this.getPollFrequency() + " sec interval";
    }
}

