/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.storage;

import de.zwanzigeins.util.HelperValidate;
import de.zwanzigeins.util.IP_Network;
import java.io.Serializable;
import net.zerotoaster.mta.storage.StorageRecord;
import net.zerotoaster.mta.util.Helper;

public class DomainRecord
extends StorageRecord
implements Serializable {
    private String strDomainName = null;
    private boolean blnEnable_POP3 = false;
    private boolean blnEnable_SMTP = false;
    private boolean blnSMTP_after_POP3 = false;
    private int intSessionTimeout = -1;
    private IP_Network[] ipNetwork = null;
    private String strCatchAll = null;
    private String strMemo = null;
    private boolean blnAVScan = false;
    private int intQuota_Days;
    private int intQuota_Mails;
    private int intQuota_MB;
    private String strDomainAlias = null;

    public DomainRecord() {
        this.init();
    }

    public boolean getAVScan() {
        return this.blnAVScan;
    }

    public String getCatchAll() {
        return this.strCatchAll;
    }

    public String getDomainAlias() {
        return this.strDomainAlias;
    }

    public String getDomainName() {
        return this.strDomainName;
    }

    public boolean getEnable_POP3() {
        return this.blnEnable_POP3;
    }

    public boolean getEnable_SMTP() {
        return this.blnEnable_SMTP;
    }

    public IP_Network[] getIP_Networks() {
        return this.ipNetwork;
    }

    public String getMemo() {
        return this.strMemo;
    }

    public int getQuota_Days() {
        return this.intQuota_Days;
    }

    public int getQuota_Mails() {
        return this.intQuota_Mails;
    }

    public int getQuota_MB() {
        return this.intQuota_MB;
    }

    public int getSessionTimeout() {
        return this.intSessionTimeout;
    }

    public boolean getSMTP_after_POP3() {
        return this.blnSMTP_after_POP3;
    }

    public void init() {
        this.strDomainName = "";
        this.blnEnable_POP3 = true;
        this.blnEnable_SMTP = true;
        this.blnSMTP_after_POP3 = true;
        this.intSessionTimeout = 30;
        this.ipNetwork = new IP_Network[0];
        this.strCatchAll = "";
        this.strMemo = "";
        this.intQuota_Days = 0;
        this.intQuota_Mails = 0;
        this.intQuota_MB = 0;
        this.strDomainAlias = "";
    }

    public String recordExport() {
        StringBuffer strb = new StringBuffer();
        strb.append(this.strDomainName);
        strb.append('\u0014');
        strb.append(this.blnEnable_POP3);
        strb.append('\u0014');
        strb.append(this.blnEnable_SMTP);
        strb.append('\u0014');
        strb.append(this.blnSMTP_after_POP3);
        strb.append('\u0014');
        strb.append(this.intSessionTimeout);
        strb.append('\u0014');
        strb.append(StorageRecord.conv_networks2string(this.ipNetwork));
        strb.append('\u0014');
        strb.append("");
        strb.append('\u0014');
        strb.append(this.strCatchAll);
        strb.append('\u0014');
        strb.append(this.strMemo);
        strb.append('\u0014');
        strb.append(this.blnAVScan);
        strb.append('\u0014');
        strb.append(0);
        strb.append('\u0014');
        strb.append("");
        strb.append('\u0014');
        strb.append("");
        strb.append('\u0014');
        strb.append(0);
        strb.append('\u0014');
        strb.append(0);
        strb.append('\u0014');
        strb.append(0);
        strb.append('\u0014');
        strb.append("");
        strb.append('\u0014');
        strb.append(0);
        strb.append('\u0014');
        strb.append(0);
        strb.append('\u0014');
        strb.append(this.intQuota_Days);
        strb.append('\u0014');
        strb.append(this.intQuota_Mails);
        strb.append('\u0014');
        strb.append(this.intQuota_MB);
        strb.append('\u0014');
        strb.append(this.strDomainAlias);
        strb.append('\u0014');
        return strb.toString();
    }

    public void recordImport(String str) {
        this.initTokenizer(str);
        this.strDomainName = this.nextToken();
        this.blnEnable_POP3 = this.nextTokenBoolean();
        this.blnEnable_SMTP = this.nextTokenBoolean();
        this.blnSMTP_after_POP3 = this.nextTokenBoolean();
        this.intSessionTimeout = this.nextTokenInteger();
        this.ipNetwork = StorageRecord.conv_string2networks(this.nextToken());
        this.nextToken();
        this.strCatchAll = this.nextToken();
        this.strMemo = this.nextToken();
        if (this.hasMoreTokens()) {
            this.blnAVScan = this.nextTokenBoolean();
        }
        if (this.hasMoreTokens()) {
            try {
                this.nextTokenInteger();
                this.nextToken();
                this.nextToken();
                this.nextTokenInteger();
                this.nextTokenInteger();
                this.nextTokenInteger();
                this.nextToken();
                this.nextTokenInteger();
                this.nextTokenInteger();
                this.intQuota_Days = this.nextTokenInteger();
                this.intQuota_Mails = this.nextTokenInteger();
                this.intQuota_MB = this.nextTokenInteger();
            }
            catch (Throwable throwable) {}
        }
        if (this.hasMoreTokens()) {
            this.strDomainAlias = this.nextToken();
        }
    }

    public void setAVScan(boolean b) {
        this.blnAVScan = b;
    }

    public void setCatchAll(String s) {
        this.strCatchAll = Helper.limit(s.toLowerCase(), 129);
    }

    public void setDomainAlias(String s) {
        this.strDomainAlias = Helper.limit(s, 64);
    }

    public void setDomainName(String s) {
        String strTmp = Helper.limit(s.toLowerCase(), 64);
        if ((strTmp = HelperValidate.validateRFC822_Domain((String)strTmp)) == null) {
            throw new IllegalArgumentException("'" + s + "' is not a valid domain name");
        }
        this.strDomainName = strTmp;
    }

    public void setEnable_POP3(boolean b) {
        this.blnEnable_POP3 = b;
    }

    public void setEnable_SMTP(boolean b) {
        this.blnEnable_SMTP = b;
    }

    public void setIP_Networks(IP_Network[] ip) {
        this.ipNetwork = ip;
    }

    public void setMemo(String s) {
        this.strMemo = Helper.limit(s, 512);
    }

    public void setQuota_Days(int i) {
        this.intQuota_Days = i;
    }

    public void setQuota_Mails(int i) {
        this.intQuota_Mails = i;
    }

    public void setQuota_MB(int i) {
        this.intQuota_MB = i;
    }

    public void setSessionTimeout(int intSeconds) {
        this.intSessionTimeout = intSeconds;
    }

    public void setSMTP_after_POP3(boolean b) {
        this.blnSMTP_after_POP3 = b;
    }

    public String toString() {
        return this.getDomainName();
    }
}

