/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.main;

import de.zwanzigeins.util.Application;
import de.zwanzigeins.util.InitializationException;
import de.zwanzigeins.util.LockObject;
import de.zwanzigeins.util.LogContext;
import de.zwanzigeins.util.TimeFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import net.zerotoaster.mta.config.Configuration;
import net.zerotoaster.mta.config.Constants;
import net.zerotoaster.mta.event.CleanupEvent;
import net.zerotoaster.mta.event.KickForwarder;
import net.zerotoaster.mta.event.MTAEvent;
import net.zerotoaster.mta.event.MTAEventListener;
import net.zerotoaster.mta.event.MTAEventQueue;
import net.zerotoaster.mta.event.PostmasterAlert;
import net.zerotoaster.mta.event.RescanEvent;
import net.zerotoaster.mta.event.RestartEvent;
import net.zerotoaster.mta.event.RestartFullyEvent;
import net.zerotoaster.mta.event.ShutdownEvent;
import net.zerotoaster.mta.main.FWD_ServerContainer;
import net.zerotoaster.mta.main.ML_Import;
import net.zerotoaster.mta.main.MPA_ServerContainer;
import net.zerotoaster.mta.main.Mail;
import net.zerotoaster.mta.main.POP3_Fetchmail;
import net.zerotoaster.mta.main.POP3_ServerContainer;
import net.zerotoaster.mta.main.SMTP_ServerContainer;
import net.zerotoaster.mta.main.ServerContainer;
import net.zerotoaster.mta.storage.RemoteStorageManager_Server;
import net.zerotoaster.mta.storage.StorageException;
import net.zerotoaster.mta.util.Helper;
import org.xbill.Task.WorkerThread;

public class ZeroToaster
extends Application
implements Runnable,
MTAEventListener,
Constants {
    private LogContext logContext = null;
    private Configuration cnfConfig = null;
    private Vector vecContainers = null;
    private Thread thrd = null;
    private boolean blnIsRunning = false;
    private LockObject objLock = null;
    private RemoteStorageManager_Server rsmManager = null;
    private POP3_Fetchmail popFetchmail = null;
    private ML_Import mlImport = null;
    private net.zerotoaster.httpd.main.ZeroToaster ztHTTPD = null;

    public ZeroToaster() {
        this.setThreadName("ZT-MTA");
        this.init();
        this.resetThreadName();
    }

    private LogContext createLogContext() {
        LogContext log = null;
        if (this.cnfConfig.strLogScrn_Options.length() == 0) {
            this.cnfConfig.strLogScrn_Options = this.cnfConfig.strLogFile_Options;
        }
        try {
            log = new LogContext(this.cnfConfig.strLogFile_Path, this.cnfConfig.strLogFile_Praefix, this.cnfConfig.strLogFile_Suffix);
            log.setDateFormat(this.cnfConfig.strLogFile_DateFormat);
            log.setTimeFormat(this.cnfConfig.strLogFile_TimeFormat);
            log.setFilter_File(this.cnfConfig.strLogFile_Options);
            log.setFilter_Screen(this.cnfConfig.strLogScrn_Options);
            log.setYesterdayFile(this.cnfConfig.strLogFile_Yesterday);
            log.setLogfileKeep(this.cnfConfig.intLogFile_Keep);
            log.write("# Logfile opened");
            return log;
        }
        catch (IOException e) {
            System.err.println("Cannot open logfile");
            System.err.println(e);
            return null;
        }
    }

    private boolean createServerContainers() {
        ServerContainer sc;
        this.vecContainers = new Vector(3);
        try {
            this.logContext.write("# Starting POP3 container");
            sc = new POP3_ServerContainer();
            this.vecContainers.addElement(sc);
        }
        catch (InitializationException initializationException) {
            return false;
        }
        catch (Throwable t) {
            this.logContext.write("? Unhandled exception during creation of POP3 server container", t);
            return false;
        }
        try {
            this.logContext.write("# Starting SMTP container");
            sc = new SMTP_ServerContainer();
            this.vecContainers.addElement(sc);
        }
        catch (InitializationException initializationException) {
            return false;
        }
        catch (Throwable t) {
            this.logContext.write("? Unhandled exception during creation of SMTP server container", t);
            return false;
        }
        try {
            this.logContext.write("# Starting FWD container");
            sc = new FWD_ServerContainer();
            this.vecContainers.addElement(sc);
        }
        catch (InitializationException initializationException) {
            return false;
        }
        catch (Throwable t) {
            this.logContext.write("? Unhandled exception during creation of FWD server container", t);
            return false;
        }
        try {
            this.logContext.write("# Starting MPA server container");
            sc = new MPA_ServerContainer();
            this.vecContainers.addElement(sc);
        }
        catch (InitializationException initializationException) {
            return false;
        }
        catch (Throwable t) {
            this.logContext.write("? Unhandled exception during creation of MPA server container", t);
            return false;
        }
        try {
            this.logContext.write("# Starting POP3 fetchmail");
            this.popFetchmail = new POP3_Fetchmail();
        }
        catch (Throwable t) {
            this.logContext.write("? Unhandled exception during creation of POP3 Fetcher", t);
            return false;
        }
        if (this.cnfConfig.blnMailImportEnabled) {
            this.logContext.write("# Starting mail import process");
            try {
                this.mlImport = new ML_Import();
            }
            catch (Throwable t) {
                this.logContext.write("? Unhandled exception during creation of MailImport", t);
                return false;
            }
        }
        return true;
    }

    public void dispose() {
        if (this.logContext != null) {
            this.logContext.setSlowDown(0L);
        }
        this.blnDisposed = true;
        Thread t = this.thrd;
        if (t != null) {
            this.blnIsRunning = false;
            this.objLock.lo_notify();
            this.thrd = null;
        }
        if (this.objLock != null) {
            this.objLock.dispose();
            this.objLock = null;
        }
        if (this.popFetchmail != null) {
            this.logContext.write("D Initiating dispose POP3 Fetchmail");
            this.popFetchmail.dispose();
            this.popFetchmail = null;
        }
        if (this.mlImport != null) {
            this.logContext.write("D Initiating dispose MailImport");
            this.mlImport.dispose();
            this.mlImport = null;
        }
        if (this.vecContainers != null) {
            int i = 0;
            while (i < this.vecContainers.size()) {
                ServerContainer sc = (ServerContainer)this.vecContainers.elementAt(i);
                this.logContext.write("D Initiating dispose " + sc.getClass().getName());
                sc.dispose();
                ++i;
            }
            this.vecContainers.removeAllElements();
            this.vecContainers = null;
        }
        if (this.rsmManager != null) {
            this.logContext.write("D Initiating dispose RSM Manager");
            this.rsmManager.dispose();
            this.rsmManager = null;
        }
        if (this.logContext != null) {
            this.logContext.write("# Stopped ---------------------------");
            this.logContext.dispose();
            this.logContext = null;
        }
        if (this.ztHTTPD != null) {
            this.ztHTTPD.dispose();
            this.ztHTTPD = null;
        }
        MTAEventQueue.dispose();
        Configuration.dispose();
    }

    public static final String getCopyRight() {
        return Constants.COPYRIGHT;
    }

    public static final String getVersion() {
        Properties properties = System.getProperties();
        String s = properties.getProperty("os.name");
        s = String.valueOf(s) + " v" + properties.getProperty("os.version");
        s = String.valueOf(s) + " (" + properties.getProperty("os.arch") + ")";
        String ss = Configuration.getConfig().strFakedOS;
        if (ss.length() > 0) {
            s = ss;
        }
        return "ZeroToaster::MTA 2.80 " + s;
    }

    private void init() {
        this.blnDisposed = false;
        MTAEventQueue.addListener(this);
        this.objLock = new LockObject();
        this.cnfConfig = Configuration.getConfig();
        if (this.cnfConfig == null) {
            this.dispose();
        }
        WorkerThread.setMaxThreads((int)50);
        this.stats_read();
        this.logContext = this.createLogContext();
        if (this.logContext == null) {
            this.dispose();
            return;
        }
        Configuration.logContext = this.logContext;
        MTAEventQueue.setConfiguration(this.logContext, this.cnfConfig);
        this.sysinfo();
        try {
            this.logContext.write("# loading storage manager");
            this.rsmManager = new RemoteStorageManager_Server();
            this.rsmManager.quotaCleanup();
            this.rsmManager.cleanup(true);
        }
        catch (Throwable t) {
            this.logContext.write("? Error loading storage manager", t);
            this.dispose();
            return;
        }
        try {
            this.rsmManager.licenceCheck();
        }
        catch (StorageException e) {
            this.logContext.write("? Error during licence check", (Throwable)e);
            this.dispose();
            return;
        }
        try {
            this.rsmManager.initRemoteControl();
        }
        catch (InitializationException initializationException) {
            this.dispose();
            return;
        }
        if (!this.createServerContainers()) {
            this.dispose();
            return;
        }
        this.thrd = new Thread(this);
        this.thrd.setName("Watchdog");
        this.thrd.setPriority(1);
        this.blnIsRunning = true;
        this.thrd.start();
        this.logContext.write("# Waiting for threads coming up");
        LockObject objLock = new LockObject();
        objLock.lo_wait(2000L);
        objLock.dispose();
        try {
            long AMODE = 8L;
            this.ztHTTPD = new net.zerotoaster.httpd.main.ZeroToaster(AMODE |= 2L, "webres/");
        }
        catch (Throwable throwable) {
            this.logContext.write("D Web backend not available");
        }
        this.logContext.write("# Started ---------------------------");
        if (this.cnfConfig.blnNotify_Startup) {
            MTAEventQueue.postEvent(new PostmasterAlert("Zerotoaster started"));
        }
    }

    public static void main(String[] args) {
        if (args.length > 0 && args[0].equals("-version")) {
            System.out.println("ZeroToaster::MTA 2.80");
            System.exit(0);
        }
        System.out.println(ZeroToaster.getVersion());
        System.out.println(Constants.COPYRIGHT);
        ZeroToaster z = null;
        try {
            z = new ZeroToaster();
        }
        catch (Throwable t) {
            if (z != null && z.logContext != null) {
                z.logContext.write("? Unhandled exception in .init():", t);
                z.logContext.dispose();
            }
            System.out.println("Unhandled exception in .init():");
            t.printStackTrace();
        }
    }

    public void mtaEvent(MTAEvent e) {
        if (e instanceof ShutdownEvent) {
            this.dispose();
            Runtime.runFinalizersOnExit((boolean)this.cnfConfig.blnRunFinalizersOnExit);
            System.exit(0);
            return;
        }
        if (e instanceof RestartEvent) {
            this.stats_write();
            this.dispose();
            if (this.cnfConfig.blnRunFinalizers) {
                Runtime.getRuntime().runFinalization();
                System.gc();
            }
            this.init();
            return;
        }
        if (e instanceof RestartFullyEvent) {
            this.stats_write();
            this.dispose();
            Runtime.runFinalizersOnExit((boolean)this.cnfConfig.blnRunFinalizersOnExit);
            System.exit(50);
            return;
        }
        if (e instanceof CleanupEvent) {
            this.rsmManager.quotaCleanup();
            this.rsmManager.cleanup(false);
            return;
        }
        if (e instanceof RescanEvent) {
            MTAEventQueue.postEvent(new KickForwarder());
            return;
        }
        if (e instanceof PostmasterAlert) {
            PostmasterAlert pma = (PostmasterAlert)e;
            Mail m = new Mail(this.logContext, this.cnfConfig, this.rsmManager);
            String strVersion = "ZeroToaster::MTA 2.80";
            StringBuffer strb = new StringBuffer();
            if (this.cnfConfig.strSystemName.length() > 0) {
                strb.append(strVersion);
                strb.append("@");
                strb.append(this.cnfConfig.strSystemName);
                m.setSubject(strb.toString());
                m.setMailFrom_Name(this.cnfConfig.strSystemName);
            } else {
                strb.append("Alert from ");
                strb.append(strVersion);
                m.setSubject(strb.toString());
                m.setMailFrom_Name(strVersion);
            }
            strb.setLength(0);
            strb.append("Message:\r\n");
            strb.append("-----------------------------------------------------\r\n");
            strb.append(pma.strMessage);
            strb.append("\r\n");
            strb.append("-----------------------------------------------------\r\n");
            strb.append(strVersion);
            strb.append(" ");
            Properties properties = System.getProperties();
            strb.append(properties.getProperty("os.name"));
            strb.append(" v");
            strb.append(properties.getProperty("os.version"));
            strb.append(" (");
            strb.append(properties.getProperty("os.arch"));
            strb.append(")\r\n");
            m.setMailFrom_EMail("");
            m.setMailTo_EMail("postmaster");
            m.setContent(strb.toString());
            m.store();
        }
    }

    public void run() {
        boolean blnLogged = false;
        Throwable thrwError = null;
        try {
            this.watchdog();
        }
        catch (Throwable t1) {
            thrwError = t1;
            try {
                this.logContext.write("? Unhandled exception", t1);
                this.logContext.write("? Watchdog is stopped");
                blnLogged = true;
            }
            catch (Throwable throwable) {}
        }
        if (!blnLogged && thrwError != null) {
            System.out.println("ZeroToaster Watchdog error, stop");
            thrwError.printStackTrace();
            Helper.writeLog("ZeroToaster Watchdog error, stop");
            Helper.writeLog(thrwError);
        }
    }

    private void stats_read() {
        File f = new File("stats.$$$");
        if (!f.exists()) {
            return;
        }
        if (!this.cnfConfig.blnKeepStats) {
            f.delete();
            return;
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader("stats.$$$"));
            this.cnfConfig.statrec.recordImport(br.readLine());
            br.close();
        }
        catch (IOException e) {
            this.logContext.write("? Cannot read statistics record", (Throwable)e);
        }
        f.delete();
    }

    private void stats_write() {
        if (!this.cnfConfig.blnKeepStats) {
            return;
        }
        try {
            PrintWriter pw = new PrintWriter(new FileWriter("stats.$$$"));
            pw.println(this.cnfConfig.statrec.recordExport());
            pw.flush();
            pw.close();
        }
        catch (IOException e) {
            this.logContext.write("? Cannot write statistics record", (Throwable)e);
        }
    }

    private void sysinfo() {
        Properties properties = System.getProperties();
        this.logContext.write("# ---------------------------------------------------------------------------");
        this.logContext.write("# ZeroToaster::MTA 2.80");
        this.logContext.write("# Operating System: " + properties.getProperty("os.name") + ", " + properties.getProperty("os.version") + ", " + properties.getProperty("os.arch"));
        this.logContext.write("# Java System     : " + properties.getProperty("java.version") + ", " + properties.getProperty("java.vendor"));
        this.logContext.write("# Available Memory: " + Helper.formatMemoryString(Runtime.getRuntime().totalMemory()));
        this.logContext.write("# Timezone used   : " + this.cnfConfig.strTimeZone);
        this.logContext.write("# Locale used     : " + Locale.getDefault());
        this.logContext.write("# Nameservers     : " + this.cnfConfig.strNameServer);
        this.logContext.write("# Licence         : " + this.cnfConfig.lic.toString());
        this.logContext.write("# ---------------------------------------------------------------------------");
    }

    private void watchdog() {
        long lngLastCleanup;
        this.logContext.write("D Started");
        File flShutdown = new File("shutdown");
        File flRestart = new File("restart");
        File flFullRestart = new File("fullrestart");
        File flCleanup = new File("cleanup");
        File flRescan = new File("rescan");
        File flLicCheck = new File("liccheck");
        File flDebugDump = new File("debugdump");
        flShutdown.delete();
        flRestart.delete();
        flFullRestart.delete();
        flCleanup.delete();
        flRescan.delete();
        flLicCheck.delete();
        flDebugDump.delete();
        long lngLastSemCheck = lngLastCleanup = TimeFactory.getTime();
        long lngLastMemCheck = lngLastCleanup;
        long lngLastLicCheck = lngLastCleanup;
        while (this.blnIsRunning) {
            long lngCurrentTime = TimeFactory.getTime();
            if (lngCurrentTime - lngLastSemCheck > (long)this.cnfConfig.intSemaphoreCheck) {
                if (flShutdown.exists()) {
                    flShutdown.delete();
                    this.logContext.write("# Shutdown initiated");
                    MTAEventQueue.postEvent(new ShutdownEvent());
                    break;
                }
                if (flRestart.exists()) {
                    flRestart.delete();
                    this.logContext.write("# Restart initiated");
                    MTAEventQueue.postEvent(new RestartEvent());
                    break;
                }
                if (flFullRestart.exists()) {
                    flFullRestart.delete();
                    this.logContext.write("# Full restart initiated");
                    MTAEventQueue.postEvent(new RestartFullyEvent());
                    break;
                }
                if (flRescan.exists()) {
                    flRescan.delete();
                    this.logContext.write("# Rescan initiated");
                    MTAEventQueue.postEvent(new RescanEvent());
                }
                if (this.cnfConfig.blnRestartWhenConfigChanged && Configuration.isModified()) {
                    this.logContext.write("# Restart initiated by config change");
                    MTAEventQueue.postEvent(new RestartEvent());
                    break;
                }
                lngLastSemCheck = lngCurrentTime;
            }
            if (lngCurrentTime - lngLastCleanup > (long)this.cnfConfig.intMailCleanup * 60L * 1000L || flCleanup.exists()) {
                flCleanup.delete();
                MTAEventQueue.postEvent(new CleanupEvent());
                lngLastCleanup = lngCurrentTime;
            }
            if (this.cnfConfig.intMemorycheck != 0 && lngCurrentTime - lngLastMemCheck > (long)this.cnfConfig.intMemorycheck * 1000L) {
                if (this.cnfConfig.blnMemorycheck_finalisation) {
                    this.logContext.write("D Memcheck:finalizer");
                    Runtime.getRuntime().runFinalization();
                }
                if (this.cnfConfig.blnMemorycheck_gc) {
                    this.logContext.write("D Memcheck:GC");
                    System.gc();
                }
                long lngMemTotal = Runtime.getRuntime().totalMemory() / 1024L;
                long lngMemFree = Runtime.getRuntime().freeMemory() / 1024L;
                this.logContext.write("! Mem. total " + lngMemTotal + "kB used: " + (lngMemTotal - lngMemFree) + "kB");
                lngLastMemCheck = TimeFactory.getTime();
            }
            this.cnfConfig.statrec.lngMemory_total = Runtime.getRuntime().totalMemory();
            this.cnfConfig.statrec.lngMemory_free = Runtime.getRuntime().freeMemory();
            if (lngCurrentTime - lngLastLicCheck > 1800000L || flLicCheck.exists()) {
                flLicCheck.delete();
                this.rsmManager.licenceCheck();
                lngLastLicCheck = lngCurrentTime;
            }
            this.objLock.lo_wait(1000L);
        }
        if (this.logContext != null) {
            this.logContext.write("# Watchdog closed without error");
        }
    }
}

