/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.main;

import de.zwanzigeins.util.HelperExtract;
import java.net.InetAddress;
import net.zerotoaster.mta.config.Configuration;
import net.zerotoaster.mta.io.LineServerSocket;
import net.zerotoaster.mta.io.LineSocket;
import net.zerotoaster.mta.main.ServerContainer;
import net.zerotoaster.mta.main.ServerInstance;
import net.zerotoaster.mta.util.Helper;

public abstract class ServerSocketContainer
extends ServerContainer {
    private LineServerSocket lssok = null;
    protected String strHost = null;
    protected int intPort = -1;
    protected int intSocketTimeout = 0;

    public ServerSocketContainer(String strContainerName) {
        super(strContainerName);
    }

    public void dispose() {
        this.blnIsRunning = false;
        super.dispose();
        if (this.lssok != null) {
            try {
                this.lssok.close();
            }
            catch (Throwable t) {
                Configuration.logContext.write("? Problems disposing ServerSocket", t);
            }
            this.lssok = null;
        }
    }

    protected abstract String getBusyMessage();

    protected boolean init() throws Throwable {
        if (!super.init()) {
            return false;
        }
        String strID = this.strContainerName.toUpperCase().trim();
        if (strID.equals("POP3")) {
            this.strHost = HelperExtract.splitIP_getHost((String)this.cnf.strPOP3_Host);
            this.intPort = HelperExtract.splitIP_getPort((String)this.cnf.strPOP3_Host, (int)110);
            this.intSocketTimeout = this.cnf.intPOP3_Socket_Timeout;
        }
        if (strID.equals("SMTP")) {
            this.strHost = HelperExtract.splitIP_getHost((String)this.cnf.strSMTP_Host);
            this.intPort = HelperExtract.splitIP_getPort((String)this.cnf.strSMTP_Host, (int)25);
            this.intSocketTimeout = this.cnf.intSMTP_Socket_Timeout;
        }
        return true;
    }

    public void run() {
        Configuration.logContext.write("D Opening Server Socket on " + this.strHost + ":" + this.intPort);
        try {
            InetAddress ina = null;
            if (!this.strHost.equals("*")) {
                ina = InetAddress.getByName(this.strHost);
            }
            this.lssok = new LineServerSocket(this.intPort, this.intInstances, ina);
            Configuration.logContext.write("D Server Socket opened (" + this.lssok.getInetAddress() + ")");
            this.blnIsRunning = true;
            this.loThreadStarted.lo_notify();
        }
        catch (Throwable t) {
            Configuration.logContext.write("? Error creating server socket", t);
            this.blnIsRunning = false;
            this.loThreadStarted.lo_notify();
            return;
        }
        LineSocket lsok = null;
        while (this.blnIsRunning) {
            try {
                Configuration.logContext.write("D Waiting for requests");
                lsok = this.lssok.accept();
                if (!this.blnIsRunning) {
                    Configuration.logContext.write("# Shutdown");
                    return;
                }
                lsok.setSoTimeout(this.intSocketTimeout * 1000);
                Configuration.logContext.write("D Incoming request " + lsok.getInetAddress());
            }
            catch (Throwable t) {
                Helper.close(lsok);
                Helper.close(this.lssok);
                lsok = null;
                this.lssok = null;
                if (!this.blnIsRunning) {
                    return;
                }
                Configuration.logContext.write("? Problem in ssok.accept() - abort ", t);
                this.dispose();
                return;
            }
            ServerInstance si = this.getFreeInstance();
            if (si == null) {
                try {
                    lsok.println(this.getBusyMessage());
                    lsok.flush();
                    lsok.close();
                    continue;
                }
                catch (Throwable throwable) {}
            }
            si.kickInstance(lsok);
        }
    }
}

