/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.main;

import de.zwanzigeins.util.Application;
import de.zwanzigeins.util.InitializationException;
import de.zwanzigeins.util.LockObject;
import de.zwanzigeins.util.TimeFactory;
import net.zerotoaster.mta.config.Configuration;
import net.zerotoaster.mta.config.Constants;
import net.zerotoaster.mta.storage.StorageException;
import net.zerotoaster.mta.storage.StorageManager;

public abstract class ServerInstance
extends Application
implements Runnable,
Constants {
    private Thread thrd = null;
    protected LockObject loNotify = new LockObject();
    protected String strInstanceID = null;
    protected Configuration cnf = null;
    protected volatile boolean blnIsBusy = false;
    private long lngLastTransactionID = -1L;
    protected StorageManager smManager = null;
    protected String strTransactionID = null;
    protected LockObject loThreadUp = new LockObject();

    public ServerInstance(String strInstanceID) {
        this.cnf = Configuration.getConfig();
        this.strInstanceID = strInstanceID;
        this.setThreadName(strInstanceID);
        this.resetThreadName();
    }

    public void dispose() {
        Thread t;
        this.blnDisposed = true;
        this.setThreadName();
        if (this.loNotify != null) {
            this.loNotify.lo_notify();
            this.loNotify.dispose();
            this.loNotify = null;
        }
        if ((t = this.thrd) != null) {
            try {
                t.join(1000L);
                if (t.isAlive()) {
                    Configuration.logContext.write("! Forced shutdown");
                    t.stop();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.smManager != null) {
            this.smManager.dispose();
            this.smManager = null;
        }
        Configuration.logContext.write("D Instance disposed");
        this.resetThreadName();
    }

    protected synchronized String getTransactionID() {
        long l = -1L;
        while (this.lngLastTransactionID == (l = TimeFactory.getTime())) {
        }
        this.lngLastTransactionID = l;
        return String.valueOf(this.strInstanceID) + "/" + Long.toHexString(l);
    }

    protected void init0() {
        Configuration.logContext.write("D Starting ServerInstance");
        try {
            this.smManager = Configuration.getStorageManager();
        }
        catch (Throwable t) {
            Configuration.logContext.write(t);
            this.dispose();
            throw new InitializationException();
        }
        Configuration.logContext.write("D Instance started");
    }

    public boolean isBusy() {
        return this.blnIsBusy;
    }

    public boolean isRunning() {
        return !this.blnDisposed;
    }

    public abstract boolean kickInstance(Object var1);

    protected void kickThread() {
        this.thrd = new Thread(this);
        this.thrd.setName(this.strInstanceID);
        this.thrd.setPriority(5);
        this.thrd.start();
        this.loThreadUp.lo_wait();
    }

    public void run() {
        this.init0();
        this.loThreadUp.lo_notify();
        while (!this.blnDisposed) {
            this.loNotify.lo_wait();
            if (this.blnDisposed) {
                return;
            }
            this.strTransactionID = this.getTransactionID();
            Configuration.logContext.write("# TS " + this.strTransactionID);
            try {
                this.service();
            }
            catch (StorageException e) {
                Configuration.logContext.write("! Handled exception", (Throwable)e);
            }
            catch (Throwable t) {
                Configuration.logContext.write("? Unhandled exception", t);
            }
            try {
                this.servicePostProcess();
            }
            catch (Throwable t) {
                Configuration.logContext.write("? servicePostProcess:", t);
            }
            this.smManager.rollback();
            Configuration.logContext.write("# TE " + this.strTransactionID);
            this.setBusy(false);
        }
    }

    protected abstract void service() throws Throwable;

    protected abstract void servicePostProcess();

    public void setBusy(boolean b) {
        while (this.blnIsBusy != b) {
            this.blnIsBusy = b;
        }
    }
}

