/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.main;

import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.HelperPath;
import de.zwanzigeins.util.TimeFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Vector;
import net.zerotoaster.mta.config.Configuration;
import net.zerotoaster.mta.event.KickForwarder;
import net.zerotoaster.mta.event.MTAEventQueue;
import net.zerotoaster.mta.io.LineReader;
import net.zerotoaster.mta.io.LineWriter;
import net.zerotoaster.mta.mailfilters.BayesianFilter;
import net.zerotoaster.mta.mailfilters.HeaderPreprocess;
import net.zerotoaster.mta.mailfilters.IPTracer;
import net.zerotoaster.mta.mailfilters.MailFilter;
import net.zerotoaster.mta.mailfilters.MailFilterChain;
import net.zerotoaster.mta.mailfilters.avscan.AVScanExec;
import net.zerotoaster.mta.mailfilters.avscan.AVScanResult;
import net.zerotoaster.mta.main.Mail;
import net.zerotoaster.mta.main.ServerInstance;
import net.zerotoaster.mta.storage.MailHeaderRecord;
import net.zerotoaster.mta.storage.MailQueueRecord;
import net.zerotoaster.mta.storage.UserRecord;
import net.zerotoaster.mta.util.Helper;
import net.zerotoaster.mta.util.UserAlias;

public class MPA_ServerInstance
extends ServerInstance {
    private static volatile int intInstances = 0;
    private MailQueueRecord mqr = null;
    private static Hashtable hshMPA_UserInfo = new Hashtable();
    static Class class$de$zwanzigeins$util$LogContext;
    static Class class$java$lang$Integer;
    static Class class$java$lang$String;

    public MPA_ServerInstance(String strInstanceID) {
        super(strInstanceID);
        this.init();
        this.kickThread();
    }

    private boolean avscan() {
        if (!this.mqr.blnAVScan) {
            return true;
        }
        if (this.cnf.strAVS_Classes.length == 0) {
            return true;
        }
        Configuration.logContext.write("# AV Check ");
        LineReader lr = null;
        AVScanResult[] avResult = null;
        long lngTimeNeeded = TimeFactory.getTime();
        try {
            try {
                lr = this.smManager.tempRead(this.mqr.strUID_Temp);
                avResult = this.avs_process(lr);
            }
            catch (Throwable e) {
                Configuration.logContext.write("? Error during read/scan", e);
                Mail m = new Mail(Configuration.logContext, this.cnf, this.smManager);
                m.setMailFrom_Name("ZeroToaster::MTA 2.80");
                m.setMailTo_EMail("postmaster");
                m.setSubject("ZT 2.80: AV Scan init failed");
                m.setContent("AV Scan failed\r\nError was " + e.toString());
                m.store();
                Object var5_10 = null;
                Helper.close(lr);
                return true;
            }
        }
        catch (Throwable e) {
            Object var5_11 = null;
            Helper.close(lr);
            throw e;
        }
        Object var5_12 = null;
        Helper.close(lr);
        lngTimeNeeded = TimeFactory.getTime() - lngTimeNeeded;
        boolean blnHasInfection = false;
        int i = 0;
        while (i < avResult.length) {
            blnHasInfection |= avResult[i].blnHasInfection;
            ++i;
        }
        String strUID_Old = this.mqr.strUID_Temp;
        String strUID_New = TimeFactory.createUID();
        boolean blnInHeader = true;
        boolean blnSubjectFound = false;
        String strBuffer = null;
        LineReader lrOld = null;
        LineWriter lwNew = null;
        try {
            lrOld = this.smManager.tempRead(strUID_Old);
            lwNew = this.smManager.tempWrite(strUID_New);
            while ((strBuffer = lrOld.readln()) != null) {
                if (strBuffer.length() == 0 && blnInHeader) {
                    blnInHeader = false;
                    if (!blnSubjectFound && blnHasInfection) {
                        lwNew.println("Subject: " + this.cnf.strAVS_subjectmarker);
                    }
                    int i2 = 0;
                    while (i2 < avResult.length) {
                        String strAV = "X-ZeroToaster::MTA-AV-" + this.cnf.strSystemName + "-" + avResult[i2].strScannerName + ": ";
                        lwNew.println(avResult[i2].blnHasInfection ? String.valueOf(strAV) + avResult[i2].strInfection : String.valueOf(strAV) + "no infection found");
                        ++i2;
                    }
                    lwNew.println("X-ZeroToaster::MTA-AV-" + this.cnf.strSystemName + "-Scantime: " + lngTimeNeeded + "ms");
                }
                if (blnInHeader && blnHasInfection && strBuffer.toLowerCase().startsWith("subject:")) {
                    strBuffer = strBuffer.substring("subject".length() + 1).trim();
                    strBuffer = "Subject: " + this.cnf.strAVS_subjectmarker + " " + strBuffer;
                    blnSubjectFound = true;
                }
                lwNew.println(strBuffer);
            }
            lwNew.flush();
        }
        catch (IOException e) {
            Configuration.logContext.write("? Error during copy mail", (Throwable)e);
            Helper.close(lrOld);
            Helper.close(lwNew);
            this.smManager.tempDelete(strUID_New);
            return true;
        }
        Helper.close(lrOld);
        Helper.close(lwNew);
        this.smManager.tempDelete(strUID_Old);
        this.mqr.strUID_Temp = strUID_New;
        if (!blnHasInfection) {
            return true;
        }
        UserAlias uaAlias = new UserAlias(this.cnf.strAliases, Configuration.logContext);
        String[] strUsers = uaAlias.resolve(this.cnf.strAVS_quarantine);
        int i3 = 0;
        while (i3 < strUsers.length) {
            String strUser = Helper.redirectUser(strUsers[i3], this.smManager);
            Configuration.logContext.write("# Tossing quarantine [" + strUser + "]");
            MailHeaderRecord mhrOld = (MailHeaderRecord)this.mqr.vecMHR.elementAt(0);
            MailHeaderRecord mhr = new MailHeaderRecord();
            mhr.setEnvelopeFrom_Redirected(mhrOld.getEnvelopeFrom_Redirected());
            mhr.setEnvelopeFrom_Orginal(mhrOld.getEnvelopeFrom_Orginal());
            mhr.addEnvelopeTo_Orginal(mhrOld.getEnvelopeTo_Orginal()[0]);
            mhr.addEnvelopeTo_Redirected(strUser);
            mhr.setExternalMail(this.smManager.userRead(strUser) == null);
            mhr.setIsRelayMail(false);
            mhr.setMailDeleted(false);
            mhr.setMailSize(mhrOld.getMailSize());
            mhr.setTimeReceived(TimeFactory.getTime());
            mhr.setTimeNextRetry(mhr.getTimeReceived());
            mhr.setUID(TimeFactory.createUID());
            MailFilterChain mfc = new MailFilterChain(mhr, Configuration.logContext, this.smManager, this.cnf);
            mfc.registerFilter(new HeaderPreprocess());
            this.smManager.mailWriteFromTemp(mfc, mhr, this.mqr.strUID_Temp);
            this.smManager.commit();
            mfc.dispose();
            if (mhr.getExternalMail()) {
                MTAEventQueue.postEvent(new KickForwarder());
            }
            ++i3;
        }
        return false;
    }

    private void avs_cleanup(String strTempDir) {
        if (this.cnf.blnAVS_keeptemp) {
            return;
        }
        File fl = new File(strTempDir);
        String[] strFiles = fl.list();
        int i = 0;
        while (i < strFiles.length) {
            new File(strTempDir, strFiles[i]).delete();
            ++i;
        }
        new File(strTempDir).delete();
    }

    private AVScanResult[] avs_process(LineReader lrIn) throws Throwable {
        String strTempDir = HelperPath.pathFixup((String)(String.valueOf(this.cnf.strAVS_temp) + File.separator + TimeFactory.createUID()), (String)File.separator);
        new File(strTempDir).mkdirs();
        LineWriter out = null;
        File flScan = new File(strTempDir, "avscan.eml");
        boolean blnHasAttachment = false;
        try {
            Configuration.logContext.write("D Creating scanfile");
            out = new LineWriter(new FileOutputStream(flScan));
            String strBuffer = null;
            boolean blnInHeader = true;
            while ((strBuffer = lrIn.readln()) != null) {
                String strCmp;
                if (strBuffer.length() == 0) {
                    blnInHeader = false;
                }
                if (blnInHeader && (strCmp = strBuffer.toLowerCase()).startsWith("Content-Type:") && strCmp.indexOf("multipart") != -1) {
                    blnHasAttachment = true;
                }
                out.println(strBuffer);
            }
            Helper.close(out);
        }
        catch (Throwable t) {
            Helper.close(out);
            this.avs_cleanup(strTempDir);
            throw t;
        }
        if (!blnHasAttachment && !this.cnf.blnAVS_scananyway) {
            this.avs_cleanup(strTempDir);
            Configuration.logContext.write("D AV scan finished (No attachments found)");
            return new AVScanResult[0];
        }
        Vector<AVScanResult> vecResult = new Vector<AVScanResult>();
        int i = 0;
        while (i < this.cnf.strAVS_Classes.length) {
            block21: {
                AVScanResult avRes;
                block20: {
                    AVScanExec avScanExec = null;
                    String strTmp = this.cnf.strAVS_Classes[i];
                    String strClass = HelperExtract.getLeft((String)strTmp, (String)",").trim();
                    String strExec = HelperExtract.getRight((String)strTmp, (String)",").trim();
                    try {
                        Class<?> cls = Class.forName(strClass);
                        Class[] classArray = new Class[3];
                        Class<?> clazz = class$de$zwanzigeins$util$LogContext;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("de.zwanzigeins.util.LogContext");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        classArray[0] = clazz;
                        Class<?> clazz2 = class$java$lang$String;
                        if (clazz2 == null) {
                            try {
                                clazz2 = Class.forName("java.lang.String");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        classArray[1] = clazz2;
                        Class<?> clazz3 = class$java$lang$Integer;
                        if (clazz3 == null) {
                            try {
                                clazz3 = Class.forName("java.lang.Integer");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        classArray[2] = clazz3;
                        Class[] p = classArray;
                        Constructor<?> con = cls.getConstructor(p);
                        avScanExec = (AVScanExec)con.newInstance(Configuration.logContext, strExec, new Integer(this.cnf.intAVS_wait));
                    }
                    catch (Throwable t) {
                        Configuration.logContext.write("? Error loading " + strClass, t);
                        throw new RuntimeException("Error loading " + strClass + ": " + t.toString());
                    }
                    avRes = new AVScanResult();
                    try {
                        Configuration.logContext.write("D AV scan with " + HelperExtract.getRight((String)strClass, (String)"."));
                        avRes.strInfection = avScanExec.scan(flScan);
                        avRes.strScannerName = avScanExec.getScannerName();
                        avRes.blnHasInfection = avRes.strInfection != null;
                        Configuration.logContext.write("D AV scan done");
                        if (!avRes.blnHasInfection) break block20;
                        Configuration.logContext.write("! Infected: " + avRes.strInfection);
                    }
                    catch (Throwable t) {
                        Configuration.logContext.write("? While scanning with " + strClass + ": " + t);
                        break block21;
                    }
                }
                vecResult.addElement(avRes);
            }
            ++i;
        }
        Object[] avsResult = new AVScanResult[vecResult.size()];
        vecResult.copyInto(avsResult);
        this.avs_cleanup(strTempDir);
        Configuration.logContext.write("D AV scan finished");
        return avsResult;
    }

    public void dispose() {
        this.setThreadName();
        super.dispose();
        this.resetThreadName();
    }

    public static int getMailCountForUser(String strUser) {
        int i = 0;
        Hashtable hashtable = hshMPA_UserInfo;
        synchronized (hashtable) {
            MPA_UserInfo mpu = (MPA_UserInfo)hshMPA_UserInfo.get(strUser);
            if (mpu != null) {
                i = mpu.intMails;
            }
        }
        return i;
    }

    public static long getMailSizeForUser(String strUser) {
        long l = 0L;
        Hashtable hashtable = hshMPA_UserInfo;
        synchronized (hashtable) {
            MPA_UserInfo mpu = (MPA_UserInfo)hshMPA_UserInfo.get(strUser);
            if (mpu != null) {
                l = mpu.lngMailSize;
            }
        }
        return l;
    }

    private void init() {
    }

    public boolean kickInstance(Object o) {
        this.mqr = (MailQueueRecord)o;
        this.loNotify.lo_notify();
        return true;
    }

    private void processMails() {
        boolean blnHadExternalMail = false;
        if (this.avscan()) {
            int i = 0;
            while (i < this.mqr.vecMHR.size()) {
                MailHeaderRecord mhr = (MailHeaderRecord)this.mqr.vecMHR.elementAt(i);
                Configuration.logContext.write("# Tossing " + mhr.toString());
                try {
                    MailFilterChain sfc = new MailFilterChain(mhr, Configuration.logContext, this.smManager, this.cnf);
                    sfc.registerFilter(new HeaderPreprocess());
                    sfc.registerFilter(new IPTracer());
                    sfc.registerFilter(new BayesianFilter());
                    int c = 0;
                    while (c < this.cnf.strFilters.length) {
                        String strClass = this.cnf.strFilters[c];
                        if (strClass.length() != 0) {
                            try {
                                MailFilter mf = (MailFilter)Class.forName(strClass).newInstance();
                                sfc.registerFilter(mf);
                                Configuration.logContext.write("D Loaded mail filter class '" + strClass + "'");
                            }
                            catch (Throwable t) {
                                Configuration.logContext.write("? Cannot load filter class '" + strClass + "'", t);
                            }
                        }
                        ++c;
                    }
                    this.smManager.mailWriteFromTemp(sfc, mhr, this.mqr.strUID_Temp);
                    this.smManager.commit();
                    sfc.dispose();
                    blnHadExternalMail |= mhr.getExternalMail();
                    Configuration.logContext.write("D Done tossing " + mhr.toString());
                }
                catch (Throwable t) {
                    Configuration.logContext.write("! Error processing " + mhr.toString(), t);
                }
                ++i;
            }
        }
        this.smManager.mailProcessQueueRemove(this.mqr);
        if (blnHadExternalMail) {
            MTAEventQueue.postEvent(new KickForwarder());
        }
    }

    protected void service() throws IOException {
        this.cnf.statrec.intMPA_peak = Math.max(this.cnf.statrec.intMPA_peak, ++intInstances);
        try {
            Hashtable hashtable = hshMPA_UserInfo;
            synchronized (hashtable) {
                int i = 0;
                while (i < this.mqr.vecMHR.size()) {
                    MailHeaderRecord mhr = (MailHeaderRecord)this.mqr.vecMHR.elementAt(i);
                    String[] strRecipients = mhr.getEnvelopeTo_Redirected();
                    int ii = 0;
                    while (ii < strRecipients.length) {
                        MPA_UserInfo mui = (MPA_UserInfo)hshMPA_UserInfo.get(strRecipients[ii]);
                        if (mui == null) {
                            mui = new MPA_UserInfo(this);
                            hshMPA_UserInfo.put(strRecipients[ii], mui);
                        }
                        mui.lngMailSize += mhr.getMailSize();
                        ++mui.intMails;
                        UserRecord ur = this.smManager.userRead(strRecipients[ii]);
                        if (ur != null) {
                            ur.setLastMailReceived(TimeFactory.getTime());
                            this.smManager.userWrite(ur);
                        }
                        ++ii;
                    }
                    ++i;
                }
            }
        }
        catch (Throwable t) {
            Configuration.logContext.write("? Error collecting queue info ", t);
        }
        this.processMails();
        Configuration.logContext.write("D Mails tossed");
    }

    protected void servicePostProcess() {
        --intInstances;
        try {
            Hashtable hashtable = hshMPA_UserInfo;
            synchronized (hashtable) {
                int i = 0;
                while (i < this.mqr.vecMHR.size()) {
                    MailHeaderRecord mhr = (MailHeaderRecord)this.mqr.vecMHR.elementAt(i);
                    String[] strRecipients = mhr.getEnvelopeTo_Redirected();
                    int ii = 0;
                    while (ii < strRecipients.length) {
                        MPA_UserInfo mui = (MPA_UserInfo)hshMPA_UserInfo.get(strRecipients[ii]);
                        if (mui != null) {
                            mui.lngMailSize -= mhr.getMailSize();
                            --mui.intMails;
                            if (mui.intMails <= 0 || mui.lngMailSize <= 0L) {
                                hshMPA_UserInfo.remove(strRecipients[ii]);
                            }
                        }
                        ++ii;
                    }
                    ++i;
                }
            }
        }
        catch (Throwable t) {
            Configuration.logContext.write("? Error removing queue info ", t);
        }
    }

    class MPA_UserInfo {
        /* synthetic */ MPA_ServerInstance this$0;
        public long lngMailSize = 0L;
        public int intMails = 0;

        MPA_UserInfo(MPA_ServerInstance this$0) {
            this.this$0 = this$0;
        }
    }
}

