/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.main;

import de.zwanzigeins.template.TemplateParser;
import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.HelperFormat;
import de.zwanzigeins.util.TimeFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;
import net.zerotoaster.mta.config.Configuration;
import net.zerotoaster.mta.io.FWDOutputWriter;
import net.zerotoaster.mta.io.LineReader;
import net.zerotoaster.mta.io.LineSocket;
import net.zerotoaster.mta.main.Mail;
import net.zerotoaster.mta.main.ServerSocketInstance;
import net.zerotoaster.mta.storage.MailHeaderRecord;
import net.zerotoaster.mta.util.Helper;
import net.zerotoaster.mta.util.HostIP;

public class FWD_ServerInstance
extends ServerSocketInstance {
    private static final int ERR_NONE = -1;
    private static final int ERR_NO_MX_FOUND = 1;
    private static final int ERR_CANNOT_CONNECT_TO_MX = 2;
    private static final int ERR_DATA_ERROR = 3;
    private static final int ERR_USER_REJECTED = 4;
    private static final int ERR_SUCCESS_AFTER_RETRY = 5;
    private int intLastError = -1;
    private boolean blnRetryableError = false;
    private String strLastCommand = "";
    private String strLastResponse = "";
    private Vector vecUserRejectTemp = null;
    private Vector vecUserRejectFinal = null;
    private MailHeaderRecord mhr = null;
    private HostIP[] hipMX_Hosts = new HostIP[0];
    private static int intInstances;

    public FWD_ServerInstance(String strInstanceID) {
        super(strInstanceID);
        this.setThreadName(strInstanceID);
        this.kickThread();
        this.resetThreadName();
    }

    private boolean analyzeResponse(String strResponse) {
        switch (strResponse.charAt(0)) {
            case '2': 
            case '3': {
                return true;
            }
            case '4': {
                this.intLastError = 3;
                this.blnRetryableError = true;
                return false;
            }
            case '5': {
                this.intLastError = 3;
                this.blnRetryableError = false;
                return false;
            }
        }
        return false;
    }

    protected String cmdReceive() throws IOException {
        if (this.blnDisposed) {
            return "";
        }
        do {
            this.strLastResponse = super.cmdReceive();
            this.strLastResponse = String.valueOf(this.strLastResponse) + "    ";
        } while (this.strLastResponse.substring(3, 4).equals("-"));
        return this.strLastResponse;
    }

    protected boolean cmdSend(String strMsg) throws IOException {
        this.strLastCommand = strMsg;
        if (this.blnDisposed) {
            return false;
        }
        super.cmdSend(strMsg);
        this.strLastResponse = this.cmdReceive();
        return this.analyzeResponse(this.strLastResponse);
    }

    public void dispose() {
        this.setThreadName();
        super.dispose();
        this.mhr = null;
        this.hipMX_Hosts = null;
        this.strLastCommand = null;
        this.strLastResponse = null;
        this.vecUserRejectFinal = null;
        this.vecUserRejectTemp = null;
        this.resetThreadName();
    }

    private String getMessage(int intERR) {
        StringBuffer strb = new StringBuffer();
        strb.append("Dear [%sender%],\r\n");
        strb.append(" \r\n");
        switch (intERR) {
            case 1: {
                strb.append("We cannot send your message to [%receivers%] because no mailserver was found for domain [%domain%] or domain [%domain%] cannot be resolved.\r\n");
                strb.append(" \r\n");
                strb.append("Please verify the email address and resend the mail.\r\n");
                break;
            }
            case 2: {
                strb.append("We cannot send your message to [%receivers%] because no connection to the mailserver for [%domain%] can be made.\r\n");
                strb.append("\r\n");
                strb.append("The system tried these servers:\r\n");
                strb.append("[%loop servers%]");
                strb.append("-> [%servers%]\r\n");
                strb.append("[%endloop%]");
                strb.append(" \r\n");
                strb.append("[%if bounce%]");
                strb.append("The message bounced so we stopped all actions.\r\n");
                strb.append("[%else%]");
                strb.append("  [%if retry%]");
                strb.append("This is retry [%retry_number%] of [%retry_times%]. We will retry the action every [%retry_minutes%] minutes.\r\n");
                strb.append("  [%else%]");
                strb.append("We have reached the retry limit and declare this message as undeliverable.\r\n");
                strb.append("  [%endif%]");
                strb.append("[%endif%]");
                break;
            }
            case 3: {
                strb.append("We cannot send your message to [%receivers%] because of errors encountered during communication.\r\n");
                strb.append(" \r\n");
                strb.append("While talking to [%server%]\r\n");
                strb.append(" Last command sent:\r\n");
                strb.append("-> [%last_command%]\r\n");
                strb.append(" Last response received:\r\n");
                strb.append("-> [%last_response%]\r\n");
                strb.append(" \r\n");
                strb.append("[%if bounce%]");
                strb.append("The message bounced so we stopped all actions.\r\n");
                strb.append("[%else%]");
                strb.append("  [%if !retry%]");
                strb.append("Please verify the email address and resend the mail.");
                strb.append("  [%else%]");
                strb.append("    [%if retry_times>0%]");
                strb.append("This is retry [%retry_number%] of [%retry_times%]. We will retry the action every [%retry_minutes%] minutes.\r\n");
                strb.append("    [%else%]");
                strb.append("We have reached the retry limit and declare this message as undeliverable.");
                strb.append("    [%endif%]");
                strb.append("  [%endif%]");
                strb.append("[%endif%]");
                break;
            }
            case 4: {
                strb.append("[%if retry_users.size()>0%]");
                strb.append("The follwing users were temporarily rejected from [%server%]:\r\n");
                strb.append(" [%loop retry_users%]");
                strb.append("-> [%retry_users%]\r\n");
                strb.append(" [%endloop%]");
                strb.append(" \r\n");
                strb.append(" [%if bounce%]");
                strb.append("The message bounces so we stopped delivery.\r\n");
                strb.append(" [%else%]");
                strb.append("  [%if retry%]");
                strb.append("This is retry [%retry_number%] of [%retry_times%]. We will retry the action every [%retry_minutes%] minutes.\r\n");
                strb.append("  [%else%]");
                strb.append("We have reached the retry limit and declare this message as undeliverable.\r\n");
                strb.append("  [%endif%]");
                strb.append(" [%endif%]");
                strb.append("[%endif%]");
                strb.append("[%if rejected_users.size()>0%]");
                strb.append("The following users were rejected from [%server%]:\r\n\r\n");
                strb.append("[%loop rejected_users%]");
                strb.append(" [%rejected_users%]\r\n");
                strb.append("[%endloop%]");
                strb.append(" \r\n");
                strb.append("Please verify the email address and resend the mail.\r\n");
                strb.append("[%endif%]");
                break;
            }
            case 5: {
                strb.append("We were able to transfer your mail to [%receivers%] after [%retry_number%] times.\r\n");
            }
        }
        strb.append(" \r\n");
        strb.append("Original message follows\r\n");
        strb.append("============================================================\r\n");
        return strb.toString();
    }

    private String getMessageBody() {
        StringBuffer strbMsg = new StringBuffer();
        String strBuffer = null;
        int intBodyCnt = 0;
        boolean blnInBody = false;
        LineReader lr = this.smManager.mailReadBody(this.mhr);
        do {
            try {
                strBuffer = lr.readln();
            }
            catch (IOException iOException) {
                break;
            }
            if (strBuffer == null || strBuffer.equals(".")) break;
            strbMsg.append("| ");
            strbMsg.append(strBuffer);
            strbMsg.append("\r\n");
            if (strBuffer.length() != 0) continue;
            blnInBody = true;
        } while (!blnInBody || strBuffer.length() <= 0 || ++intBodyCnt <= this.cnf.intFWD_BounceIncludeLines);
        Helper.close(lr);
        return strbMsg.toString();
    }

    private LineSocket getMXConnection(String strDomain, boolean blnIsRelayMail) throws Throwable {
        int i;
        if (this.cnf.strNameServer.length() == 0) {
            InetAddress ina = InetAddress.getByName(strDomain);
            this.hipMX_Hosts = new HostIP[0];
            this.hipMX_Hosts[0].strHost = ina.getHostName();
            this.hipMX_Hosts[0].strIP = ina.getHostAddress();
        } else {
            this.hipMX_Hosts = Helper.getMXHosts(strDomain, false);
        }
        if (this.hipMX_Hosts != null && this.cnf.ipnFWD_NoDelivery.length > 0) {
            Vector<HostIP> v = new Vector<HostIP>(this.hipMX_Hosts.length);
            i = 0;
            while (i < this.hipMX_Hosts.length) {
                String strHostIP = this.hipMX_Hosts[i].strIP;
                boolean blnFound = false;
                int j = 0;
                while (j < this.cnf.ipnFWD_NoDelivery.length) {
                    if (this.cnf.ipnFWD_NoDelivery[j].match(strHostIP)) {
                        blnFound = true;
                        break;
                    }
                    ++j;
                }
                if (!blnFound) {
                    v.addElement(this.hipMX_Hosts[i]);
                } else {
                    Configuration.logContext.write("D MX Host " + this.hipMX_Hosts[i].toString() + " found in fwd_no_delivery, ignored");
                }
                ++i;
            }
            this.hipMX_Hosts = new HostIP[v.size()];
            v.copyInto(this.hipMX_Hosts);
        }
        if (this.hipMX_Hosts == null || this.hipMX_Hosts.length == 0) {
            this.intLastError = 1;
            this.blnRetryableError = false;
            return null;
        }
        if (blnIsRelayMail) {
            HostIP hip = this.hipMX_Hosts[0];
            this.hipMX_Hosts = new HostIP[]{hip};
        }
        InetAddress inaLocal = null;
        if (!this.cnf.strFWD_Host.startsWith("*")) {
            inaLocal = InetAddress.getByName(HelperExtract.splitIP_getHost((String)this.cnf.strFWD_Host));
        }
        i = 0;
        while (i < this.hipMX_Hosts.length) {
            Configuration.logContext.write("D Connecting to " + this.hipMX_Hosts[i]);
            try {
                Socket sok = new Socket(this.hipMX_Hosts[i].strIP, HelperExtract.splitIP_getPort((String)this.cnf.strFWD_Host, (int)25), inaLocal, 0);
                sok.setSoTimeout(this.cnf.intFWD_Socket_Timeout * 1000);
                Configuration.logContext.write("D Connected to " + this.hipMX_Hosts[i]);
                return new LineSocket(sok);
            }
            catch (IOException e) {
                Configuration.logContext.write("D " + this.hipMX_Hosts[i] + ": " + e.toString());
                ++i;
            }
        }
        this.intLastError = 2;
        this.blnRetryableError = true;
        return null;
    }

    public boolean kickInstance(Object o) {
        this.mhr = (MailHeaderRecord)o;
        this.loNotify.lo_notify();
        return true;
    }

    private void sendNotify(String strSubject, String string) {
        String strContent = HelperFormat.rewrap((String)string, (int)70);
        strContent = String.valueOf(strContent) + this.getMessageBody();
        Configuration.logContext.write("# Notify " + this.mhr.getEnvelopeFrom_Redirected());
        Mail m = new Mail(Configuration.logContext, this.cnf, this.smManager);
        m.setMailFrom_EMail(this.cnf.strPostmaster_Name);
        m.setMailFrom_Name("postmaster");
        m.setIsBounce(true);
        m.setMailTo_EMail(this.mhr.getEnvelopeFrom_Redirected());
        m.setSubject(strSubject);
        m.setContent(strContent);
        if (m.store()) {
            Configuration.logContext.write("# Message for " + this.mhr.getEnvelopeFrom_Redirected() + " created.");
        }
    }

    protected void service() throws Throwable {
        this.cnf.statrec.intFWD_peak = Math.max(this.cnf.statrec.intFWD_peak, ++intInstances);
        this.strLastCommand = "";
        this.strLastResponse = "";
        this.intLastError = -1;
        this.hipMX_Hosts = new HostIP[0];
        this.vecUserRejectFinal = new Vector();
        this.vecUserRejectTemp = new Vector();
        Configuration.logContext.write("# Processing " + this.mhr.toString());
        this.lsok = this.getMXConnection(HelperExtract.splitUserName_getDomain((String)this.mhr.getEnvelopeTo_Redirected()[0]), this.mhr.getIsRelayMail());
        if (this.lsok == null) {
            return;
        }
        try {
            String strMailFrom;
            String strHeloHost = this.cnf.strFWD_HeloHost;
            if (strHeloHost.length() == 0) {
                strHeloHost = this.lsok.getLocalAddress().getHostName();
            }
            this.strLastCommand = "(waiting for greeting)";
            if (!this.waitFor("220")) {
                this.intLastError = 3;
                return;
            }
            if (!this.cmdSend("HELO " + strHeloHost)) {
                this.intLastError = 3;
                return;
            }
            if (!this.strLastResponse.startsWith("250")) {
                this.strLastCommand = "(waiting for end of HELO response)";
                if (!this.waitFor("250")) {
                    this.intLastError = 3;
                    return;
                }
            }
            String string = strMailFrom = this.mhr.getIsBounce() ? "" : this.mhr.getEnvelopeFrom_Redirected();
            if (!this.cmdSend("MAIL FROM:<" + strMailFrom + ">")) {
                this.intLastError = 4;
                if (this.blnRetryableError) {
                    this.vecUserRejectTemp.addElement("<" + strMailFrom + ">: " + this.strLastResponse);
                } else {
                    this.vecUserRejectFinal.addElement("<" + strMailFrom + ">: " + this.strLastResponse);
                }
                return;
            }
            String[] strRecipients = this.mhr.getEnvelopeTo_Redirected();
            boolean blnOneUserAccepted = false;
            int i = 0;
            while (i < strRecipients.length) {
                if (!this.cmdSend("RCPT TO:<" + strRecipients[i] + ">")) {
                    this.intLastError = 4;
                    if (this.blnRetryableError) {
                        this.vecUserRejectTemp.addElement("<" + strRecipients[i] + ">: " + this.strLastResponse);
                    } else {
                        this.vecUserRejectFinal.addElement("<" + strRecipients[i] + ">: " + this.strLastResponse);
                    }
                } else {
                    blnOneUserAccepted = true;
                }
                ++i;
            }
            if (!blnOneUserAccepted) {
                return;
            }
            if (!this.cmdSend("DATA")) {
                return;
            }
            Configuration.logContext.write("# Sending mail " + this.mhr.toString() + " (" + this.lsok.getInetAddress() + ")");
            this.smManager.mailReadBody(this.mhr, new FWDOutputWriter(this.lsok.getLineWriter()));
            Configuration.logContext.write("# Mail sent " + this.mhr.toString() + " (" + this.lsok.getInetAddress() + ")");
            this.strLastCommand = "(waiting for acknowledge of DATA)";
            if (!this.waitFor("250")) {
                return;
            }
        }
        catch (Throwable e) {
            if (this.blnDisposed) {
                Configuration.logContext.write("? Transmission interrupted due to shutdown");
                return;
            }
            this.intLastError = 3;
            this.blnRetryableError = true;
            this.strLastResponse = e.getMessage();
            Configuration.logContext.write("? Send failed after " + Helper.formatMemoryString(this.lsok.getBytesSent()));
            return;
        }
        try {
            this.cmdSend("QUIT");
        }
        catch (Throwable throwable) {}
    }

    protected void servicePostProcess() {
        --intInstances;
        ++this.cnf.statrec.lngFWD_accesses;
        if (this.lsok != null) {
            this.cnf.statrec.lngFWD_bytes += this.lsok.getBytesTotal();
            if (this.mhr.getIsRelayMail()) {
                this.smManager.accountingStore("R", this.mhr.getAccounting(), this.lsok.getBytesReceived(), this.lsok.getBytesSent());
            } else {
                this.smManager.accountingStore("I", this.mhr.getAccounting(), this.lsok.getBytesReceived(), this.lsok.getBytesSent());
            }
        }
        this.mhr.setMailLocked(false);
        TemplateParser tpl = new TemplateParser();
        StringBuffer strbTmp = new StringBuffer();
        String[] strTmp = this.mhr.getEnvelopeTo_Redirected();
        String strReceiver = strTmp[0];
        int i = 0;
        while (i < strTmp.length) {
            strbTmp.append(strTmp[i]);
            strbTmp.append(", ");
            ++i;
        }
        if (strbTmp.length() > 2) {
            strbTmp.setLength(strbTmp.length() - 2);
        }
        tpl.setVar("receivers", strbTmp.toString());
        tpl.setVar("domain", HelperExtract.splitUserName_getDomain((String)strReceiver));
        if (this.lsok != null) {
            tpl.setVar("server", this.lsok.getInetAddress().toString());
        } else {
            tpl.setVar("server", "[unknown]");
        }
        tpl.setVar("servers", (Object)this.hipMX_Hosts);
        tpl.setVar("bounce", false);
        if (this.mhr.getEnvelopeFrom_Redirected().length() == 0 && !this.blnRetryableError || this.mhr.getIsBounce()) {
            tpl.setVar("bounce", true);
            this.mhr.setEnvelopeFrom_Redirected(this.cnf.strPostmaster_Name);
        }
        tpl.setVar("sender", this.mhr.getEnvelopeFrom_Redirected());
        tpl.setVar("retry", this.blnRetryableError);
        tpl.setVar("retry_number", this.mhr.getRetryCount());
        if (this.blnRetryableError) {
            this.mhr.setRetryCount(this.mhr.getRetryCount() + 1);
            this.mhr.setTimeNextRetry(TimeFactory.getTime() + 60000L * (long)this.cnf.intFWD_RetryDelay);
            int intRemainingRetries = Math.max(this.cnf.intFWD_MaxRetries - this.mhr.getRetryCount(), 0);
            if (intRemainingRetries == 0) {
                Configuration.logContext.write("? Reached retry limit for " + this.mhr.toString());
                this.blnRetryableError = false;
            }
            tpl.setVar("retry_minutes", this.cnf.intFWD_RetryDelay);
            tpl.setVar("retry_times", this.cnf.intFWD_MaxRetries);
            tpl.setVar("retry_number", this.mhr.getRetryCount());
            tpl.setVar("retry", this.blnRetryableError);
        }
        if (this.lsok != null) {
            tpl.setVar("last_command", this.strLastCommand);
            tpl.setVar("last_response", this.strLastResponse);
            tpl.setVar("retry_users", (Object)this.vecUserRejectTemp);
            tpl.setVar("rejected_users", (Object)this.vecUserRejectFinal);
        }
        if (this.intLastError == -1) {
            this.mhr.setMailDeleted(true);
            this.smManager.mailWriteHeader(this.mhr);
            this.smManager.commit();
            if (this.cnf.intFWD_RetryNotify.length > 0 && this.mhr.getRetryCount() >= this.cnf.intFWD_RetryNotify[0]) {
                this.sendNotify("Mail delivery success", tpl.process(this.getMessage(5)));
            }
            return;
        }
        if (!this.blnRetryableError) {
            this.sendNotify("Notify of mail delivery failure", tpl.process(this.getMessage(this.intLastError)));
            this.mhr.setMailDeleted(true);
            this.smManager.mailWriteHeader(this.mhr);
            this.smManager.commit();
            return;
        }
        this.smManager.mailWriteHeader(this.mhr);
        this.smManager.commit();
        Configuration.logContext.write("! Retry Nr." + this.mhr.getRetryCount() + " " + this.mhr.toString());
        i = 0;
        while (i < this.cnf.intFWD_RetryNotify.length) {
            if (this.cnf.intFWD_RetryNotify[i] == this.mhr.getRetryCount()) {
                this.sendNotify("Notify of mail delivery failure", tpl.process(this.getMessage(this.intLastError)));
                break;
            }
            ++i;
        }
    }

    private boolean waitFor(String strFor) throws IOException {
        String strMsg = this.cmdReceive();
        if (!this.analyzeResponse(strMsg)) {
            return false;
        }
        if (!strMsg.startsWith(strFor)) {
            this.intLastError = 3;
            return false;
        }
        return true;
    }
}

