/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.mailfilters;

import de.zwanzigeins.util.LogContext;
import net.zerotoaster.mta.config.Configuration;
import net.zerotoaster.mta.config.Constants;
import net.zerotoaster.mta.storage.MailHeaderRecord;
import net.zerotoaster.mta.storage.StorageManager;

public abstract class MailFilter
implements Constants {
    private LogContext logContext = null;
    private boolean blnAbort = false;
    private boolean blnDelete = false;
    private boolean blnFilter = false;
    protected StorageManager smManager = null;
    protected MailHeaderRecord mhr = null;
    protected Configuration cnf = null;

    public abstract void analyzeBody(String var1) throws Throwable;

    public abstract void analyzeHeader(String var1) throws Throwable;

    public abstract void analyzePost() throws Throwable;

    public boolean canAbort() {
        return this.blnAbort;
    }

    public boolean canDelete() {
        return this.blnDelete;
    }

    public boolean canFilter() {
        return this.blnFilter;
    }

    public abstract void dispose();

    public void doAbort() {
        this.blnAbort = true;
    }

    public void doDelete() {
        this.blnDelete = true;
    }

    public void filterDisable() {
        this.blnFilter = false;
    }

    public void filterEnable() {
        this.blnFilter = true;
    }

    void init(MailHeaderRecord mhr, LogContext log, StorageManager sm, Configuration cnf) {
        this.mhr = mhr;
        this.logContext = log;
        this.smManager = sm;
        this.cnf = cnf;
        this.blnFilter = true;
    }

    public void log(String s) {
        this.logContext.write(s);
    }

    public void log(String s, Throwable t) {
        this.logContext.write(s, t);
    }

    public void log(Throwable t) {
        this.logContext.write(t);
    }

    public abstract String processBody(String var1) throws Throwable;

    public abstract String processHeader(String var1) throws Throwable;

    public abstract String processNewHeaders(String var1) throws Throwable;

    public abstract String processPost(String var1) throws Throwable;
}

