/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.mailfilters;

import de.zwanzigeins.util.HelperValidate;
import java.io.Serializable;
import net.zerotoaster.mta.storage.StorageRecord;
import net.zerotoaster.mta.util.Helper;

public class BayesianFilterConfig
extends StorageRecord
implements Serializable {
    public static final String KEYDATA_APPL_CONFIG = "BAYESIAN_FILTER_CONFIG";
    public static final int ACTION_MOVE = 0;
    public static final int ACTION_DELETE = 1;
    public static final int ACTION_MARK = 2;
    private String strUserName = null;
    private int intProbability_1 = 0;
    private int intAction_1 = 0;
    private int intProbability_2 = 0;
    private int intAction_2 = 0;
    private String strEMail = null;
    private String strMarker = null;
    private String strWordListSource = null;

    public BayesianFilterConfig() {
        this.init();
    }

    public int getAction_1() {
        return this.intAction_1;
    }

    public int getAction_2() {
        return this.intAction_2;
    }

    public String getEMail() {
        return this.strEMail;
    }

    public String getMarker() {
        return this.strMarker;
    }

    public int getProbability_1() {
        return this.intProbability_1;
    }

    public int getProbability_2() {
        return this.intProbability_2;
    }

    public String getUserName() {
        return this.strUserName;
    }

    public String getWordListSource() {
        return this.strWordListSource;
    }

    public void init() {
        this.strUserName = "";
        this.intProbability_1 = 100;
        this.intAction_1 = 0;
        this.intProbability_2 = 100;
        this.intAction_2 = 0;
        this.strEMail = "";
        this.strMarker = "** SPAM **";
        this.strWordListSource = "";
    }

    public String recordExport() {
        if (this.intProbability_1 < this.intProbability_2) {
            int i = this.intProbability_2;
            this.intProbability_2 = this.intProbability_1;
            this.intProbability_1 = i;
            i = this.intAction_2;
            this.intAction_2 = this.intAction_1;
            this.intAction_1 = i;
        }
        StringBuffer strb = new StringBuffer();
        strb.append(this.strUserName);
        strb.append('\u0014');
        strb.append(this.intProbability_1);
        strb.append('\u0014');
        strb.append(this.intAction_1);
        strb.append('\u0014');
        strb.append(this.intProbability_2);
        strb.append('\u0014');
        strb.append(this.intAction_2);
        strb.append('\u0014');
        strb.append(this.strEMail);
        strb.append('\u0014');
        strb.append(this.strMarker);
        strb.append('\u0014');
        strb.append(this.strWordListSource);
        strb.append('\u0014');
        return strb.toString();
    }

    public void recordImport(String str) {
        this.initTokenizer(str);
        this.strUserName = this.nextToken();
        this.intProbability_1 = this.nextTokenInteger();
        this.intAction_1 = this.nextTokenInteger();
        this.intProbability_2 = this.nextTokenInteger();
        this.intAction_2 = this.nextTokenInteger();
        this.strEMail = this.nextToken();
        if (this.hasMoreTokens()) {
            this.strMarker = this.nextToken();
        }
        if (this.hasMoreTokens()) {
            this.strWordListSource = this.nextToken();
        }
    }

    public void setAction_1(int i) {
        this.intAction_1 = i;
    }

    public void setAction_2(int i) {
        this.intAction_2 = i;
    }

    public void setEMail(String s) {
        this.strEMail = "";
        if (s.length() > 0) {
            this.strEMail = HelperValidate.validateRFC822_User((String)s);
        }
    }

    public void setMarker(String s) {
        this.strMarker = s.trim();
    }

    public void setProbability_1(int i) {
        this.intProbability_1 = i;
    }

    public void setProbability_2(int i) {
        this.intProbability_2 = i;
    }

    public void setUserName(String s) {
        this.strUserName = Helper.limit(s.toLowerCase(), 129);
    }

    public void setWordListSource(String s) {
        this.strWordListSource = HelperValidate.validateRFC822_User((String)s);
        if (this.strWordListSource == null) {
            this.strWordListSource = "";
        }
    }

    public String toString() {
        return this.getUserName();
    }
}

