/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.event;

import de.zwanzigeins.util.LogContext;
import java.util.Vector;
import net.zerotoaster.mta.config.Configuration;
import net.zerotoaster.mta.event.MTAEvent;
import net.zerotoaster.mta.event.MTAEventListener;
import net.zerotoaster.mta.event.PostmasterAlert;

public class MTAEventQueue
extends Thread {
    private static Vector vecListeners = new Vector();
    private static transient boolean blnIsRunning = false;
    private static Vector vecQueue = null;
    private static MTAEventQueue mtaq = null;
    private static LogContext logContext = null;
    private static Configuration cnfConfig = null;
    private static boolean blnConsumed = false;

    private MTAEventQueue() {
        super("MTAEventQueue");
        vecQueue = new Vector(50);
        this.setPriority(1);
        this.start();
    }

    public static final void addListener(MTAEventListener l) {
        if (vecListeners.indexOf(l) == -1) {
            vecListeners.addElement(l);
        }
    }

    public static final void consume() {
        blnConsumed = true;
    }

    public static final void dispose() {
        vecListeners.removeAllElements();
        if (mtaq == null) {
            return;
        }
        Vector vector = vecQueue;
        synchronized (vector) {
            vecQueue.removeAllElements();
            if (blnIsRunning) {
                blnIsRunning = false;
                vecQueue.notify();
            }
        }
        vecQueue = null;
        mtaq = null;
    }

    public static final synchronized void postEvent(MTAEvent e) {
        if (mtaq == null) {
            mtaq = new MTAEventQueue();
        }
        if (vecQueue.capacity() == vecQueue.size()) {
            vecQueue.ensureCapacity(vecQueue.size() + 5);
            if (logContext != null) {
                logContext.write("? MTA event queue overflow. Queuesize is " + vecQueue.capacity() + " now");
                if (MTAEventQueue.cnfConfig.blnNotify_Queue) {
                    MTAEventQueue.postEvent(new PostmasterAlert("MTAEventQueue: Message queue resized to " + vecQueue.capacity()));
                }
            }
        }
        Vector vector = vecQueue;
        synchronized (vector) {
            vecQueue.addElement(e);
            vecQueue.notify();
        }
    }

    public static final synchronized void postEventSync(MTAEvent e) {
        Vector vector = vecListeners;
        synchronized (vector) {
            int i = 0;
            while (i < vecListeners.size()) {
                try {
                    MTAEventListener l = (MTAEventListener)vecListeners.elementAt(i);
                    blnConsumed = false;
                    l.mtaEvent(e);
                    if (blnConsumed) {
                        break;
                    }
                }
                catch (Throwable t) {
                    if (logContext != null) {
                        logContext.write("? Exception in MTA Event Queue Sync:", t);
                    } else {
                        System.out.println("? Exception in MTA Event Queue Sync: ");
                    }
                    t.printStackTrace();
                }
                ++i;
            }
        }
    }

    public static final void removeAll() {
        vecListeners.removeAllElements();
    }

    public static final void removeListener(MTAEventListener l) {
        vecListeners.removeElement(l);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        MTAEventQueue.blnIsRunning = true;
        e = null;
        vec = MTAEventQueue.vecQueue;
        if (vec != null) ** GOTO lbl50
        return;
lbl-1000:
        // 1 sources

        {
            var3_3 = vec;
            synchronized (var3_3) {
                while (true) {
                    if (!MTAEventQueue.blnIsRunning || vec.size() != 0) {
                        if (MTAEventQueue.blnIsRunning) break;
                        return;
                    }
                    try {
                        vec.wait(0L);
                    }
                    catch (InterruptedException v0) {
                    }
                    catch (ThreadDeath v1) {
                        MTAEventQueue.blnIsRunning = false;
                    }
                }
                e = (MTAEvent)vec.elementAt(0);
                vec.removeElementAt(0);
            }
            var3_3 = MTAEventQueue.vecListeners;
            synchronized (var3_3) {
                i = 0;
                while (i < MTAEventQueue.vecListeners.size()) {
                    block17: {
                        try {
                            l = (MTAEventListener)MTAEventQueue.vecListeners.elementAt(i);
                            MTAEventQueue.blnConsumed = false;
                            l.mtaEvent(e);
                            if (MTAEventQueue.blnConsumed) {
                            }
                            break block17;
                        }
                        catch (Throwable t) {
                            if (MTAEventQueue.logContext != null) {
                                MTAEventQueue.logContext.write("? Exception in MTA Event Queue:", t);
                                break;
                            }
                            System.err.println("Exception in MTA Event Queue: " + t);
                        }
                        break;
                    }
                    ++i;
                }
                continue;
            }
lbl50:
            // 3 sources

            ** while (MTAEventQueue.blnIsRunning)
        }
lbl51:
        // 1 sources

    }

    public static final void setConfiguration(LogContext log, Configuration cnf) {
        logContext = log;
        cnfConfig = cnf;
    }

    public String toString() {
        StringBuffer strb = new StringBuffer();
        Vector vector = vecQueue;
        synchronized (vector) {
            Vector v = vecQueue;
            strb.append("Dump of EventQueue follows.\n");
            strb.append("Queue contains ");
            strb.append(v.size());
            strb.append(" Elements\n");
            int i = 0;
            while (i < v.size()) {
                MTAEvent e = (MTAEvent)v.elementAt(i);
                strb.append(" -- ");
                strb.append(i);
                strb.append(" ");
                strb.append(e.toString());
                strb.append('\n');
                ++i;
            }
        }
        return strb.toString();
    }
}

