/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.admin.awt;

import java.util.EmptyStackException;
import net.zerotoaster.mta.admin.awt.StringBufferExtended;

public class IntegerStack
implements Cloneable {
    private int intLength = 0;
    private int[] intsValues = new int[16];

    public final void clear() {
        this.intLength = 0;
    }

    public Object clone() {
        try {
            IntegerStack stack = (IntegerStack)super.clone();
            stack.intsValues = (int[])this.intsValues.clone();
            return stack;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("clone failed on IntegerStack " + this);
        }
    }

    private final void enlarge() {
        int newSize = this.intLength + 16;
        int[] newArray = new int[newSize];
        System.arraycopy(this.intsValues, 0, newArray, 0, this.intLength);
        this.intsValues = newArray;
    }

    public final int getElementAt(int index) {
        if (index < 0 || index > this.intLength) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.intsValues[index];
    }

    public final int getSize() {
        return this.intLength;
    }

    public final boolean isEmpty() {
        return this.intLength == 0;
    }

    public final int peek() {
        int len = this.intLength;
        if (len == 0) {
            throw new EmptyStackException();
        }
        return this.intsValues[len];
    }

    public final int pop() {
        if (this.intLength == 0) {
            throw new EmptyStackException();
        }
        return this.intsValues[--this.intLength];
    }

    public final void push(int value) {
        if (this.intLength == this.intsValues.length) {
            this.enlarge();
        }
        this.intsValues[this.intLength++] = value;
    }

    public final void removeElement(int element) {
        int[] values = this.intsValues;
        int i = this.intLength;
        while (i-- > 0) {
            if (values[i] != element) continue;
            --this.intLength;
            if (i >= this.intLength) continue;
            System.arraycopy(values, i + 1, values, i, this.intLength - i);
        }
    }

    public final int removeElementAt(int index) {
        if (index < 0 || index >= this.intLength) {
            throw new ArrayIndexOutOfBoundsException("index=" + index + ", max=" + (this.intLength - 1));
        }
        int value = this.intsValues[index];
        --this.intLength;
        if (index < this.intLength) {
            System.arraycopy(this.intsValues, index + 1, this.intsValues, index, this.intLength - index);
        }
        return value;
    }

    public String toString() {
        StringBufferExtended sbe = new StringBufferExtended();
        sbe.append("IntegerStack {");
        boolean needDelimiter = false;
        int i = this.intLength;
        while (i-- > 0) {
            if (!needDelimiter) {
                needDelimiter = true;
            } else {
                sbe.append(',');
            }
            sbe.append(this.intsValues[i]);
        }
        sbe.append('}');
        return sbe.toString();
    }
}

