/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.servlet;

import de.zwanzigeins.util.LogContext;
import de.zwanzigeins.util.TimeFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import net.zerotoaster.httpd.config.Configuration;
import net.zerotoaster.httpd.servlet.SessionData;
import net.zerotoaster.httpd.servlet.SessionManager;
import net.zerotoaster.httpd.util.Helper;

public class FileSessionManager
extends SessionManager {
    private Hashtable hshHeaders = null;
    private String strPath = null;
    private int intMaxFileRemovePerScan = 0;
    private int intSessionCount = 0;

    public FileSessionManager(LogContext log, Configuration cnf) {
        super(log, cnf);
        try {
            this.init();
        }
        catch (Throwable t) {
            log.write("? init():", t);
        }
    }

    protected void cleanup() {
        int intCntCleaned = 0;
        int intCntTotal = 0;
        Hashtable hashtable = this.hshHeaders;
        synchronized (hashtable) {
            this.log.write("D Starting cleanup");
            Enumeration e = this.hshHeaders.elements();
            while (e.hasMoreElements()) {
                ++intCntTotal;
                Header h = (Header)e.nextElement();
                SessionData sd = h.getSessionData();
                if (sd.isValidSession()) continue;
                this.hshHeaders.remove(sd.strID);
                File f = new File(this.strPath, h.strID);
                if (!f.delete()) {
                    this.log.write("? Cannot delete " + f.getPath());
                }
                if (++intCntCleaned <= this.intMaxFileRemovePerScan) continue;
                this.log.write("! Limit of files to clean reached, will continue in the next cycle");
                break;
            }
        }
        this.log.write("# Removed " + intCntCleaned + " entries of " + intCntTotal);
    }

    public SessionData createSession(HttpServletRequest req) {
        long lngTime = TimeFactory.getTime();
        SessionData sc = new SessionData();
        sc.blnIsNewSession = true;
        sc.hshValues = new Hashtable();
        sc.lngCreationTime = lngTime;
        sc.lngLastAccessedTime = lngTime;
        sc.lngMaxInactiveInterval = this.lngSessionTimeout;
        sc.strID = "ID" + Long.toHexString(lngTime) + "-" + Integer.toString(++this.intSessionCount);
        return sc;
    }

    protected SessionData getSession(String strID) {
        Hashtable hashtable = this.hshHeaders;
        synchronized (hashtable) {
            Header h = (Header)this.hshHeaders.get(strID);
            SessionData sd = h.getSessionData();
            File f = new File(this.strPath, h.strID);
            if (!f.exists()) {
                return null;
            }
            if (sd.hshValues != null) {
                sd.hshValues.clear();
                sd.hshValues = null;
            }
            ObjectInputStream ois = null;
            try {
                try {
                    ois = new ObjectInputStream(new FileInputStream(f));
                    sd.hshValues = (Hashtable)ois.readObject();
                }
                catch (IOException e) {
                    this.log.write("? Error reading sessisondata.", (Throwable)e);
                    Object var7_11 = null;
                    Helper.close(ois);
                    return null;
                }
                catch (ClassNotFoundException e) {
                    this.log.write("? Error reading sessisondata.", (Throwable)e);
                    Object var7_12 = null;
                    Helper.close(ois);
                    return null;
                }
                catch (Throwable e) {
                    this.log.write("? Unknown error while reading sessisondata", e);
                    Object var7_13 = null;
                    Helper.close(ois);
                    return null;
                }
            }
            catch (Throwable throwable) {
                Object var7_14 = null;
                Helper.close(ois);
                throw throwable;
            }
            Object var7_15 = null;
            Helper.close(ois);
            if (sd.hshValues == null) {
                sd.hshValues = new Hashtable();
            }
            return sd;
        }
    }

    public String getStatistics() {
        StringBuffer strb = new StringBuffer();
        strb.append("Entries total: ");
        strb.append(this.hshHeaders.size());
        strb.append(", valid entries: ");
        int intValid = 0;
        Hashtable hashtable = this.hshHeaders;
        synchronized (hashtable) {
            Enumeration e = this.hshHeaders.elements();
            while (e.hasMoreElements()) {
                Header h = (Header)e.nextElement();
                SessionData sd = h.getSessionData();
                if (sd.hshValues == null || !sd.isValidSession()) continue;
                ++intValid;
            }
        }
        strb.append(intValid);
        return strb.toString();
    }

    private void init() {
        this.hshHeaders = new Hashtable();
        this.strPath = this.cnf.strSrvlSessionDirectory;
        if (this.strPath == null || this.strPath.length() == 0) {
            throw new RuntimeException("'directory' entry is empty");
        }
        this.intMaxFileRemovePerScan = 50;
        File f = new File(this.strPath);
        f.mkdirs();
        String[] s = f.list();
        int i = 0;
        while (i < s.length) {
            new File(this.strPath, s[i]).delete();
            ++i;
        }
    }

    public boolean isValid(String strID) {
        if (strID == null) {
            return false;
        }
        SessionData sd = null;
        Hashtable hashtable = this.hshHeaders;
        synchronized (hashtable) {
            Header h = (Header)this.hshHeaders.get(strID);
            if (h == null) {
                return false;
            }
            File f = new File(this.strPath, h.strID);
            if (!f.exists()) {
                this.log.write("? Have header but no file for it !");
                return false;
            }
            sd = h.getSessionData();
        }
        return sd.isValidSession();
    }

    protected void putSession(SessionData sd) {
        Hashtable hashtable = this.hshHeaders;
        synchronized (hashtable) {
            Header h = new Header(this, sd);
            File f = new File(this.strPath, h.strID);
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(new FileOutputStream(f));
                oos.writeObject(sd.hshValues);
            }
            catch (IOException e) {
                this.log.write("? Error writing sessisondata", (Throwable)e);
            }
            Helper.close(oos);
            sd.hshValues.clear();
            sd.hshValues = null;
            this.hshHeaders.put(h.strID, h);
        }
    }

    public String toString() {
        return this.getStatistics();
    }

    class Header {
        /* synthetic */ FileSessionManager this$0;
        String strID;
        long lngCreationTime = -1L;
        long lngLastAccessedTime = -1L;
        long lngMaxInactiveInterval = -1L;

        public Header(FileSessionManager this$0, SessionData sd) {
            this.this$0 = this$0;
            this.strID = sd.strID;
            this.lngCreationTime = sd.lngCreationTime;
            this.lngLastAccessedTime = sd.lngLastAccessedTime;
            this.lngMaxInactiveInterval = sd.lngMaxInactiveInterval;
        }

        public SessionData getSessionData() {
            SessionData sd = new SessionData();
            sd.strID = this.strID;
            sd.lngCreationTime = this.lngCreationTime;
            sd.lngLastAccessedTime = this.lngLastAccessedTime;
            sd.lngMaxInactiveInterval = this.lngMaxInactiveInterval;
            sd.hshValues = null;
            return sd;
        }
    }
}

