/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.mods;

import de.zwanzigeins.cache.GZipFileContentProducer;
import de.zwanzigeins.cache.PrecomputedFileContentCache;
import de.zwanzigeins.cache.PrecomputedFileContentProducer;
import de.zwanzigeins.io.DumbByteArrayOutputStream;
import de.zwanzigeins.util.LogContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import net.zerotoaster.httpd.config.Configuration;
import net.zerotoaster.httpd.mods.IntermediateModuleData;
import net.zerotoaster.httpd.mods.Mod_File_Response;
import net.zerotoaster.httpd.request.Http_Request;
import net.zerotoaster.httpd.response.Http_Response;
import net.zerotoaster.httpd.util.Helper;

public class Mod_File_Response_GZIP
extends Mod_File_Response {
    PrecomputedFileContentCache pcc = null;

    public Mod_File_Response_GZIP(Configuration cnfConfig, LogContext logContext) {
        super(cnfConfig, logContext);
        this.pcc = new PrecomputedFileContentCache(logContext, cnfConfig.intStreamBufferSize, cnfConfig.blnDebug);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processRES(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        Object fis;
        block21: {
            boolean bl;
            block20: {
                boolean bl2;
                block19: {
                    block18: {
                        if (Configuration.mode_nofile()) {
                            return false;
                        }
                        if (httpRES.strContentType.length() == 0) {
                            httpRES.strContentType = Helper.getMimeType(imd.iniVHOST, imd.strFileToServe);
                        }
                        File fl = new File(imd.strFileToServe);
                        httpRES.lngLastModified = fl.lastModified() / 1000L * 1000L;
                        if (super.sendNotModified(httpREQ, imd, httpRES)) {
                            return true;
                        }
                        boolean blnUseGZIP = false;
                        int i = 0;
                        while (i < httpREQ.qrAccept_Encoding.length) {
                            String strToken = httpREQ.qrAccept_Encoding[i].strToken;
                            if (strToken.indexOf("gzip") != -1) {
                                blnUseGZIP = true;
                                break;
                            }
                            ++i;
                        }
                        if (!blnUseGZIP) {
                            return false;
                        }
                        int intCMPSZ_min = imd.iniVHOST.getPropertyInt(this.MOD_NAME, "minimum_size", 1024);
                        int intCMPSZ_mem = imd.iniVHOST.getPropertyInt(this.MOD_NAME, "maximum_mem_size", 5000);
                        int intCMPSZ_disk = imd.iniVHOST.getPropertyInt(this.MOD_NAME, "maximum_disk_size", 100000);
                        long lngFileSize = fl.length();
                        if (lngFileSize < (long)intCMPSZ_min) {
                            return false;
                        }
                        if (lngFileSize > (long)intCMPSZ_disk) {
                            return false;
                        }
                        boolean blnFoundMime = false;
                        String[] strMime = imd.iniVHOST.getPropertiesString(this.MOD_NAME, "compress", new String[0]);
                        int i2 = 0;
                        while (i2 < strMime.length) {
                            if (strMime[i2].equals(httpRES.strContentType)) {
                                blnFoundMime = true;
                                break;
                            }
                            ++i2;
                        }
                        if (!blnFoundMime) {
                            return false;
                        }
                        fis = null;
                        try {
                            try {
                                httpRES.lngLastModified = fl.lastModified() / 1000L * 1000L;
                                if (super.sendNotModified(httpREQ, imd, httpRES)) {
                                    Object var14_15 = null;
                                    break block18;
                                }
                                if (lngFileSize < (long)intCMPSZ_mem) {
                                    bl2 = this.sendFile_mem(fl, httpREQ, imd, httpRES);
                                    break block19;
                                }
                                bl = this.sendFile_disk(fl, httpREQ, imd, httpRES);
                                break block20;
                            }
                            catch (IOException iOException) {
                                break block21;
                            }
                            catch (Throwable e) {
                                this.logContext.write(e);
                                break block21;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var14_18 = null;
                            Helper.close(fis);
                            throw throwable;
                        }
                    }
                    Helper.close(fis);
                    return true;
                }
                Object var14_16 = null;
                Helper.close(fis);
                return bl2;
            }
            Object var14_17 = null;
            Helper.close(fis);
            return bl;
        }
        Object var14_19 = null;
        Helper.close(fis);
        return true;
    }

    protected boolean sendFile_disk(File flLocal, Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) throws IOException {
        File flCache;
        InputStream is;
        if (this.cnfConfig.blnDebug) {
            this.logContext.write("D Sending GZIP/DSK " + flLocal.getPath());
        }
        if ((is = this.pcc.getContent(flLocal, flCache = Helper.getCacheFile(imd), (PrecomputedFileContentProducer)new GZipFileContentProducer())) == null) {
            return false;
        }
        httpRES.intStatusCode = 200;
        httpRES.strStatusCode = "OK";
        httpRES.strContentEncoding = "gzip";
        httpRES.strVary = "*";
        httpRES.lngContentLength = this.pcc.getContentLength();
        this.writeResponseHeader(httpREQ, imd, httpRES);
        int i = 0;
        byte[] buffer = new byte[8192];
        while ((i = is.read(buffer)) != -1) {
            httpRES.osResponse.write(buffer, 0, i);
        }
        Helper.close(is);
        return true;
    }

    protected boolean sendFile_mem(File fl, Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) throws IOException {
        if (this.cnfConfig.blnDebug) {
            this.logContext.write("D Sending GZIP/MEM " + fl.getPath());
        }
        byte[] buffer = new byte[this.cnfConfig.intStreamBufferSize];
        DumbByteArrayOutputStream dbaos = new DumbByteArrayOutputStream((int)fl.length());
        GZIPOutputStream gzos = new GZIPOutputStream((OutputStream)dbaos);
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(fl);
                int i = 0;
                while ((i = fis.read(buffer)) != -1) {
                    gzos.write(buffer, 0, i);
                }
                ((FilterOutputStream)gzos).flush();
                gzos.close();
            }
            catch (IOException iOException) {
                Object var9_11 = null;
                Helper.close(fis);
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            Helper.close(fis);
            throw throwable;
        }
        Object var9_13 = null;
        Helper.close(fis);
        httpRES.intStatusCode = 200;
        httpRES.strStatusCode = "OK";
        httpRES.strContentEncoding = "gzip";
        httpRES.strVary = "*";
        httpRES.lngContentLength = dbaos.size();
        this.writeResponseHeader(httpREQ, imd, httpRES);
        httpRES.osResponse.write(dbaos.toByteArray(), 0, dbaos.size());
        dbaos = null;
        return true;
    }
}

