/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.main;

import de.zwanzigeins.sort.Comparator;
import de.zwanzigeins.sort.ComparatorStringReverse;
import de.zwanzigeins.sort.HelperSort;
import de.zwanzigeins.util.Application;
import de.zwanzigeins.util.HelperDT;
import de.zwanzigeins.util.HelperValidate;
import de.zwanzigeins.util.LockObject;
import de.zwanzigeins.util.LogContext;
import de.zwanzigeins.util.TimeFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.util.Date;
import java.util.TimeZone;
import net.zerotoaster.httpd.config.Configuration;
import net.zerotoaster.httpd.config.VHost_Configuration;
import net.zerotoaster.httpd.main.Httpd_Container;
import net.zerotoaster.httpd.mods.Mod_Base;
import net.zerotoaster.httpd.mods.Mod_LRWP;
import net.zerotoaster.httpd.mods.Mod_Statistics;
import net.zerotoaster.httpd.servlet.SessionManager;
import net.zerotoaster.httpd.util.Alarm;
import net.zerotoaster.httpd.util.CLF_Logger;
import net.zerotoaster.httpd.util.GlobalStatistics_Record;
import net.zerotoaster.httpd.util.Helper;

public class ZeroToaster
extends Application
implements Runnable {
    private LogContext logContext = null;
    private Configuration cnfConfig = null;
    private VHost_Configuration vhConfig = null;
    private SessionManager smManager = null;
    private Httpd_Container cntHTTPD = null;
    private Thread thrdWatchdog = null;
    private boolean blnIsRunning = false;
    private boolean blnRestartFlag = false;
    private LockObject objLock = null;
    private static int intCMD_OverridePort = -1;
    static Class class$de$zwanzigeins$util$LogContext;
    static Class class$net$zerotoaster$httpd$config$Configuration;

    public ZeroToaster(long AMODE, String strIniPath) {
        this.setThreadName("ZT-HTTP");
        this.init(AMODE, strIniPath);
        this.resetThreadName();
    }

    private void checkHosts() {
        try {
            Object[] strHosts = this.vhConfig.getAllHosts();
            HelperSort.quick((Object[])strHosts, (Comparator)new ComparatorStringReverse());
            int i = 0;
            while (i < strHosts.length) {
                Object strHost;
                Socket sok = null;
                Object strVHost = strHost = strHosts[i];
                if (!((String)strHost).equalsIgnoreCase("@default@") || !((String)(strHost = this.cntHTTPD.getSocketAddress().getHostAddress())).equals("0.0.0.0")) {
                    Object var8_9;
                    OutputStreamWriter osw = null;
                    BufferedReader br = null;
                    try {
                        try {
                            sok = new Socket((String)strHost, this.cntHTTPD.getSocketPort());
                            osw = new OutputStreamWriter(sok.getOutputStream());
                            br = new BufferedReader(new InputStreamReader(sok.getInputStream()));
                            osw.write("TEST / HTTP/1.1\r\n");
                            osw.write("Host: " + (String)strHost + "\r\n");
                            osw.write("\r\n");
                            osw.flush();
                            br.readLine();
                            this.logContext.write("# VHost " + (String)strVHost + " is up and reachable");
                        }
                        catch (IOException ex) {
                            this.logContext.write("? VHost " + (String)strVHost + " failed. Reason: " + ex.toString());
                        }
                    }
                    catch (Throwable throwable) {
                        var8_9 = null;
                        Helper.close(sok);
                        throw throwable;
                    }
                    var8_9 = null;
                    Helper.close(sok);
                }
                ++i;
            }
        }
        catch (Throwable t) {
            this.logContext.write("? Error in checkHosts()", t);
        }
        this.logContext.write("# Done checking VHOSTS");
    }

    private LogContext createLogContext() {
        LogContext log = null;
        if (this.cnfConfig.strLogScrn_Options.length() == 0) {
            this.cnfConfig.strLogScrn_Options = this.cnfConfig.strLogFile_Options;
        }
        if (Configuration.mode_nomainlog()) {
            this.cnfConfig.strLogScrn_Options = "";
            this.cnfConfig.strLogFile_Options = "";
        }
        try {
            log = new LogContext(this.cnfConfig.strLogFile_Path, this.cnfConfig.strLogFile_Praefix, this.cnfConfig.strLogFile_Suffix);
            log.setDateFormat(this.cnfConfig.strLogFile_DateFormat);
            log.setTimeFormat(this.cnfConfig.strLogFile_TimeFormat);
            log.setFilter_File(this.cnfConfig.strLogFile_Options);
            log.setFilter_Screen(this.cnfConfig.strLogScrn_Options);
            log.setYesterdayFile(this.cnfConfig.strLogFile_Yesterday);
            log.setLogfileKeep(this.cnfConfig.intLogFile_Keep);
            log.write("# Logfile opened");
            return log;
        }
        catch (IOException e) {
            System.err.println("Cannot open logfile");
            System.err.println(e);
            return null;
        }
    }

    private SessionManager createSessionManager() throws Throwable {
        if (!this.cnfConfig.blnUseServlets) {
            return null;
        }
        String strClass = this.cnfConfig.strSrvlSessionManager;
        this.logContext.write("# Starting Sessionmanager " + strClass);
        SessionManager smgr = null;
        try {
            Object[] objArgs = new Object[]{this.logContext, this.cnfConfig};
            Class[] classArray = new Class[2];
            Class<?> clazz = class$de$zwanzigeins$util$LogContext;
            if (clazz == null) {
                try {
                    clazz = class$de$zwanzigeins$util$LogContext = Class.forName("de.zwanzigeins.util.LogContext");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz2 = class$net$zerotoaster$httpd$config$Configuration;
            if (clazz2 == null) {
                try {
                    clazz2 = class$net$zerotoaster$httpd$config$Configuration = Class.forName("net.zerotoaster.httpd.config.Configuration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            Class[] clsArgs = classArray;
            Constructor<?> c = Class.forName(strClass).getConstructor(clsArgs);
            smgr = (SessionManager)((Object)c.newInstance(objArgs));
        }
        catch (ClassNotFoundException e) {
            this.logContext.write("? Class '" + strClass + "' not found");
            throw e;
        }
        catch (InstantiationException e) {
            this.logContext.write("? Cannot create instance for '" + strClass + "'");
            throw e;
        }
        catch (IllegalAccessException e) {
            this.logContext.write("? Access denied in class '" + strClass + "'");
            throw e;
        }
        catch (NoSuchMethodException e) {
            this.logContext.write("? No matching constructor in class '" + strClass + "'");
            throw e;
        }
        catch (InvocationTargetException e) {
            this.logContext.write("? Error starting class '" + strClass + "'", e.getTargetException());
            throw e.getTargetException();
        }
        catch (Throwable e) {
            this.logContext.write("? Unknown error while starting class '" + strClass + "'", e);
            throw e;
        }
        return smgr;
    }

    public void dispose() {
        if (this.blnDisposed) {
            return;
        }
        this.blnDisposed = true;
        if (this.logContext == null) {
            if (this.cnfConfig != null) {
                Configuration.dispose();
            }
            this.cnfConfig = null;
            return;
        }
        this.logContext.setSlowDown(0L);
        long AMODE = Configuration.AMODE;
        String strRestart_IniPath = Configuration.strIniPath;
        Mod_Statistics.dumpCheckpoints(-1L, this.logContext);
        if (this.vhConfig != null) {
            this.logContext.write("# Disposing VHost config");
            this.vhConfig.dispose();
            this.vhConfig = null;
        }
        if (this.smManager != null) {
            this.smManager.dispose();
            this.smManager = null;
        }
        Mod_LRWP.disposeLRWP();
        if (this.cntHTTPD != null) {
            this.logContext.write("# Disposing instances");
            this.cntHTTPD.dispose();
            this.cntHTTPD = null;
        }
        this.logContext.write("D Dispose CLF_Logger");
        CLF_Logger.dispose();
        this.logContext.write("D Dispose Config");
        Configuration.dispose();
        this.cnfConfig = null;
        Alarm.dispose();
        this.logContext.write("D Dispose Log");
        this.logContext.write("# Stopped ---------------------------");
        this.logContext.dispose();
        this.logContext = null;
        if (this.objLock != null) {
            this.objLock.dispose();
            this.objLock = null;
        }
        if (this.blnRestartFlag) {
            this.init(AMODE, strRestart_IniPath);
        }
    }

    private void init(long AMODE, String strIniPath) {
        this.blnDisposed = false;
        this.blnIsRunning = false;
        this.blnRestartFlag = false;
        GlobalStatistics_Record.lngServerStarted = TimeFactory.getTime();
        this.cnfConfig = Configuration.getConfig(AMODE, strIniPath);
        if (!Configuration.hasLoaded()) {
            System.out.println("zt_httpd.ini not found or not loaded");
            return;
        }
        if (intCMD_OverridePort != -1) {
            this.cnfConfig.intServer_Socket_listen_port = intCMD_OverridePort;
        }
        this.logContext = this.createLogContext();
        if (this.logContext == null) {
            System.out.println("Cannot create logcontext");
            this.dispose();
            return;
        }
        this.logContext.write("# ----------------------------------------------------");
        this.logContext.write("# ZeroToaster::HTTPD 1.63");
        this.logContext.write("# ----------------------------------------------------");
        Date d = new Date(TimeFactory.getTime());
        String tz = TimeZone.getDefault().getID();
        this.logContext.write("# Your timezone: " + tz);
        this.logContext.write("# Time/Date " + tz + ": " + HelperDT.getDDMMYYYY((Date)d) + " " + HelperDT.getHHMMSS((Date)d));
        this.logContext.write("# Time/Date GMT: " + Helper.toHTTPDate(d.getTime()));
        this.logContext.write("# Keep-alive: " + (this.cnfConfig.blnKeepAlive ? "ON" : "OFF"));
        this.logContext.write("# Classpath: " + System.getProperty("java.class.path"));
        CLF_Logger.init(this.cnfConfig, this.logContext);
        try {
            this.smManager = this.createSessionManager();
        }
        catch (Throwable throwable) {
            this.dispose();
            return;
        }
        try {
            this.vhConfig = new VHost_Configuration(this.cnfConfig, this.logContext, this.smManager);
        }
        catch (Throwable t) {
            this.logContext.write("? Error during VHost init", t);
            this.dispose();
            return;
        }
        if (!this.preloadMods()) {
            this.dispose();
            return;
        }
        this.cntHTTPD = new Httpd_Container(this.cnfConfig, this.vhConfig, this.logContext);
        if (this.cntHTTPD == null || this.cntHTTPD.getInstanceCount() == 0) {
            this.logContext.write("? No HTTPD Instances started, exit");
            this.dispose();
            return;
        }
        this.checkHosts();
        if (!Configuration.mode_nowatchdog()) {
            this.thrdWatchdog = new Thread((Runnable)this, "Watchdog");
            this.thrdWatchdog.setPriority(1);
            this.thrdWatchdog.start();
        }
    }

    public static void main(String[] args) {
        long AMODE = 0L;
        intCMD_OverridePort = -1;
        if (args.length == 1 && HelperValidate.isNumeric((String)args[0])) {
            intCMD_OverridePort = Integer.parseInt(args[0]);
        }
        ZeroToaster z = null;
        try {
            z = new ZeroToaster(AMODE, "");
        }
        catch (Throwable t) {
            if (z != null && z.logContext != null) {
                z.logContext.write("? Unhandled exception in .init():", t);
                z.logContext.dispose();
            }
            System.out.println("Unhandled exception in .init():");
            t.printStackTrace();
        }
    }

    private boolean preloadMods() {
        if (this.cnfConfig.strModules.length == 0) {
            this.logContext.write("# Module list is empty. Please verify [MODULES] in zt_httpd.ini");
            return false;
        }
        int i = 0;
        while (i < this.cnfConfig.strModules.length) {
            this.logContext.write("# Preloading Module " + this.cnfConfig.strModules[i]);
            try {
                Object[] objArgs = new Object[]{this.cnfConfig, this.logContext};
                Class[] classArray = new Class[2];
                Class<?> clazz = class$net$zerotoaster$httpd$config$Configuration;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("net.zerotoaster.httpd.config.Configuration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Class<?> clazz2 = class$de$zwanzigeins$util$LogContext;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("de.zwanzigeins.util.LogContext");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz2;
                Class[] clsArgs = classArray;
                Constructor<?> c = Class.forName(this.cnfConfig.strModules[i]).getConstructor(clsArgs);
                Mod_Base mp = (Mod_Base)((Object)c.newInstance(objArgs));
                if (mp == null) {
                    this.logContext.write("? Error preloading Module " + this.cnfConfig.strModules[i] + ": Got NULL after .newInstance(..)");
                }
                mp.dispose();
            }
            catch (Throwable t) {
                this.logContext.write("? Error preloading Module: " + t.toString());
                return false;
            }
            ++i;
        }
        return true;
    }

    public void run() {
        try {
            this.watchdog();
        }
        catch (Throwable t) {
            if (this.logContext != null) {
                this.logContext.write("? Error in Watchdog", t);
            } else {
                System.out.println("? Error in Watchdog " + t.toString());
            }
            this.dispose();
        }
    }

    public void signal_restart() {
        this.blnIsRunning = false;
        this.blnRestartFlag = true;
        this.dispose();
    }

    public void signal_shutdown() {
        this.blnIsRunning = false;
        this.blnRestartFlag = false;
        this.dispose();
    }

    private void watchdog() {
        long lngNow;
        this.objLock = new LockObject();
        this.blnIsRunning = true;
        File flSemShutdown = new File("shutdown");
        File flSemReload = new File("reload");
        File flSemRestart = new File("restart");
        File flSemStatus = new File("status");
        File flSemFullRestart = new File("fullrestart");
        flSemShutdown.delete();
        flSemReload.delete();
        flSemRestart.delete();
        flSemShutdown.delete();
        flSemFullRestart.delete();
        long lngLastSemCheck = lngNow = TimeFactory.getTime();
        long lngLastStatusDump = lngNow;
        this.logContext.write("D Started");
        while (this.blnIsRunning) {
            long lngCurrentTime = TimeFactory.getTime();
            Mod_Statistics.dumpCheckpoints(this.cnfConfig.lngCheckpointSave, this.logContext);
            if (lngCurrentTime - lngLastSemCheck > (long)this.cnfConfig.intSemaphoreCheck) {
                lngLastSemCheck = lngCurrentTime;
                if (flSemShutdown.exists()) {
                    flSemShutdown.delete();
                    this.logContext.write("# Shutdown initiated");
                    this.signal_shutdown();
                    System.exit(0);
                }
                if (flSemReload.exists()) {
                    flSemReload.delete();
                    this.logContext.write("# Reload VHOST config");
                    try {
                        this.vhConfig.reload();
                    }
                    catch (Throwable throwable) {
                        this.logContext.write("? Error during reload, shutdown");
                        this.dispose();
                        break;
                    }
                    this.checkHosts();
                }
                if (flSemRestart.exists()) {
                    flSemRestart.delete();
                    this.logContext.write("# Restart initiated");
                    this.signal_restart();
                    break;
                }
                if (flSemFullRestart.exists()) {
                    flSemFullRestart.delete();
                    this.logContext.write("# Full restart initiated");
                    this.signal_shutdown();
                    System.exit(50);
                }
                if (flSemStatus.exists()) {
                    flSemStatus.delete();
                    this.cntHTTPD.dumpStatus();
                }
            }
            if (this.cnfConfig.lngStatusDump > 0L && lngCurrentTime - lngLastStatusDump > this.cnfConfig.lngStatusDump) {
                lngLastStatusDump = lngCurrentTime;
                this.cntHTTPD.dumpStatus();
            }
            this.objLock.lo_wait(1000L);
        }
    }
}

