/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.main;

import de.zwanzigeins.io.CRLFInputStream;
import de.zwanzigeins.io.ExtendedBufferedOutputStream;
import de.zwanzigeins.util.Application;
import de.zwanzigeins.util.HelperDT;
import de.zwanzigeins.util.HelperFormat;
import de.zwanzigeins.util.InitializationException;
import de.zwanzigeins.util.LockObject;
import de.zwanzigeins.util.LogContext;
import java.io.BufferedInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.Vector;
import net.zerotoaster.httpd.config.Configuration;
import net.zerotoaster.httpd.config.VHost_Configuration;
import net.zerotoaster.httpd.main.Httpd_Instance;
import net.zerotoaster.httpd.mods.IntermediateModuleData;
import net.zerotoaster.httpd.mods.Mod_Error_Response;
import net.zerotoaster.httpd.mods.Mod_Statistics;
import net.zerotoaster.httpd.request.Http_Request;
import net.zerotoaster.httpd.response.Http_Response;
import net.zerotoaster.httpd.util.GlobalStatistics_Record;
import net.zerotoaster.httpd.util.Helper;
import net.zerotoaster.httpd.util.Statistics;
import net.zerotoaster.httpd.util.Statistics_Record;

public class Httpd_Container
extends Application
implements Runnable {
    private static volatile int intConnectionsServed;
    private Configuration cnfConfig = null;
    private LogContext logContext = null;
    private VHost_Configuration vhConfig = null;
    private Vector vecInstances = null;
    private Thread thrd = null;
    private boolean blnIsRunning = false;
    private ServerSocket ssok = null;
    private int intLastInstance = 0;
    private LockObject loWait = null;
    private LockObject loThreadRunning = null;

    public Httpd_Container(Configuration cnfConfig, VHost_Configuration vhConfig, LogContext logContext) {
        this.setThreadName("Httpd_Container");
        this.cnfConfig = cnfConfig;
        this.vhConfig = vhConfig;
        this.logContext = logContext;
        this.init();
        this.resetThreadName();
    }

    private void destroyServerSocket() {
        String strAddress = this.ssok.getInetAddress().getHostAddress();
        if (strAddress.equals("0.0.0.0")) {
            try {
                strAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Throwable throwable) {
                strAddress = "127.0.0.1";
            }
        }
        try {
            new Socket(strAddress, this.ssok.getLocalPort());
        }
        catch (Throwable throwable) {}
        Helper.close(this.ssok);
        this.ssok = null;
    }

    public void dispose() {
        this.blnIsRunning = false;
        this.blnDisposed = true;
        if (this.vecInstances != null) {
            int i = 0;
            while (i < this.vecInstances.size()) {
                this.logContext.write("D Stopping instance " + (i + 1) + "/" + this.vecInstances.size());
                ((Httpd_Instance)this.vecInstances.elementAt(i)).dispose();
                ++i;
            }
            this.vecInstances.removeAllElements();
        }
        if (this.ssok != null) {
            this.destroyServerSocket();
        }
        if (this.loWait != null) {
            this.loWait.dispose();
            this.loWait = null;
        }
        if (this.loThreadRunning != null) {
            this.loThreadRunning.dispose();
            this.loThreadRunning = null;
        }
        this.blnDisposed = true;
        this.logContext.write("# Instances disposed");
    }

    public synchronized void dumpStatus() {
        this.logContext.write("# Dumping status");
        Date d = new Date();
        PrintWriter pw = null;
        try {
            pw = new PrintWriter((Writer)new FileWriter(this.cnfConfig.strStatusExportFile), true);
            if (this.cnfConfig.strStatusExportTo.length() > 0) {
                pw.println("From: \"ZeroToaster::HTTPD 1.63\" <>");
                pw.println("To: " + this.cnfConfig.strStatusExportTo);
                pw.println("Subject: " + this.cnfConfig.strStatusExportSubject);
                pw.println("");
            }
            int intMaxUsed = 0;
            int i = 0;
            while (i < this.vecInstances.size()) {
                Httpd_Instance in = (Httpd_Instance)this.vecInstances.elementAt(i);
                StringBuffer strb = new StringBuffer();
                strb.append(HelperFormat.buildID((int)(i + 1), (int)this.vecInstances.size()));
                long lngUsed = in.timeLastUsed();
                strb.append(" " + (in.isBusy() ? " BUSY" : " idle"));
                strb.append(" Used ");
                if (lngUsed == 0L) {
                    strb.append("----- never -----");
                } else {
                    d.setTime(lngUsed);
                    strb.append(String.valueOf(HelperDT.getDDMMYY((Date)d)) + " " + HelperDT.getHHMMSS((Date)d));
                    ++intMaxUsed;
                }
                pw.println(strb.toString());
                ++i;
            }
            pw.println("");
            pw.println("Max instances used: " + intMaxUsed);
            int intHosts = 0;
            Statistics[] stat = Mod_Statistics.getStatistics();
            int i2 = 0;
            while (i2 < stat.length) {
                if (stat[i2] instanceof Statistics_Record) {
                    ++intHosts;
                }
                ++i2;
            }
            pw.println("Number of virtual hosts: " + intHosts);
            pw.println("");
            pw.println("Global statistics");
            pw.println("=========================================================");
            i2 = 0;
            while (i2 < stat.length) {
                if (stat[i2] instanceof GlobalStatistics_Record) {
                    stat[i2].setDetailLevel(1);
                    stat[i2].export_text(pw);
                }
                ++i2;
            }
            pw.println("=========================================================");
            pw.println("");
            pw.println("VHost statistics");
            i2 = 0;
            while (i2 < stat.length) {
                if (stat[i2] instanceof Statistics_Record) {
                    pw.println("=========================================================");
                    stat[i2].setDetailLevel(1);
                    stat[i2].export_text(pw);
                    pw.println("=========================================================");
                    pw.println("");
                }
                ++i2;
            }
            pw.println("[END]");
        }
        catch (IOException e) {
            this.logContext.write("? Error writing status '" + this.cnfConfig.strStatusExportFile + "' " + e.toString());
        }
        Helper.close(pw);
    }

    private void errorResponse(Socket sok, int intErr) {
        if (sok == null) {
            return;
        }
        Http_Request httpREQ = new Http_Request();
        Http_Response httpRES = new Http_Response();
        IntermediateModuleData imd = new IntermediateModuleData();
        try {
            httpREQ.crlfisRequest = new CRLFInputStream((InputStream)new BufferedInputStream(sok.getInputStream(), this.cnfConfig.intStreamBufferSize));
            if (!httpREQ.loadHeader(this.logContext)) {
                return;
            }
            imd.iniVHOST = this.vhConfig.getIniManager(httpREQ.strVHost);
            imd.init();
            httpRES.intStatusCode = intErr;
            httpRES.osResponse = new ExtendedBufferedOutputStream(sok.getOutputStream(), this.cnfConfig.intStreamBufferSize);
            Mod_Error_Response mdERR = new Mod_Error_Response(this.cnfConfig, this.logContext);
            mdERR.processRES(httpREQ, imd, httpRES);
            httpRES.osResponse.flush();
        }
        catch (IOException iOException) {
        }
        catch (Throwable t) {
            this.logContext.write("? Error during errorResponse(...)", t);
        }
    }

    public static int getConnectionsServed() {
        return intConnectionsServed;
    }

    public int getInstanceCount() {
        return this.vecInstances.size();
    }

    public InetAddress getSocketAddress() {
        return this.ssok.getInetAddress();
    }

    public int getSocketPort() {
        return this.ssok.getLocalPort();
    }

    private void init() {
        this.blnDisposed = false;
        this.blnIsRunning = false;
        this.loWait = new LockObject();
        this.vecInstances = new Vector(this.cnfConfig.intHTTP_instances);
        this.loThreadRunning = new LockObject();
        try {
            int i = 0;
            while (i < this.cnfConfig.intHTTP_instances) {
                Httpd_Instance in = new Httpd_Instance(this.cnfConfig, this.vhConfig, this.logContext, i);
                this.vecInstances.addElement(in);
                ++i;
            }
        }
        catch (InitializationException initializationException) {
            this.dispose();
            throw new InitializationException();
        }
        catch (Throwable t) {
            this.logContext.write("? Unhandled exception during creating instances", t);
            this.dispose();
            throw new InitializationException();
        }
        this.logContext.write("D " + this.cnfConfig.intHTTP_instances + " instances created");
        this.logContext.write("D Opening Server Socket on " + this.cnfConfig.strServer_Socket_listen_ip + ":" + this.cnfConfig.intServer_Socket_listen_port + " with backlog " + this.cnfConfig.intServer_Socket_backlog);
        try {
            InetAddress ina = null;
            if (!this.cnfConfig.strServer_Socket_listen_ip.equals("*")) {
                ina = InetAddress.getByName(this.cnfConfig.strServer_Socket_listen_ip);
            }
            this.ssok = new ServerSocket(this.cnfConfig.intServer_Socket_listen_port, this.cnfConfig.intServer_Socket_backlog, ina);
            this.logContext.write("D Server Socket opened (" + this.ssok.getInetAddress() + ")");
        }
        catch (Throwable t) {
            this.logContext.write("? Error creating server socket", t);
            this.dispose();
            return;
        }
        this.thrd = new Thread((Runnable)this, this.getThreadName());
        this.thrd.setPriority(1);
        this.thrd.start();
        this.loThreadRunning.lo_wait();
    }

    private boolean kickFreeInstance(Socket sok) {
        if (this.cnfConfig.blnSimulateOverload) {
            return false;
        }
        if (!this.cnfConfig.blnHTTP_roundrobin) {
            this.intLastInstance = 0;
        }
        int i = 0;
        while (i < this.vecInstances.size()) {
            if (this.intLastInstance > this.vecInstances.size()) {
                this.intLastInstance = 0;
            }
            Httpd_Instance hi = (Httpd_Instance)this.vecInstances.elementAt(this.intLastInstance);
            ++this.intLastInstance;
            if (hi.kickInstance(sok)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void run() {
        Socket sok = null;
        this.blnIsRunning = true;
        this.logContext.write("# Container started, ready to answer requests!");
        block3: while (this.blnIsRunning) {
            try {
                this.loThreadRunning.lo_notify();
                sok = this.ssok.accept();
                if (!this.blnIsRunning) {
                    this.logContext.write("# Shutdown");
                    Helper.close(sok);
                    return;
                }
                int intRetryMax = (int)(this.cnfConfig.lngInstanceMaxWait / (long)100);
                int intRetry = 0;
                while (true) {
                    if (this.kickFreeInstance(sok)) {
                        ++intConnectionsServed;
                        if (intRetry == 0) continue block3;
                        this.logContext.write("! Processed request after " + intRetry + " retries");
                        continue block3;
                    }
                    if (++intRetry > intRetryMax) {
                        this.logContext.write("! System still busy after " + intRetry + " retries, sending 503");
                        this.errorResponse(sok, 503);
                        Helper.close(sok);
                        continue block3;
                    }
                    this.loWait.lo_wait((long)100);
                }
            }
            catch (IOException iOException) {
                Helper.close(sok);
                if (this.blnIsRunning) continue;
                break;
            }
            catch (Throwable t) {
                Helper.close(sok);
                Helper.close(this.ssok);
                if (!this.blnIsRunning) break;
                this.logContext.write("? Can't continue", t);
                this.dispose();
                break;
            }
        }
    }
}

