/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.randomaccessdb;

import de.mmrodgau.webshop.control.NewsDataDefinition;
import de.zwanzigeins.randomaccessdb.DataRecord;
import de.zwanzigeins.randomaccessdb.DatabaseDefinition;
import de.zwanzigeins.randomaccessdb.Field;
import de.zwanzigeins.randomaccessdb.HeaderRecord;
import de.zwanzigeins.randomaccessdb.SearchRecord;
import de.zwanzigeins.sort.Comparator;
import de.zwanzigeins.sort.ComparatorString;
import de.zwanzigeins.sort.HelperSort;
import de.zwanzigeins.util.HelperPath;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Vector;

public class RandomAccessDatabase
extends DataRecord {
    private static Object LOCK = new Object();
    private RandomAccessFile rafFDB = null;
    private HeaderRecord hdrFDB = null;
    private int[] internalresult_array = null;
    private int internalresult_pointer = 0;
    private static final char VERSION = '0';

    public RandomAccessDatabase(DatabaseDefinition ddf) {
        super(ddf);
        String strDBDir = ddf.getDatabaseFile().getPath();
        strDBDir = HelperPath.splitPath_getPath(strDBDir);
        strDBDir = HelperPath.pathFixup(strDBDir, File.separator);
        strDBDir = HelperPath.removeTrailingSlashes(strDBDir);
        new File(strDBDir).mkdirs();
        try {
            this.dbOpen();
        }
        catch (IOException e) {
            throw new RuntimeException("init: " + e.toString());
        }
    }

    public void dbClose() {
        if (this.rafFDB != null) {
            try {
                this.rafFDB.close();
            }
            catch (Throwable throwable) {}
            this.rafFDB = null;
        }
        this.hdrFDB = null;
    }

    private void dbOpen() throws IOException {
        this.rafFDB = new RandomAccessFile(this.ddf.getDatabaseFile(), "rw");
        this.hdrFDB = new HeaderRecord(this.rafFDB);
        this.hdrFDB.read();
        if (this.rafFDB.length() < 64L) {
            this.hdrFDB.VERSION = 0;
            this.hdrFDB.PAGESIZE = this.ddf.getPagesize();
            this.hdrFDB.RECS_NORMAL = 0;
            this.hdrFDB.RECS_OVERFLOW = 0;
            this.hdrFDB.write();
            this.dump_header();
            return;
        }
        if (this.hdrFDB.VERSION == -1) {
            System.out.println("Converting " + this.ddf.getDatabaseFile().getPath() + " to version 0");
            long l = this.rafFDB.length();
            while (l >= 0L) {
                this.rafFDB.seek(l);
                int i = this.rafFDB.read();
                this.rafFDB.seek(l + 64L);
                this.rafFDB.write(i);
                --l;
            }
            this.rafFDB.seek(0L);
            int i = 0;
            while (i < 64) {
                this.rafFDB.write(32);
                ++i;
            }
            this.hdrFDB.VERSION = 0;
            this.hdrFDB.PAGESIZE = this.ddf.getPagesize();
            this.hdrFDB.RECS_NORMAL = this.fdb_records();
            this.hdrFDB.RECS_OVERFLOW = 0;
            this.hdrFDB.write();
            System.out.println("Converted to Version 0");
        }
        this.dump_header();
        if (this.hdrFDB.PAGESIZE != this.ddf.getPagesize()) {
            this.dbClose();
            throw new RuntimeException("Pagesize does not match. File: " + this.hdrFDB.PAGESIZE + " Definition: " + this.ddf.getPagesize());
        }
    }

    public void dump_header() {
        try {
            this.hdrFDB.read();
            System.out.println("File     : " + this.ddf.getDatabaseFile().getPath());
            System.out.println("Charset  : " + this.ddf.getCharset());
            System.out.println("Version  : " + this.hdrFDB.VERSION);
            System.out.println("Pagesize : " + this.hdrFDB.PAGESIZE);
            System.out.println("RecNormal: " + this.hdrFDB.RECS_NORMAL + "/" + this.fdb_records());
            System.out.println("RecOverfl: " + this.hdrFDB.RECS_OVERFLOW);
        }
        catch (IOException iOException) {
            System.out.println("cannot read header");
        }
    }

    private void fdb_del(int intRecNb) throws IOException {
        DataRecord dr = this.cloneRecord();
        this.fdb_recordseek(intRecNb);
        byte bytState = this.rafFDB.readByte();
        if (bytState != 66 && bytState != 70) {
            throw new RuntimeException("Record " + intRecNb + " corrupt");
        }
        this.rafFDB.read(dr.buffer);
        Enumeration e = dr.ddf.fieldEnumerator();
        while (e.hasMoreElements()) {
            String strUID;
            File fl;
            Field fld = (Field)e.nextElement();
            if (fld.bytType != 1 || (fl = this.ddf.getBlobFile(strUID = dr.getString(fld))) == null) continue;
            fl.delete();
        }
        this.fdb_recordseek(intRecNb);
        this.rafFDB.writeByte(70);
    }

    private boolean fdb_get(int idx) throws IOException {
        this.clear();
        this.fdb_recordseek(idx);
        byte bytState = this.rafFDB.readByte();
        if (bytState == 70) {
            return false;
        }
        if (bytState != 66) {
            throw new RuntimeException("Record " + idx + " corrupt");
        }
        this.rafFDB.read(this.buffer);
        return true;
    }

    private void fdb_put(int intRecNb) throws IOException {
        int intWriteRecord = intRecNb;
        if (intRecNb == -1) {
            intWriteRecord = this.hdrFDB.RECS_NORMAL;
            int i = 0;
            while (i < this.hdrFDB.RECS_NORMAL) {
                this.fdb_recordseek(i);
                byte bytState = this.rafFDB.readByte();
                if (bytState != 70 && bytState != 66) {
                    throw new RuntimeException("Record " + i + " corrupt");
                }
                if (bytState == 70) {
                    intWriteRecord = i;
                    break;
                }
                ++i;
            }
        }
        this.fdb_recordseek(intWriteRecord);
        this.rafFDB.writeByte(66);
        this.rafFDB.write(this.buffer);
        this.hdrFDB.read();
        if (intWriteRecord + 1 > this.hdrFDB.RECS_NORMAL) {
            this.hdrFDB.RECS_NORMAL = intWriteRecord + 1;
            this.hdrFDB.write();
        }
    }

    private int fdb_records() {
        int i = 0;
        try {
            double dblLen = this.rafFDB.length();
            double dblOff = 64.0;
            double dblPgs = this.ddf.getPagesize();
            i = (int)((dblLen - dblOff) / dblPgs);
            i = (int)((this.rafFDB.length() - 64L) / (long)this.ddf.getPagesize());
        }
        catch (IOException iOException) {}
        return i;
    }

    private void fdb_recordseek(int intRecord) {
        try {
            this.rafFDB.seek(intRecord * this.ddf.getPagesize() + 64);
        }
        catch (IOException iOException) {}
    }

    private int[] fdb_search(SearchRecord sr, int intSortOrder) throws IOException {
        Vector<String> vecResult = new Vector<String>();
        DataRecord dr = this.cloneRecord();
        int i = 0;
        while (i < this.hdrFDB.RECS_NORMAL) {
            this.fdb_recordseek(i);
            if (this.rafFDB.readByte() != 70) {
                this.rafFDB.read(dr.buffer);
                if (dr.equals(sr)) {
                    if (intSortOrder != 0) {
                        vecResult.addElement(String.valueOf(dr.sortString()) + "#" + this.rset(Integer.toString(i), 16));
                    } else {
                        vecResult.addElement(Integer.toString(i));
                    }
                }
            }
            ++i;
        }
        switch (intSortOrder) {
            case -1: 
            case 1: {
                HelperSort.quick(vecResult, (Comparator)new ComparatorString(intSortOrder));
                break;
            }
        }
        int[] res = new int[vecResult.size()];
        int i2 = 0;
        while (i2 < vecResult.size()) {
            String s = (String)vecResult.elementAt(i2);
            if (intSortOrder != 0) {
                s = s.substring(s.length() - 16).trim();
            }
            res[i2] = Integer.parseInt(s);
            ++i2;
        }
        return res;
    }

    public void finalize() {
        this.dbClose();
    }

    public static void main(String[] args) throws Throwable {
        NewsDataDefinition ddf = null;
        RandomAccessDatabase rad = null;
        ddf = new NewsDataDefinition("C:\\4\\");
        rad = new RandomAccessDatabase((DatabaseDefinition)ddf);
        rad.recordGet(0);
        System.out.println("-------------------------------");
        System.out.println(rad);
        System.out.println("-------------------------------");
        rad.recordGet(rad.hdrFDB.RECS_NORMAL - 1);
        System.out.println(rad);
        System.out.println("-------------------------------");
        rad.dbClose();
    }

    public void recordDelete(int intRecNb) {
        Object object = LOCK;
        synchronized (object) {
            if (intRecNb < 0 || intRecNb > this.hdrFDB.RECS_NORMAL) {
                throw new RuntimeException("recordDel: Recordnumber out of range");
            }
            try {
                this.fdb_del(intRecNb);
            }
            catch (IOException e) {
                throw new RuntimeException("recordDel: " + e.toString());
            }
        }
    }

    public void recordDelete(SearchRecord sr) {
        Object object = LOCK;
        synchronized (object) {
            try {
                int[] result = this.fdb_search(sr, 0);
                int i = 0;
                while (i < result.length) {
                    this.fdb_del(result[i]);
                    ++i;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("recordDelete: " + e.toString());
            }
        }
    }

    public boolean recordFind(SearchRecord sr) {
        Object object = LOCK;
        synchronized (object) {
            try {
                this.clear();
                int[] result = this.fdb_search(sr, 0);
                if (result.length != 0) {
                    this.fdb_get(result[0]);
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                throw new RuntimeException("recordFind: " + e.toString());
            }
        }
    }

    private boolean recordFindCursor(SearchRecord sr, int intSortOrder) {
        Object object = LOCK;
        synchronized (object) {
            try {
                this.clear();
                this.internalresult_array = this.fdb_search(sr, intSortOrder);
                this.internalresult_pointer = 0;
                if (this.internalresult_pointer < this.internalresult_array.length) {
                    this.fdb_get(this.internalresult_array[this.internalresult_pointer++]);
                    return true;
                }
                this.internalresult_array = null;
                this.internalresult_pointer = 0;
                return false;
            }
            catch (IOException e) {
                throw new RuntimeException("recordFindCursor: " + e.toString());
            }
        }
    }

    public boolean recordFindFirst(SearchRecord sr) {
        return this.recordFindCursor(sr, 1);
    }

    public boolean recordFindLast(SearchRecord sr) {
        return this.recordFindCursor(sr, -1);
    }

    public boolean recordFindNext() {
        Object object = LOCK;
        synchronized (object) {
            if (this.internalresult_array == null) {
                throw new RuntimeException("recordFindNext without recordFindFirst!");
            }
            try {
                this.clear();
                if (this.internalresult_pointer < this.internalresult_array.length) {
                    this.fdb_get(this.internalresult_array[this.internalresult_pointer++]);
                    return true;
                }
                this.internalresult_array = null;
                this.internalresult_pointer = 0;
                return false;
            }
            catch (IOException e) {
                throw new RuntimeException("recordFindNext: " + e.toString());
            }
        }
    }

    public void recordGet(int intRecNb) {
        Object object = LOCK;
        synchronized (object) {
            if (intRecNb < 0 || intRecNb >= this.hdrFDB.RECS_NORMAL) {
                throw new RuntimeException("recordGet: Recordnumber out of range");
            }
            try {
                this.clear();
                this.fdb_get(intRecNb);
            }
            catch (IOException e) {
                throw new RuntimeException("recordGet: " + e.toString());
            }
        }
    }

    public void recordPut(int intRecNb) {
        Object object = LOCK;
        synchronized (object) {
            if (intRecNb < 0 || intRecNb > this.hdrFDB.RECS_NORMAL) {
                throw new RuntimeException("recordPut: Recordnumber out of range");
            }
            try {
                this.fdb_put(intRecNb);
            }
            catch (IOException e) {
                throw new RuntimeException("recordPut: " + e.toString());
            }
        }
    }

    public void recordUpdate() {
        Object object = LOCK;
        synchronized (object) {
            try {
                int[] result = this.fdb_search(this, 0);
                if (result.length == 0) {
                    this.fdb_put(-1);
                    return;
                }
                if (result.length == 1) {
                    this.fdb_put(result[0]);
                    return;
                }
                throw new RuntimeException("recordUpdate: duplicate results");
            }
            catch (IOException e) {
                throw new RuntimeException("recordUpdate: " + e.toString());
            }
        }
    }
}

