/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import net.zerotoaster.httpd.servlet.IntermediateServletData;
import net.zerotoaster.httpd.servlet.ServletContext_Impl;
import net.zerotoaster.httpd.servlet.ServletInputStream_Impl;
import net.zerotoaster.httpd.util.Helper;

public class ServletRequest_Impl
implements ServletRequest {
    protected ServletContext_Impl srvlContext = null;
    protected IntermediateServletData reqdat = null;
    private Hashtable hshQueryParams = null;
    private BufferedReader brInput = null;
    private ServletInputStream isInput = null;
    private String strForcedCharset = null;

    public ServletRequest_Impl(IntermediateServletData reqdat) {
        this.reqdat = reqdat;
        this.loadQueryData();
    }

    public Object getAttribute(String s) {
        return this.reqdat.hshRequestAttribs.get(s);
    }

    public Enumeration getAttributeNames() {
        return this.reqdat.hshRequestAttribs.keys();
    }

    public String getCharacterEncoding() {
        if (this.reqdat.reqHTTP.qrAccept_Charset.length > 0) {
            return this.reqdat.reqHTTP.qrAccept_Charset[0].strToken;
        }
        return "";
    }

    public int getContentLength() {
        return (int)this.reqdat.reqHTTP.lngContentLength;
    }

    public String getContentType() {
        return this.reqdat.reqHTTP.strContentType;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.brInput != null) {
            throw new IllegalStateException("Stream already got as reader");
        }
        if (this.isInput != null) {
            return this.isInput;
        }
        this.isInput = new ServletInputStream_Impl(this.reqdat.reqHTTP.crlfisRequest);
        return this.isInput;
    }

    public String getLocalAddr() {
        return this.reqdat.imd.strLocalServerAddress;
    }

    public Locale getLocale() {
        if (this.reqdat.reqHTTP.qrAccept_Language.length == 0) {
            return Locale.getDefault();
        }
        String strLocale = this.reqdat.reqHTTP.qrAccept_Language[0].strToken;
        if (strLocale.length() == 2) {
            return new Locale(strLocale.toLowerCase(), strLocale.toUpperCase());
        }
        if (strLocale.length() == 5) {
            return new Locale(strLocale.substring(0, 2).toLowerCase(), strLocale.substring(3, 5).toUpperCase());
        }
        return Locale.getDefault();
    }

    public Enumeration getLocales() {
        Vector<Locale> vec = new Vector<Locale>(this.reqdat.reqHTTP.qrAccept_Language.length);
        int i = 0;
        while (i < this.reqdat.reqHTTP.qrAccept_Language.length) {
            String strLocale = this.reqdat.reqHTTP.qrAccept_Language[i].strToken;
            if (strLocale.length() == 2) {
                vec.addElement(new Locale(strLocale.toLowerCase(), strLocale.toUpperCase()));
            }
            if (strLocale.length() == 5) {
                vec.addElement(new Locale(strLocale.substring(0, 2).toLowerCase(), strLocale.substring(3, 5).toUpperCase()));
            }
            ++i;
        }
        if (vec.size() == 0) {
            vec.addElement(Locale.getDefault());
        }
        return vec.elements();
    }

    public String getLocalName() {
        return this.reqdat.imd.strLocalServerName;
    }

    public int getLocalPort() {
        return this.reqdat.imd.intLocalServerPort;
    }

    public String getParameter(String strKey) {
        try {
            return ((String[])this.hshQueryParams.get(strKey))[0];
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public Enumeration getParameterNames() {
        return this.hshQueryParams.keys();
    }

    public String[] getParameterValues(String strKey) {
        return (String[])this.hshQueryParams.get(strKey);
    }

    public String getProtocol() {
        return this.reqdat.reqHTTP.strProtocol;
    }

    public BufferedReader getReader() throws IOException {
        if (this.isInput != null) {
            throw new IllegalStateException("Reader already got as stream");
        }
        if (this.brInput != null) {
            return this.brInput;
        }
        String strEnc = this.strForcedCharset;
        if (strEnc == null || strEnc.length() == 0) {
            strEnc = this.getCharacterEncoding();
        }
        this.brInput = strEnc == null ? new BufferedReader(new InputStreamReader((InputStream)this.reqdat.reqHTTP.crlfisRequest)) : new BufferedReader(new InputStreamReader((InputStream)this.reqdat.reqHTTP.crlfisRequest, strEnc));
        return this.brInput;
    }

    public String getRealPath(String s) {
        throw new RuntimeException("Deprecated use ServletContext#getRealPath(..) instead");
    }

    public String getRemoteAddr() {
        return this.reqdat.imd.strRemoteServerAddress;
    }

    public String getRemoteHost() {
        return this.reqdat.imd.strRemoteServerName;
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return null;
    }

    public String getScheme() {
        int pp = this.reqdat.reqHTTP.strProtocol.indexOf("/");
        if (pp == -1) {
            return "http";
        }
        return this.reqdat.reqHTTP.strProtocol.substring(0, pp).toLowerCase();
    }

    public String getServerName() {
        return this.reqdat.reqHTTP.strVHost;
    }

    public int getServerPort() {
        return this.reqdat.imd.intLocalServerPort;
    }

    public boolean isSecure() {
        return this.reqdat.reqHTTP.strProtocol.toLowerCase().startsWith("https");
    }

    private void loadQueryData() {
        String strQuery = this.reqdat.reqHTTP.strQuery;
        boolean blnValid = true;
        blnValid &= this.reqdat.reqHTTP.lngContentLength > 0L;
        blnValid &= this.reqdat.reqHTTP.lngContentLength < 262144L;
        blnValid &= this.reqdat.reqHTTP.strAction.equals("POST");
        if (blnValid &= this.reqdat.reqHTTP.strContentType.equalsIgnoreCase("application/x-www-form-urlencoded")) {
            int intReadLen = (int)this.reqdat.reqHTTP.lngContentLength;
            byte[] bytBuffer = new byte[intReadLen];
            int i = -1;
            int intCnt = 0;
            try {
                while (intReadLen > 0) {
                    i = this.reqdat.reqHTTP.crlfisRequest.read(bytBuffer, intCnt, intReadLen);
                    intCnt += i;
                    intReadLen -= i;
                }
            }
            catch (IOException iOException) {
                i = -1;
            }
            if (i != -1) {
                if (strQuery.length() > 0 && !strQuery.endsWith("&")) {
                    strQuery = String.valueOf(strQuery) + "&";
                }
                strQuery = String.valueOf(strQuery) + new String(bytBuffer, 0, bytBuffer.length);
            }
        }
        this.hshQueryParams = Helper.parseQueryString(strQuery);
    }

    public void removeAttribute(String s) {
        this.reqdat.hshRequestAttribs.remove(s);
    }

    public void setAttribute(String s, Object obj) {
        this.reqdat.hshRequestAttribs.put(s, obj);
    }

    public void setCharacterEncoding(String s) throws UnsupportedEncodingException {
        this.strForcedCharset = s;
    }
}

