/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

import de.zwanzigeins.util.Application;
import de.zwanzigeins.util.HelperValidate;
import de.zwanzigeins.util.InitializationException;
import de.zwanzigeins.util.LockObject;
import de.zwanzigeins.util.TimeFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public class LogContext
extends Application
implements Runnable {
    private Vector vecLogLines = new Vector(255);
    private String strFilePath = null;
    private String strFilePraefix = null;
    private String strFileSuffix = null;
    private PrintWriter pwLog = null;
    private StringBuffer strb = null;
    private static String LF = null;
    private String strLogFilter_File = null;
    private String strLogFilter_Screen = null;
    private int intLogExternal = 0;
    private SimpleDateFormat sdf = null;
    private String strDateFormat = "dd.MM.yyyy";
    private String strTimeFormat = "HH.mm.ss";
    private Date datBuffer = null;
    private Calendar calMidnight = null;
    private int intToday = 0;
    private String strCurrentLogfile = null;
    private boolean blnFileOutput = false;
    private long lngSlowDown = 0L;
    private String strYesterdayFile = "";
    private int intKeepDays = 0;
    private LockObject loThreadStart = null;
    private Thread thrdLogging = null;
    private LockObject objLock = null;
    private volatile Vector vecQueue = null;
    private volatile boolean blnIsRunning = false;
    private static final int QUEUE_SIZE = 50;

    public LogContext() {
        this.blnFileOutput = false;
        try {
            this.init();
        }
        catch (IOException iOException) {
            throw new InitializationException();
        }
    }

    public LogContext(String strPath, String strPraefix, String strSuffix) throws IOException {
        this.strFilePath = strPath;
        this.strFilePraefix = strPraefix;
        this.strFileSuffix = strSuffix;
        this.blnFileOutput = true;
        this.intLogExternal = 0;
        this.init();
    }

    private void addQueue(String strMsg, Throwable t, long lngTime, String strThreadName) {
        if (this.blnDisposed) {
            return;
        }
        LogMessage lm = new LogMessage(this);
        lm.strThread = strThreadName;
        lm.strMsg = strMsg;
        lm.thrw = t;
        lm.lngTime = lngTime;
        this.vecQueue.addElement(lm);
        this.objLock.lo_notify();
    }

    private boolean createYesterdayFile(String strOldFile, String strNewFile) {
        FileInputStream fis = null;
        OutputStream fos = null;
        boolean blnHasError = false;
        try {
            try {
                byte[] bytBuffer = new byte[1024];
                int i = 0;
                fis = new FileInputStream(strOldFile);
                fos = new FileOutputStream(strNewFile);
                while ((i = fis.read(bytBuffer)) != -1) {
                    ((FileOutputStream)fos).write(bytBuffer, 0, i);
                }
            }
            catch (Throwable throwable) {
                blnHasError = true;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                fos.flush();
                ((FileOutputStream)fos).close();
                fis.close();
            }
            catch (IOException iOException) {
                blnHasError = true;
            }
            throw throwable;
        }
        Object var6_10 = null;
        try {
            fos.flush();
            ((FileOutputStream)fos).close();
            fis.close();
        }
        catch (IOException iOException) {
            blnHasError = true;
        }
        File flTarget = new File(strNewFile);
        if (blnHasError && flTarget.exists()) {
            flTarget.delete();
        }
        return !blnHasError;
    }

    private void deleteOld() {
        String strDeleteDate = null;
        SimpleDateFormat simpleDateFormat = this.sdf;
        synchronized (simpleDateFormat) {
            this.datBuffer.setTime(TimeFactory.getTime() - (long)this.intKeepDays * 1000L * 60L * 60L * 24L);
            strDeleteDate = this.sdf.format(this.datBuffer);
        }
        File flLogDir = new File(this.strFilePath);
        String[] strLogFiles = flLogDir.list();
        int i = 0;
        while (i < strLogFiles.length) {
            block9: {
                String strCmp;
                block10: {
                    block8: {
                        strCmp = strLogFiles[i];
                        if (this.strFilePraefix.length() <= 0) break block8;
                        if (!strCmp.startsWith(this.strFilePraefix)) break block9;
                        strCmp = strCmp.substring(this.strFilePraefix.length());
                    }
                    if (this.strFileSuffix.length() <= 0) break block10;
                    if (!strCmp.endsWith(this.strFileSuffix)) break block9;
                    strCmp = strCmp.substring(0, strCmp.length() - this.strFileSuffix.length());
                }
                if (strCmp.length() == 8 && HelperValidate.isNumeric(strCmp) && strCmp.compareTo(strDeleteDate) <= 0) {
                    new File(flLogDir, strLogFiles[i]).delete();
                }
            }
            ++i;
        }
    }

    public void dispose() {
        if (this.blnDisposed) {
            return;
        }
        this.blnDisposed = true;
        this.flush();
        this.blnIsRunning = false;
        this.objLock.lo_notify();
        this.writeInternal("# LogContext closed", null, TimeFactory.getTime(), Thread.currentThread().getName());
        if (this.pwLog != null) {
            this.pwLog.close();
            this.pwLog = null;
        }
        this.objLock.dispose();
        this.objLock = null;
        this.loThreadStart.dispose();
        this.loThreadStart = null;
        this.strLogFilter_File = null;
        this.strLogFilter_Screen = null;
        this.strFilePath = null;
        this.strFilePraefix = null;
        this.strFileSuffix = null;
        this.thrdLogging = null;
    }

    public synchronized void flush() {
        if (this.blnDisposed) {
            return;
        }
        this.objLock.lo_notify();
        LockObject o = new LockObject();
        while (this.vecQueue.size() > 0) {
            o.lo_wait(100L);
        }
        o.dispose();
    }

    public String getCurrentLogFile() {
        return this.strCurrentLogfile;
    }

    public String getDateFormat() {
        return this.strDateFormat;
    }

    public String[] getLogBuffer() {
        Object[] s = new String[this.vecLogLines.size()];
        this.vecLogLines.copyInto(s);
        return s;
    }

    public int getLogfileKeep() {
        return this.intKeepDays;
    }

    public String getLogfilePath() {
        return this.strFilePath;
    }

    public long getSlowDown() {
        return this.lngSlowDown;
    }

    public String getTimeFormat() {
        return this.strTimeFormat;
    }

    public String getYesterdayFile() {
        return this.strYesterdayFile;
    }

    private void init() throws IOException {
        this.loThreadStart = new LockObject();
        this.objLock = new LockObject();
        this.vecQueue = new Vector(50, 5);
        LF = System.getProperty("line.separator");
        this.strb = new StringBuffer(100);
        this.sdf = new SimpleDateFormat();
        this.datBuffer = new Date(TimeFactory.getTime());
        this.calMidnight = Calendar.getInstance();
        this.intToday = -1;
        if (this.blnFileOutput) {
            if (this.strFileSuffix == null) {
                this.strFileSuffix = "";
            }
            if (this.strFileSuffix.length() != 0 && !this.strFileSuffix.startsWith(".")) {
                this.strFileSuffix = "." + this.strFileSuffix;
            }
            if (this.strFilePath == null) {
                this.strFilePath = "";
            }
            if (this.strFilePath.length() != 0 && !this.strFilePath.endsWith(File.separator)) {
                this.strFilePath = String.valueOf(this.strFilePath) + File.separator;
            }
        }
        this.thrdLogging = new Thread((Runnable)this, "LogContext");
        this.thrdLogging.start();
        this.loThreadStart.lo_wait();
    }

    private void openFile(long lngSessionTime) throws IOException {
        File path;
        this.datBuffer.setTime(TimeFactory.getTime());
        this.calMidnight.setTime(this.datBuffer);
        if (this.intToday == this.calMidnight.get(6)) {
            return;
        }
        this.intToday = this.calMidnight.get(6);
        String strDate = null;
        SimpleDateFormat simpleDateFormat = this.sdf;
        synchronized (simpleDateFormat) {
            this.datBuffer.setTime(lngSessionTime);
            this.sdf.applyPattern("yyyyMMdd");
            strDate = this.sdf.format(this.datBuffer);
        }
        String strFile = String.valueOf(this.strFilePraefix) + strDate + this.strFileSuffix;
        if (this.strFilePath.length() != 0 && !(path = new File(this.strFilePath)).exists()) {
            path.mkdirs();
        }
        if (this.strFilePath.length() != 0) {
            strFile = this.strFilePath.endsWith(File.separator) ? String.valueOf(this.strFilePath) + strFile : String.valueOf(this.strFilePath) + File.separator + strFile;
        }
        if (this.pwLog != null) {
            this.pwLog.flush();
            this.pwLog.close();
        }
        if (this.strYesterdayFile.length() > 0 && this.strCurrentLogfile != null) {
            this.createYesterdayFile(this.strCurrentLogfile, this.strYesterdayFile);
        }
        if (this.intKeepDays > 0) {
            this.deleteOld();
        }
        this.pwLog = new PrintWriter((Writer)new FileWriter(strFile, true), true);
        this.strCurrentLogfile = strFile;
    }

    protected void outputBuffer(StringBuffer strb) {
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        this.blnIsRunning = true;
        this.loThreadStart.lo_notify();
        while (this.blnIsRunning) {
            if (this.blnIsRunning && this.vecQueue.size() == 0) {
                this.objLock.lo_wait();
            }
            if (this.blnIsRunning) ** GOTO lbl16
            break;
lbl-1000:
            // 1 sources

            {
                lm = (LogMessage)this.vecQueue.elementAt(0);
                this.writeInternal(lm.strMsg, lm.thrw, lm.lngTime, lm.strThread);
                this.vecQueue.removeElementAt(0);
                if (this.lngSlowDown == 0L || lm.strMsg.charAt(0) == 'R') continue;
                try {
                    Thread.sleep(this.lngSlowDown);
                    continue;
                }
                catch (InterruptedException v0) {}
lbl16:
                // 4 sources

                ** while (this.vecQueue.size() > 0)
            }
lbl17:
            // 1 sources

        }
    }

    public void setDateFormat(String strPattern) {
        this.strDateFormat = strPattern;
    }

    public void setFilter_File(String strFilter) {
        this.strLogFilter_File = strFilter;
    }

    public void setFilter_Screen(String strFilter) {
        this.strLogFilter_Screen = strFilter;
    }

    public void setLogfileKeep(int i) {
        this.intKeepDays = i;
    }

    public void setSlowDown(long l) {
        this.lngSlowDown = l;
    }

    public void setTimeFormat(String strPattern) {
        this.strTimeFormat = strPattern;
    }

    public void setYesterdayFile(String str) {
        this.strYesterdayFile = str;
    }

    private boolean validFilter(String strLogLine, String strMask) {
        if (strMask == null) {
            return true;
        }
        if (strMask.length() == 0) {
            return false;
        }
        return strMask.indexOf(strLogLine) != -1;
    }

    private boolean validFilter_File(String s) {
        return this.validFilter(s, this.strLogFilter_File);
    }

    private boolean validFilter_Screen(String s) {
        return this.validFilter(s, this.strLogFilter_Screen);
    }

    public void write(String strMessage) {
        if (!this.blnIsRunning) {
            return;
        }
        this.addQueue(strMessage, null, TimeFactory.getTime(), Thread.currentThread().getName());
    }

    public void write(String strMessage, Throwable t) {
        if (!this.blnIsRunning) {
            return;
        }
        this.addQueue(strMessage, t, TimeFactory.getTime(), Thread.currentThread().getName());
    }

    public void write(Throwable t) {
        if (!this.blnIsRunning) {
            return;
        }
        this.addQueue(null, t, TimeFactory.getTime(), Thread.currentThread().getName());
    }

    private void writeInternal(String string, Throwable thrMsg, long lngTime, String strThread) {
        String strPraefix;
        String strMsg;
        if (string == null) {
            strMsg = "! " + thrMsg.getMessage();
        }
        if (strMsg.length() == 0) {
            strMsg = "?";
        }
        if ((strPraefix = strMsg.substring(0, 1)).equals(" ")) {
            this.write("! Warning: invalid logentry follows");
            strPraefix = "?";
        }
        String strSuffix = strMsg.substring(1).trim();
        this.strb.setLength(0);
        this.datBuffer.setTime(lngTime);
        this.sdf.applyPattern(this.strDateFormat);
        this.strb.append(this.sdf.format(this.datBuffer));
        this.strb.append(" ");
        this.sdf.applyPattern(this.strTimeFormat);
        this.strb.append(this.sdf.format(this.datBuffer));
        String strMS = Long.toString(lngTime);
        this.strb.append(".");
        this.strb.append(strMS.substring(strMS.length() - 3));
        this.strb.append(" ");
        this.strb.append(strPraefix);
        this.strb.append(" '");
        this.strb.append(strThread);
        this.strb.append("' ");
        String strLog = this.strb.toString();
        this.strb.setLength(0);
        this.strb.append(strLog);
        this.strb.append(strSuffix);
        if (thrMsg != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                thrMsg.printStackTrace(pw);
                BufferedReader br = new BufferedReader(new StringReader(sw.toString()));
                String strBuffer = null;
                while ((strBuffer = br.readLine()) != null) {
                    if ((strBuffer = strBuffer.trim()).length() == 0) continue;
                    this.strb.append(LF);
                    this.strb.append(strLog);
                    this.strb.append("::");
                    this.strb.append(strBuffer);
                }
            }
            catch (IOException iOException) {}
        }
        this.outputBuffer(this.strb);
        String strLogLine = this.strb.toString();
        if (this.validFilter_File(strPraefix) && this.blnFileOutput) {
            try {
                this.openFile(lngTime);
                this.pwLog.println(strLogLine);
            }
            catch (Throwable throwable) {}
        }
        if (this.validFilter_Screen(strPraefix)) {
            System.out.println(strLogLine);
        }
        if (this.vecLogLines.size() == this.vecLogLines.capacity()) {
            this.vecLogLines.removeElementAt(0);
        }
        this.vecLogLines.addElement(strLogLine);
    }

    class LogMessage {
        /* synthetic */ LogContext this$0;
        String strThread;
        String strMsg;
        Throwable thrw;
        long lngTime;

        LogMessage(LogContext this$0) {
            this.this$0 = this$0;
        }
    }
}

