/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;

public class HelperIO {
    private static final Object objLock = new Object();
    private static Hashtable hshLockedFiles = new Hashtable();

    private HelperIO() {
    }

    public static final boolean close(Object o) {
        if (o == null) {
            return true;
        }
        try {
            if (o instanceof RandomAccessFile) {
                ((RandomAccessFile)o).close();
                return true;
            }
            if (o instanceof InputStream) {
                ((InputStream)o).close();
                return true;
            }
            if (o instanceof OutputStream) {
                ((OutputStream)o).close();
                return true;
            }
            if (o instanceof Writer) {
                ((Writer)o).close();
                return true;
            }
            if (o instanceof Reader) {
                ((Reader)o).close();
                return true;
            }
            if (o instanceof ServerSocket) {
                ((ServerSocket)o).close();
                return true;
            }
            if (o instanceof Socket) {
                ((Socket)o).close();
                return true;
            }
            if (o instanceof Connection) {
                ((Connection)o).close();
                return true;
            }
            if (o instanceof Statement) {
                ((Statement)o).close();
                return true;
            }
            if (o instanceof PreparedStatement) {
                ((PreparedStatement)o).close();
                return true;
            }
            if (o instanceof ResultSet) {
                ((ResultSet)o).close();
                return true;
            }
        }
        catch (Throwable throwable) {}
        return false;
    }

    public static final boolean commit(Connection con) {
        if (con == null) {
            return true;
        }
        try {
            con.commit();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static final boolean fileLock(String strFile) {
        Hashtable hashtable = hshLockedFiles;
        synchronized (hashtable) {
            if (hshLockedFiles.containsKey(strFile)) {
                return false;
            }
            hshLockedFiles.put(strFile, "0");
            return true;
        }
    }

    public static final Enumeration filesLocked() {
        return hshLockedFiles.keys();
    }

    public static final boolean fileUnlock(String strFile) {
        Hashtable hashtable = hshLockedFiles;
        synchronized (hashtable) {
            return hshLockedFiles.remove(strFile) != null;
        }
    }

    public static final void flush(Object o) {
        if (o == null) {
            return;
        }
        try {
            if (o instanceof OutputStream) {
                ((OutputStream)o).flush();
                return;
            }
            if (o instanceof Writer) {
                ((Writer)o).flush();
                return;
            }
        }
        catch (Throwable throwable) {}
    }

    public static final boolean rollback(Connection con) {
        if (con == null) {
            return true;
        }
        try {
            con.rollback();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

