/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.sql;

import de.zwanzigeins.sql.SQLconnection;
import de.zwanzigeins.util.HelperDT;
import de.zwanzigeins.util.HelperFilter;
import de.zwanzigeins.util.HelperIO;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.util.Hashtable;

public class HtmlSQLQueryModule {
    private Connection con = null;
    private String strQuery = null;
    int intQueryParams = 0;
    private Object[] objQueryParams = null;
    private Statement stmt = null;
    private ResultSet res = null;
    private int intRowCount = 0;
    private String[] strLastRow = null;
    private Hashtable hshLinkTable = null;

    public HtmlSQLQueryModule(Connection con) {
        this.con = con;
        this.reset();
    }

    public void addQueryLine(String string) {
        String q = string.trim();
        this.strQuery = this.strQuery == null ? q : String.valueOf(this.strQuery) + " " + q;
        int i = 0;
        while (i < q.length()) {
            if (q.charAt(i) == '?') {
                ++this.intQueryParams;
            }
            ++i;
        }
    }

    public String execQuery() {
        int i;
        try {
            this.stmt = this.con.createStatement();
            this.res = this.stmt.executeQuery(this.prepareQuery(this.strQuery));
        }
        catch (SQLException e) {
            this.reset();
            throw new RuntimeException("execQuery(exec): " + e.toString());
        }
        String[] strHeader = null;
        boolean[] blnRightAlign = null;
        int[] intType = null;
        ResultSetMetaData rsmd = null;
        try {
            rsmd = this.res.getMetaData();
            this.strLastRow = new String[rsmd.getColumnCount()];
            strHeader = new String[rsmd.getColumnCount()];
            blnRightAlign = new boolean[rsmd.getColumnCount()];
            intType = new int[rsmd.getColumnCount()];
            rsmd = this.res.getMetaData();
            int i2 = 0;
            while (i2 < rsmd.getColumnCount()) {
                strHeader[i2] = rsmd.getColumnLabel(i2 + 1);
                if (strHeader[i2] == null || strHeader[i2].length() == 0) {
                    strHeader[i2] = rsmd.getColumnName(i2 + 1);
                }
                intType[i2] = rsmd.getColumnType(i2 + 1);
                switch (intType[i2]) {
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: {
                        blnRightAlign[i2] = true;
                    }
                }
                ++i2;
            }
        }
        catch (SQLException e) {
            this.reset();
            throw new RuntimeException("execQuery(metadata): " + e.toString());
        }
        StringBuffer strb = new StringBuffer();
        strb.append("<table border=\"1\" cellpadding=\"4\" cellspacing=\"0\" width=\"100%\">\n");
        try {
            strb.append("<tr>");
            i = 0;
            while (i < rsmd.getColumnCount()) {
                strb.append("<td nowrap=\"nowrap\" valign=\"middle\" ");
                if (blnRightAlign[i]) {
                    strb.append("align=\"right\"");
                } else {
                    strb.append("align=\"left\"");
                }
                strb.append(">");
                strb.append("<b>" + strHeader[i] + "</b>");
                strb.append("</td>");
                ++i;
            }
            strb.append(" </tr>\n");
        }
        catch (SQLException e) {
            this.reset();
            throw new RuntimeException("execQuery(header): " + e.toString());
        }
        try {
            while (this.res.next()) {
                ++this.intRowCount;
                strb.append("<tr>");
                i = 0;
                while (i < rsmd.getColumnCount()) {
                    strb.append("<td nowrap=\"nowrap\" valign=\"middle\" ");
                    if (blnRightAlign[i]) {
                        strb.append("align=\"right\"");
                    } else {
                        strb.append("align=\"left\"");
                    }
                    strb.append(">");
                    String strValue = null;
                    switch (intType[i]) {
                        case 91: {
                            strValue = HelperDT.getDDMMYYYY(this.res.getDate(i + 1));
                            break;
                        }
                        case 92: {
                            strValue = HelperDT.getHHMMSS(this.res.getTime(i + 1));
                            break;
                        }
                        default: {
                            strValue = this.res.getString(i + 1);
                        }
                    }
                    this.strLastRow[i] = strValue;
                    String strLinkParam = (String)this.hshLinkTable.get(new Integer(i));
                    if (strLinkParam != null) {
                        strLinkParam = HelperFilter.replaceMore(strLinkParam, "?", strValue);
                        strb.append("<a href=\"?" + strLinkParam + "\">");
                    }
                    strb.append(strValue);
                    if (strLinkParam != null) {
                        strb.append("</a>");
                    }
                    strb.append("</td>");
                    ++i;
                }
                strb.append("</tr>\n");
            }
        }
        catch (SQLException e) {
            this.reset();
            throw new RuntimeException("execQuery(result): " + e.toString());
        }
        strb.append("</table>\n");
        return strb.toString();
    }

    public String[] getLastRow() {
        return this.strLastRow;
    }

    public int getRowCount() {
        return this.intRowCount;
    }

    public static void main(String[] args) throws SQLException {
        SQLconnection.setDB_User("benutzer");
        SQLconnection.setDB_Pass("kennwort");
        SQLconnection.setDB_Database("webshop");
        Connection con = null;
        try {
            con = SQLconnection.getConnection();
        }
        catch (SQLException e) {
            System.out.println(e);
            HelperIO.close(con);
            return;
        }
        HtmlSQLQueryModule hm = new HtmlSQLQueryModule(con);
        hm.addQueryLine("select pk_customer as Kunde,inv_name_1 as Name,dec(sum(total_brutto),9,2) as Brutto");
        hm.addQueryLine(" from customer_orders_hd");
        hm.addQueryLine(" group by pk_customer,inv_name_1");
        hm.addQueryLine(" order by Brutto desc");
        String res = hm.execQuery();
        System.out.println(res);
        HelperIO.close(con);
    }

    private String prepareQuery(String string) {
        String strQ;
        if (this.intQueryParams != 0 && this.objQueryParams == null) {
            throw new RuntimeException("prepareQuery: no query parameter was set");
        }
        if (this.intQueryParams != this.objQueryParams.length) {
            throw new RuntimeException("prepareQuery: queryparameter set and requested differ");
        }
        boolean blnValid = true;
        int i = 0;
        while (i < this.intQueryParams) {
            if (this.objQueryParams[i] == null) {
                blnValid = false;
            }
            ++i;
        }
        if (!blnValid) {
            throw new RuntimeException("prepareQuery: query parameters not set");
        }
        int idx = 0;
        int pp = -1;
        while (idx < this.intQueryParams && (pp = strQ.indexOf("?")) != -1) {
            strQ = String.valueOf(string.substring(0, pp)) + this.objQueryParams[idx++].toString() + string.substring(pp + 1);
        }
        return strQ;
    }

    public void reset() {
        this.strQuery = null;
        this.intQueryParams = 0;
        this.objQueryParams = null;
        this.intRowCount = 0;
        this.strLastRow = null;
        this.hshLinkTable = new Hashtable();
        if (this.res != null) {
            HelperIO.close(this.res);
            this.res = null;
        }
        if (this.stmt != null) {
            HelperIO.close(this.stmt);
            this.stmt = null;
        }
    }

    private void sanity_check(int idx) {
        if (this.objQueryParams == null) {
            this.objQueryParams = new Object[this.intQueryParams];
        }
        if (idx < 1 || idx > this.intQueryParams) {
            throw new RuntimeException("setQueryParam: " + idx + " is out of range");
        }
    }

    public void setLinkColumn(int intColumn, String strParam) {
        this.hshLinkTable.put(new Integer(intColumn - 1), strParam);
    }

    public void setQueryParam(int idx, double val) {
        this.sanity_check(idx);
        this.objQueryParams[idx - 1] = new Double(val);
    }

    public void setQueryParam(int idx, float val) {
        this.sanity_check(idx);
        this.objQueryParams[idx - 1] = new Float(val);
    }

    public void setQueryParam(int idx, int val) {
        this.sanity_check(idx);
        this.objQueryParams[idx - 1] = new Integer(val);
    }

    public void setQueryParam(int idx, long val) {
        this.sanity_check(idx);
        this.objQueryParams[idx - 1] = new Long(val);
    }

    public void setQueryParam(int idx, String val) {
        this.sanity_check(idx);
        this.objQueryParams[idx - 1] = val;
    }

    public void setQueryParam(int idx, Date val) {
        this.sanity_check(idx);
        this.objQueryParams[idx - 1] = val;
    }

    public void setQueryParam(int idx, Time val) {
        this.sanity_check(idx);
        this.objQueryParams[idx - 1] = val;
    }
}

