/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.sort;

import de.zwanzigeins.sort.Comparator;
import de.zwanzigeins.sort.ComparatorString;
import de.zwanzigeins.util.HelperFormat;
import java.util.Vector;

public class HelperSort {
    private HelperSort() {
    }

    public static final void bubble(Vector v, Comparator cmp) {
        boolean blnHasError = false;
        do {
            blnHasError = false;
            int i = 0;
            while (i < v.size() - 1) {
                if (cmp.compare(v.elementAt(i), v.elementAt(i + 1)) > 0) {
                    HelperSort.swap(v, i, i + 1);
                    blnHasError = true;
                }
                ++i;
            }
        } while (blnHasError);
    }

    public static final void bubble(Object[] o, Comparator cmp) {
        boolean blnHasError = false;
        do {
            blnHasError = false;
            int i = 0;
            while (i < o.length - 1) {
                if (cmp.compare(o[i], o[i + 1]) < 0) {
                    HelperSort.swap(o, i, i + 1);
                    blnHasError = true;
                }
                ++i;
            }
        } while (blnHasError);
    }

    public static final boolean isSorted(Vector v, Comparator cmp) {
        int i = 1;
        while (i < v.size()) {
            if (cmp.compare(v.elementAt(i), v.elementAt(i - 1)) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean isSorted(Object[] o, Comparator cmp) {
        int i = 1;
        while (i < o.length) {
            if (cmp.compare(o[i], o[i - 1]) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void main(String[] args) {
        Vector<String> v = new Vector<String>(5000);
        int i = 0;
        while (i < 1000) {
            String s = String.valueOf((int)(Math.random() * 50000.0));
            v.addElement(HelperFormat.rset(s, 5, ' '));
            ++i;
        }
        ComparatorString cmp = new ComparatorString();
        Vector v2 = (Vector)v.clone();
        long l = System.currentTimeMillis();
        HelperSort.quick(v2, (Comparator)cmp);
        System.out.println("Quick: " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        HelperSort.quick(v2, (Comparator)cmp);
        System.out.println("Quick sorted: " + (System.currentTimeMillis() - l));
        v2 = (Vector)v.clone();
        l = System.currentTimeMillis();
        HelperSort.shell(v2, (Comparator)cmp);
        System.out.println("Shell: " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        HelperSort.shell(v2, (Comparator)cmp);
        System.out.println("Shell sorted: " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        HelperSort.bubble(v2, (Comparator)cmp);
        System.out.println("Bubble: " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        HelperSort.bubble(v2, (Comparator)cmp);
        System.out.println("Bubble sorted: " + (System.currentTimeMillis() - l));
    }

    /*
     * Unable to fully structure code
     */
    private static final void qsort0(Vector v, Comparator cmp, int intLwb, int intUpb) {
        block5: {
            intLeft = intLwb;
            intRight = intUpb;
            if (intUpb <= intLwb) break block5;
            obj = v.elementAt((intLwb + intUpb) / 2);
            ** GOTO lbl16
            {
                ++intLeft;
                do {
                    if (intLeft < intUpb && cmp.compare(v.elementAt(intLeft), obj) < 0) continue block0;
                    while (intRight > intLwb && cmp.compare(v.elementAt(intRight), obj) > 0) {
                        --intRight;
                    }
                    if (intLeft > intRight) continue;
                    HelperSort.swap(v, intLeft, intRight);
                    ++intLeft;
                    --intRight;
lbl16:
                    // 3 sources

                } while (intLeft <= intRight);
            }
            if (intLwb < intRight) {
                HelperSort.qsort0(v, cmp, intLwb, intRight);
            }
            if (intLeft < intUpb) {
                HelperSort.qsort0(v, cmp, intLeft, intUpb);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final void qsort0(Object[] o, Comparator cmp, int intLwb, int intUpb) {
        block5: {
            intLeft = intLwb;
            intRight = intUpb;
            if (intUpb <= intLwb) break block5;
            obj = o[(intLwb + intUpb) / 2];
            ** GOTO lbl16
            {
                ++intLeft;
                do {
                    if (intLeft < intUpb && cmp.compare(o[intLeft], obj) < 0) continue block0;
                    while (intRight > intLwb && cmp.compare(o[intRight], obj) > 0) {
                        --intRight;
                    }
                    if (intLeft > intRight) continue;
                    HelperSort.swap(o, intLeft, intRight);
                    ++intLeft;
                    --intRight;
lbl16:
                    // 3 sources

                } while (intLeft <= intRight);
            }
            if (intLwb < intRight) {
                HelperSort.qsort0(o, cmp, intLwb, intRight);
            }
            if (intLeft < intUpb) {
                HelperSort.qsort0(o, cmp, intLeft, intUpb);
            }
        }
    }

    public static final void quick(Vector v, Comparator cmp) {
        HelperSort.qsort0(v, cmp, 0, v.size() - 1);
    }

    public static final void quick(Object[] o, Comparator cmp) {
        HelperSort.qsort0(o, cmp, 0, o.length - 1);
    }

    public static final void shell(Vector v, Comparator cmp) {
        int h = 1;
        while (h < v.size()) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            int i = h = (h - 1) / 3;
            while (i < v.size()) {
                Object obj = v.elementAt(i);
                int j = 0;
                j = i - h;
                while (j >= 0 && cmp.compare(obj, v.elementAt(j)) < 0) {
                    v.setElementAt(v.elementAt(j), j + h);
                    j -= h;
                }
                v.setElementAt(obj, j + h);
                ++i;
            }
        }
    }

    public static final void shell(Object[] o, Comparator cmp) {
        int h = 1;
        while (h < o.length) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            int i = h = (h - 1) / 3;
            while (i < o.length) {
                Object obj = o[i];
                int j = 0;
                j = i - h;
                while (j >= 0 && cmp.compare(obj, o[j]) < 0) {
                    o[j + h] = o[j];
                    j -= h;
                }
                o[j + h] = obj;
                ++i;
            }
        }
    }

    public static final void swap(Vector v, int i1, int i2) {
        Object objTmp = v.elementAt(i1);
        v.setElementAt(v.elementAt(i2), i1);
        v.setElementAt(objTmp, i2);
    }

    public static final void swap(Object[] o, int i1, int i2) {
        Object objTmp = o[i1];
        o[i1] = o[i2];
        o[i2] = objTmp;
    }
}

