/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.randomaccessdb;

import de.zwanzigeins.randomaccessdb.DatabaseDefinition;
import de.zwanzigeins.randomaccessdb.Field;
import de.zwanzigeins.randomaccessdb.FieldTypes;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;

public abstract class DatabaseRecord
implements FieldTypes {
    protected DatabaseDefinition ddf = null;
    protected byte[] buffer = null;

    public DatabaseRecord(DatabaseDefinition ddf) {
        this.ddf = ddf;
    }

    public void clear() {
        int i = 0;
        while (i < this.buffer.length) {
            this.buffer[i] = 0;
            ++i;
        }
    }

    protected InputStream getBlob(Field fld) throws FileNotFoundException {
        String strBlobName = this.getString(fld);
        File fl = this.ddf.getBlobFile(strBlobName);
        if (fl == null) {
            return null;
        }
        return new FileInputStream(fl);
    }

    protected String getBlobFileName(Field fld) throws FileNotFoundException {
        String strUID = this.getString(fld);
        return this.ddf.getBlobFileName(strUID);
    }

    protected long getBlobLength(Field fld) throws FileNotFoundException {
        String strBlobName = this.getString(fld);
        File fl = this.ddf.getBlobFile(strBlobName);
        if (fl == null) {
            return 0L;
        }
        return fl.length();
    }

    protected byte getByte(Field fld) {
        return this.buffer[fld.intPosStart];
    }

    protected char getChar(Field fld) {
        int i = fld.intPosStart;
        char res = '\u0000';
        res = (char)(res + ((this.buffer[i++] & 0xFF) << 8));
        res = (char)(res + ((this.buffer[i++] & 0xFF) << 0));
        return res;
    }

    protected Date getDate(Field fld) {
        return new Date(this.getLong(fld));
    }

    protected double getDouble(Field fld) {
        return Double.longBitsToDouble(this.getLong(fld));
    }

    protected float getFloat(Field fld) {
        return Float.intBitsToFloat(this.getInt(fld));
    }

    protected int getInt(Field fld) {
        int i = fld.intPosStart;
        int res = 0;
        res += (this.buffer[i++] & 0xFF) << 24;
        res += (this.buffer[i++] & 0xFF) << 16;
        res += (this.buffer[i++] & 0xFF) << 8;
        return res += (this.buffer[i++] & 0xFF) << 0;
    }

    protected long getLong(Field fld) {
        int i = fld.intPosStart;
        long res = 0L;
        res += (long)(this.buffer[i++] & 0xFF) << 56;
        res += (long)(this.buffer[i++] & 0xFF) << 48;
        res += (long)(this.buffer[i++] & 0xFF) << 40;
        res += (long)(this.buffer[i++] & 0xFF) << 32;
        res += (long)(this.buffer[i++] & 0xFF) << 24;
        res += (long)(this.buffer[i++] & 0xFF) << 16;
        res += (long)(this.buffer[i++] & 0xFF) << 8;
        return res += (long)(this.buffer[i++] & 0xFF) << 0;
    }

    protected String getString(Field fld) {
        int intL = fld.intLength;
        int i = 0;
        while (i < intL) {
            if (this.buffer[i + fld.intPosStart] == 0) {
                intL = i;
                break;
            }
            ++i;
        }
        try {
            return new String(this.buffer, fld.intPosStart, intL, this.ddf.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            return e.toString();
        }
    }

    public String lset(String s, int length) {
        int copyLen = s.length();
        if (copyLen > length) {
            copyLen = length;
        }
        byte[] buffer = new byte[length];
        int i = 0;
        while (i < copyLen) {
            buffer[i] = (byte)s.charAt(i);
            ++i;
        }
        i = copyLen++;
        while (i < length) {
            buffer[i] = 32;
            ++i;
        }
        return new String(buffer);
    }

    public String rset(String s, int length) {
        int copyLen = s.length();
        if (copyLen > length) {
            copyLen = length;
        }
        byte[] buffer = new byte[length];
        int i = 0;
        while (i < length - copyLen) {
            buffer[i] = 32;
            ++i;
        }
        i = 0;
        while (i < copyLen) {
            buffer[i + length - copyLen] = (byte)s.charAt(i);
            ++i;
        }
        return new String(buffer);
    }

    protected void sanitycheck(Field fld, byte bytType) {
        if (this.buffer == null) {
            throw new RuntimeException("Buffer not allocated!");
        }
        if (fld == null) {
            return;
        }
        if (fld.intPosEnd + 1 > this.buffer.length) {
            throw new RuntimeException("Field access beyond buffer");
        }
        if (fld.bytType != bytType) {
            throw new RuntimeException("Type mismatch on requested field " + fld.strName);
        }
    }

    protected void setBlob(Field fld, InputStream val) throws IOException {
        String strUID = this.getString(fld);
        if (strUID.length() > 0) {
            this.ddf.getBlobFile(strUID).delete();
        }
        strUID = this.ddf.getBlobUID();
        this.setString(fld, strUID);
        File flBlob = this.ddf.getBlobFile(strUID);
        flBlob.delete();
        int i = 0;
        byte[] copybuf = new byte[8192];
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(flBlob);
                while ((i = val.read(copybuf)) != -1) {
                    fos.write(copybuf, 0, i);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("setBlob: " + e.toString());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                fos.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Object var8_11 = null;
        try {
            fos.close();
        }
        catch (IOException iOException) {}
    }

    protected void setByte(Field fld, byte val) {
        this.buffer[fld.intPosStart] = val;
    }

    protected void setChar(Field fld, char val) {
        int i = fld.intPosStart;
        this.buffer[i++] = (byte)(val >>> 8 & 0xFF);
        this.buffer[i++] = (byte)(val >>> 0 & 0xFF);
    }

    protected void setDate(Field fld, Date val) {
        this.setLong(fld, val.getTime());
    }

    protected void setDouble(Field fld, double val) {
        this.setLong(fld, Double.doubleToLongBits(val));
    }

    protected void setFloat(Field fld, float val) {
        this.setInt(fld, Float.floatToIntBits(val));
    }

    protected void setInt(Field fld, int val) {
        int i = fld.intPosStart;
        this.buffer[i++] = (byte)(val >>> 24 & 0xFF);
        this.buffer[i++] = (byte)(val >>> 16 & 0xFF);
        this.buffer[i++] = (byte)(val >>> 8 & 0xFF);
        this.buffer[i++] = (byte)(val >>> 0 & 0xFF);
    }

    protected void setLong(Field fld, long val) {
        int i = fld.intPosStart;
        this.buffer[i++] = (byte)(val >>> 56 & 0xFFL);
        this.buffer[i++] = (byte)(val >>> 48 & 0xFFL);
        this.buffer[i++] = (byte)(val >>> 40 & 0xFFL);
        this.buffer[i++] = (byte)(val >>> 32 & 0xFFL);
        this.buffer[i++] = (byte)(val >>> 24 & 0xFFL);
        this.buffer[i++] = (byte)(val >>> 16 & 0xFFL);
        this.buffer[i++] = (byte)(val >>> 8 & 0xFFL);
        this.buffer[i++] = (byte)(val >>> 0 & 0xFFL);
    }

    protected void setString(Field fld, String val) {
        int intStrLen = val.length();
        if (intStrLen > fld.intLength) {
            intStrLen = fld.intLength;
        }
        byte[] b = null;
        try {
            b = val.getBytes(this.ddf.getCharset());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unsupported charset: " + this.ddf.getCharset());
        }
        int i = 0;
        while (i < intStrLen) {
            this.buffer[i + fld.intPosStart] = b[i];
            ++i;
        }
        if (intStrLen < fld.intLength) {
            this.buffer[fld.intPosStart + intStrLen] = 0;
        }
    }

    public String sortString() {
        StringBuffer strb = new StringBuffer();
        Enumeration e = this.ddf.fieldEnumerator();
        while (e.hasMoreElements()) {
            Field fld = (Field)e.nextElement();
            if (!fld.blnKeyField) continue;
            switch (fld.bytType) {
                case 1: {
                    strb.append(this.getString(fld));
                    break;
                }
                case 2: {
                    strb.append(this.lset(this.getString(fld), fld.intLength));
                    break;
                }
                case 3: {
                    strb.append(this.rset(Long.toString(this.getLong(fld)), 16));
                    break;
                }
                case 4: {
                    strb.append(this.rset(Integer.toString(this.getInt(fld)), 8));
                    break;
                }
                case 5: {
                    strb.append(this.rset(String.valueOf(this.getChar(fld)), 2));
                    break;
                }
                case 6: {
                    strb.append(this.rset(Byte.toString(this.getByte(fld)), 3));
                    break;
                }
                case 7: {
                    strb.append(this.rset(Long.toString(this.getLong(fld)), 16));
                    break;
                }
                case 8: {
                    strb.append(this.rset(Long.toString(this.getLong(fld)), 16));
                    break;
                }
                case 9: {
                    strb.append(this.rset(Integer.toString(this.getInt(fld)), 8));
                }
            }
            strb.append("#");
        }
        return strb.toString();
    }

    public String toString() {
        StringBuffer strb = new StringBuffer();
        Enumeration e = this.ddf.fieldEnumerator();
        while (e.hasMoreElements()) {
            Field fld = (Field)e.nextElement();
            strb.append(fld.strName);
            strb.append("=");
            switch (fld.bytType) {
                case 1: {
                    strb.append(this.getString(fld));
                    break;
                }
                case 2: {
                    strb.append(this.getString(fld));
                    break;
                }
                case 3: {
                    strb.append(this.getLong(fld));
                    break;
                }
                case 4: {
                    strb.append(this.getInt(fld));
                    break;
                }
                case 5: {
                    strb.append(this.getChar(fld));
                    break;
                }
                case 6: {
                    strb.append(this.getByte(fld));
                    break;
                }
                case 7: {
                    strb.append(this.getDate(fld));
                    break;
                }
                case 8: {
                    strb.append(this.getDouble(fld));
                    break;
                }
                case 9: {
                    strb.append(this.getFloat(fld));
                }
            }
            strb.append(",");
        }
        if (strb.length() > 0) {
            strb.setLength(strb.length() - 1);
        }
        return strb.toString();
    }
}

