/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.menue;

import de.zwanzigeins.menue.TreeMenuItem;
import de.zwanzigeins.util.HelperExtract;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class TreeMenu {
    public static final String ACCESS_PLACEHOLDER = "ALLOW_ACCESS";
    private static final int MAX_DEPTH = 10;
    private Vector vecItems = null;
    private int intCurrentDepth = -1;
    private int[] intParentStack = null;
    private int[] intSubmenuCounter = null;
    private int intLastClicked = 0;
    private int intAccessLevel = 0;

    public TreeMenu() {
        this.init();
    }

    public void addMenuItem(String strDisplay, int intLevelMin, int intLevelMax, Object objAction, String strIconFile) {
        int i;
        if (strDisplay.trim().startsWith(";")) {
            return;
        }
        if (this.intAccessLevel < intLevelMin || this.intAccessLevel > intLevelMax) {
            return;
        }
        TreeMenuItem mi = new TreeMenuItem();
        while (mi.intIndentation < strDisplay.length() && strDisplay.charAt(mi.intIndentation) == ' ') {
            ++mi.intIndentation;
        }
        mi.strDisplay = strDisplay.trim();
        mi.objAction = objAction;
        mi.strIconFile = strIconFile;
        mi.isVisible = mi.intIndentation == 0;
        mi.intIdx = this.vecItems.size();
        mi.intAccessLevelMin = intLevelMin;
        mi.intAccessLevelMax = intLevelMax;
        boolean blnPlaceHolder = mi.strDisplay.equals(ACCESS_PLACEHOLDER);
        if (blnPlaceHolder) {
            mi.isVisible = false;
            mi.intIndentation = 10;
        }
        if (mi.intIndentation > this.intCurrentDepth && !blnPlaceHolder) {
            this.intParentStack[mi.intIndentation] = this.vecItems.size() - 1;
            this.getMenuItem((int)(this.vecItems.size() - 1)).isBranchNode = true;
        }
        mi.intParent = this.intParentStack[mi.intIndentation];
        if (mi.intIndentation < this.intCurrentDepth && this.intCurrentDepth > 0) {
            i = mi.intIndentation + 1;
            while (i < this.intCurrentDepth) {
                this.intSubmenuCounter[i] = 0;
                ++i;
            }
        }
        int n = mi.intIndentation;
        this.intSubmenuCounter[n] = this.intSubmenuCounter[n] + 1;
        mi.strNumeration = "";
        i = 0;
        while (i < mi.intIndentation + 1) {
            if (this.intSubmenuCounter[i] != 0) {
                mi.strNumeration = String.valueOf(mi.strNumeration) + this.intSubmenuCounter[i] + ".";
            }
            ++i;
        }
        mi.strNumeration = mi.strNumeration.substring(0, mi.strNumeration.length() - 1);
        if (this.vecItems.size() > 0) {
            this.getMenuItem((int)(this.vecItems.size() - 1)).isLast = mi.intIndentation != this.intCurrentDepth;
        }
        mi.isLast = true;
        this.intCurrentDepth = mi.intIndentation;
        this.vecItems.addElement(mi);
    }

    private void click(int idx, int intDirection) {
        this.intLastClicked = idx;
        TreeMenuItem mi = this.getMenuItem(idx);
        if (!mi.isBranchNode) {
            return;
        }
        switch (intDirection) {
            case -1: {
                mi.isOpen = false;
                break;
            }
            case 0: {
                mi.isOpen = !mi.isOpen;
                break;
            }
            case 1: {
                mi.isOpen = true;
            }
        }
        boolean blnOpen = mi.isOpen;
        int cfr_ignored_0 = mi.intParent;
        int intIndent = mi.intIndentation;
        if (blnOpen) {
            int i = idx + 1;
            while (i < this.vecItems.size()) {
                mi = this.getMenuItem(i);
                if (this.intAccessLevel >= mi.intAccessLevelMin && this.intAccessLevel <= mi.intAccessLevelMax && !mi.strDisplay.equals(ACCESS_PLACEHOLDER)) {
                    if (mi.intIndentation == intIndent + 1) {
                        mi.isVisible = true;
                        boolean bl = mi.isOpen = !mi.isBranchNode;
                    }
                    if (mi.intIndentation == intIndent) break;
                }
                ++i;
            }
        } else {
            int i = idx + 1;
            while (i < this.vecItems.size()) {
                mi = this.getMenuItem(i);
                if (mi.intIndentation > intIndent) {
                    mi.isVisible = false;
                    mi.isOpen = false;
                    ++i;
                    continue;
                }
                break;
            }
        }
    }

    public void clickClose(int idx) {
        this.click(idx, -1);
    }

    public void clickOpen(int idx) {
        this.click(idx, 1);
    }

    public void clickToggle(int idx) {
        this.click(idx, 0);
    }

    public void closeAll() {
        int i = 0;
        while (i < this.size()) {
            TreeMenuItem mi = this.getMenuItem(i);
            mi.isVisible = true;
            if (mi.intIndentation > 0) {
                mi.isVisible = false;
            }
            mi.isOpen = false;
            ++i;
        }
        this.intLastClicked = 0;
    }

    public void dump() {
        StringBuffer strb = new StringBuffer();
        strb.append("Items: " + this.vecItems.size() + "\n");
        int i = 0;
        while (i < this.vecItems.size()) {
            TreeMenuItem mi = (TreeMenuItem)this.vecItems.elementAt(i);
            strb.append(i + ": " + mi.toString());
            ++i;
        }
    }

    public int getAccessLevel() {
        return this.intAccessLevel;
    }

    public int getClickedMenuIndex() {
        return this.intLastClicked;
    }

    public String getClickedMenuName() {
        return this.getMenuItem((int)this.intLastClicked).strDisplay;
    }

    public String getClickedMenuNumber() {
        return this.getMenuItem((int)this.intLastClicked).strNumeration;
    }

    public String getClickedMenuPath() {
        String[] s = this.getClickedMenuPathList();
        StringBuffer strb = new StringBuffer();
        int i = 0;
        while (i < s.length) {
            strb.append(s[i]);
            if (i < s.length - 1) {
                strb.append(" / ");
            }
            ++i;
        }
        return strb.toString();
    }

    public String[] getClickedMenuPathList() {
        Vector<String> v = new Vector<String>();
        new StringBuffer();
        String strCurrentLevel = this.getMenuItem((int)this.intLastClicked).strNumeration;
        int num = 0;
        while (num < strCurrentLevel.length()) {
            int i = 0;
            while (i < this.size()) {
                TreeMenuItem mi = this.getMenuItem(i);
                if (mi.strNumeration.equals(strCurrentLevel.substring(0, num + 1))) {
                    v.addElement(mi.strDisplay);
                }
                ++i;
            }
            num += 2;
        }
        Object[] s = new String[v.size()];
        v.copyInto(s);
        return s;
    }

    public TreeMenuItem getMenuItem(int idx) {
        if (idx < 0 || idx >= this.vecItems.size()) {
            TreeMenuItem mi = new TreeMenuItem();
            mi.strNumeration = "0.0.0.0";
            mi.strDisplay = "illegal index '" + idx + "'";
            return mi;
        }
        return (TreeMenuItem)this.vecItems.elementAt(idx);
    }

    public String getMenuStatus() {
        StringBuffer strb = new StringBuffer();
        strb.append(this.intAccessLevel);
        strb.append("#");
        strb.append(this.intLastClicked);
        strb.append("#");
        int i = 0;
        while (i < this.size()) {
            TreeMenuItem mi = this.getMenuItem(i);
            strb.append(mi.isVisible ? "1" : "0");
            strb.append("#");
            strb.append(mi.isOpen ? "1" : "0");
            strb.append("#");
            ++i;
        }
        return strb.toString();
    }

    private void init() {
        this.reset();
    }

    public boolean load(File fl) {
        this.reset();
        if (!fl.exists()) {
            return false;
        }
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new FileReader(fl));
                String strBuffer = null;
                while ((strBuffer = br.readLine()) != null) {
                    if (strBuffer.trim().length() == 0 || strBuffer.startsWith("#") || strBuffer.startsWith(";")) continue;
                    StringTokenizer strt = new StringTokenizer(strBuffer, "%#$\t", true);
                    String strMenu = strt.nextToken();
                    int intLevelMin = 0;
                    int intLevelMax = 0;
                    String strLevel = "";
                    String strAction = null;
                    String strIcon = null;
                    String strTmp = null;
                    while (strt.hasMoreTokens()) {
                        strTmp = strt.nextToken();
                        if (strTmp.startsWith("%")) {
                            strLevel = strt.nextToken("%#$\t ");
                            if (strLevel.indexOf("-") != -1) {
                                intLevelMin = HelperExtract.getNumeric(HelperExtract.getLeft(strLevel, "-"), 0);
                                intLevelMax = HelperExtract.getNumeric(HelperExtract.getRight(strLevel, "-"), 999);
                            } else {
                                intLevelMin = HelperExtract.getNumeric(strLevel, 0);
                                intLevelMax = 999;
                            }
                        }
                        if (strTmp.startsWith("$")) {
                            strIcon = strt.nextToken("%#$\t ");
                        }
                        if (!strTmp.startsWith("#")) continue;
                        strAction = strt.nextToken("%#$\t ");
                    }
                    this.addMenuItem(strMenu, intLevelMin, intLevelMax, strAction, strIcon);
                }
            }
            catch (IOException iOException) {
                Object var3_13 = null;
                try {
                    br.close();
                }
                catch (Throwable throwable) {}
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var3_14 = null;
            try {
                br.close();
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        Object var3_15 = null;
        try {
            br.close();
        }
        catch (Throwable throwable) {}
        return true;
    }

    public static void main(String[] args) {
        TreeMenu menue = new TreeMenu();
        menue.addMenuItem("Startseite", 0, 0, null, null);
        menue.addMenuItem("Shop", 0, 0, null, null);
        menue.addMenuItem(" Datenupload", 0, 0, null, null);
        menue.addMenuItem(" Sperren", 0, 0, null, null);
        menue.addMenuItem(" Freigeben", 0, 0, null, null);
        menue.addMenuItem(" Bestellungen", 0, 0, null, null);
        menue.addMenuItem(" Auswertungen", 0, 0, null, null);
        menue.addMenuItem("  Hitlisten", 0, 0, null, null);
        menue.addMenuItem("   ..nach Umsatz", 0, 0, null, null);
        menue.addMenuItem("   ..nach Positionen", 0, 0, null, null);
        menue.addMenuItem("   ..nach Bestellungen", 0, 0, null, null);
        menue.addMenuItem("Administration", 0, 0, null, null);
        menue.addMenuItem(" Shopstatus", 0, 0, null, null);
        menue.addMenuItem("Abmelden", 0, 0, null, null);
        menue.closeAll();
        menue.clickOpen(1);
        menue.setMenuStatus(menue.getMenuStatus());
        menue.clickOpen(6);
        menue.setMenuStatus(menue.getMenuStatus());
        menue.dump();
    }

    public void openAll() {
        int i = 0;
        while (i < this.size()) {
            TreeMenuItem mi = this.getMenuItem(i);
            mi.isVisible = true;
            mi.isOpen = true;
            ++i;
        }
    }

    public void reset() {
        this.vecItems = new Vector();
        this.intCurrentDepth = 0;
        this.intParentStack = new int[11];
        this.intSubmenuCounter = new int[11];
        this.intLastClicked = 0;
    }

    public void setAccessLevel(int i) {
        this.intAccessLevel = i;
    }

    public void setClickedMenuIndex(int i) {
        this.intLastClicked = i;
    }

    public void setMenuStatus(String s) {
        this.closeAll();
        int intLastAccessLevel = 0;
        if (s == null || s.length() == 0) {
            return;
        }
        StringTokenizer strt = new StringTokenizer(s, "#");
        try {
            intLastAccessLevel = Integer.parseInt(strt.nextToken());
            this.intLastClicked = Integer.parseInt(strt.nextToken());
            int i = 0;
            while (i < this.size()) {
                TreeMenuItem mi = this.getMenuItem(i);
                mi.isVisible = strt.nextToken().equals("1");
                mi.isOpen = strt.nextToken().equals("1");
                ++i;
            }
        }
        catch (Throwable throwable) {
            this.closeAll();
        }
        if (intLastAccessLevel != this.intAccessLevel) {
            this.closeAll();
        }
    }

    public int size() {
        return this.vecItems.size();
    }

    public String toString() {
        StringBuffer strb = new StringBuffer();
        strb.append("Items: " + this.vecItems.size() + "\n");
        int i = 0;
        while (i < this.vecItems.size()) {
            TreeMenuItem mi = (TreeMenuItem)this.vecItems.elementAt(i);
            strb.append(i + ": " + mi.toString());
            ++i;
        }
        return strb.toString();
    }
}

