/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.calendar;

import java.util.TimeZone;

public class UDate {
    private Date datNow = null;
    private Time timNow = null;

    public UDate(long lngTime) {
        this.setTime(lngTime);
    }

    private long date2julian0(Date d) {
        int hv;
        int n;
        hv = d.intMonth > 2 ? (n = 0) : (hv = 1);
        int t1 = (int)Math.floor((double)(d.intMonth + hv * 12 + 1) * 30.6001);
        int t2 = (int)Math.floor((double)(d.intYear - hv) * 365.25 + (double)d.intDay);
        return t1 + t2;
    }

    public boolean isLeapYear() {
        return this.datNow.intYear % 4 == 0 && (this.datNow.intYear % 100 != 0 || this.datNow.intYear % 400 == 0);
    }

    private Date julian2date0(long lngJul) {
        Date d = new Date(this);
        d.intYear = (int)Math.floor(((double)lngJul - 122.1) / 365.25);
        double hv = (double)lngJul - Math.floor((double)d.intYear * 365.25);
        d.intMonth = (int)Math.floor(hv / 30.6001);
        d.intDay = (int)(hv - Math.floor((double)d.intMonth * 30.6001));
        --d.intMonth;
        if (d.intMonth > 12) {
            ++d.intYear;
            d.intMonth %= 12;
        }
        return d;
    }

    public static void main(String[] args) {
        new UDate(System.currentTimeMillis());
    }

    private Time ms2time(long lngTime) {
        long tmp = lngTime;
        Time t = new Time(this);
        t.intMilli = (int)(tmp % 1000L);
        t.intSecond = (int)((tmp /= 1000L) % 60L);
        t.intMinute = (int)((tmp /= 60L) % 60L);
        t.intHour = (int)((tmp /= 60L) % 24L);
        return t;
    }

    public void setTime(long lngTime) {
        long lngUnixDayOffset = this.date2julian0(new Date(this, 1970, 1, 1));
        this.datNow = this.julian2date0(lngTime / 86400000L + lngUnixDayOffset);
        this.timNow = this.ms2time(lngTime);
        System.out.println("GMT Date: " + this.datNow);
        System.out.println("GMT Time: " + this.timNow);
        System.out.println("Java    : " + new java.util.Date(lngTime).toString());
        System.out.println("Default Java TZ: " + TimeZone.getDefault());
        System.out.println(lngUnixDayOffset * 86400000L);
    }

    private long time2ms(Time tim) {
        long l = 0L;
        l += (long)tim.intHour * 60L * 60L * 1000L;
        l += (long)tim.intMinute * 60L * 1000L;
        l += (long)tim.intSecond * 1000L;
        return l += (long)tim.intMilli;
    }

    private int weekday0(Date d) {
        long l = this.date2julian0(d);
        l -= 2L;
        if ((l -= (long)((int)(l / 7L) * 7)) == 0L) {
            l = 7L;
        }
        return (int)l;
    }

    class Date {
        /* synthetic */ UDate this$0;
        int intDay;
        int intMonth;
        int intYear;

        Date(UDate this$0) {
            this.this$0 = this$0;
        }

        Date(UDate this$0, int y, int m, int d) {
            this.this$0 = this$0;
            this.intYear = y;
            this.intMonth = m;
            this.intDay = d;
        }

        public String toString() {
            return this.intDay + " " + this.intMonth + " " + this.intYear;
        }
    }

    class Time {
        /* synthetic */ UDate this$0;
        int intHour;
        int intMinute;
        int intSecond;
        int intMilli;

        Time(UDate this$0) {
            this.this$0 = this$0;
        }

        Time(UDate this$0, int h, int m, int s, int ms) {
            this.this$0 = this$0;
            this.intHour = h;
            this.intMinute = m;
            this.intSecond = s;
            this.intMilli = ms;
        }

        public String toString() {
            return this.intHour + ":" + this.intMinute + ":" + this.intSecond + "." + this.intMilli;
        }
    }
}

