/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.cache;

import de.zwanzigeins.cache.PrecomputedFileContentProducer;
import de.zwanzigeins.util.HelperIO;
import de.zwanzigeins.util.HelperPath;
import de.zwanzigeins.util.LogContext;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class PrecomputedFileContentCache {
    private MessageDigest mdCacheName = null;
    private LogContext log = null;
    private int intCopyBufferSize = 0;
    private boolean blnDebug = false;
    private final long CACHEFILE_INVALID_SIZE = -1L;
    private DataInputStream disContent = null;
    private long lngContentLength = -1L;

    public PrecomputedFileContentCache() {
        this(null, 8192, false);
    }

    public PrecomputedFileContentCache(LogContext log) {
        this(log, 8192, false);
    }

    public PrecomputedFileContentCache(LogContext log, int intCopyBufferSize, boolean blnDebug) {
        this.log = log;
        this.blnDebug = blnDebug;
        this.intCopyBufferSize = intCopyBufferSize;
        try {
            this.mdCacheName = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("No MessageDigest: SHA");
        }
    }

    public void close() {
        if (this.disContent != null) {
            HelperIO.close(this.disContent);
        }
        this.disContent = null;
        this.lngContentLength = 0L;
    }

    public File getCacheFile_URL(String strTempPath, String strURL) {
        String strCacheFile = String.valueOf(strTempPath) + File.separator + strURL;
        if ((strCacheFile = HelperPath.pathFixup(strCacheFile, File.separator)).endsWith(File.separator)) {
            strCacheFile = String.valueOf(strCacheFile) + "#root";
        }
        return new File(strCacheFile);
    }

    public InputStream getContent(File flLocal, File flCache, PrecomputedFileContentProducer pfcProducer) {
        block18: {
            if (this.blnDebug) {
                this.log("D Sending GZIP/DSK " + flLocal.getPath());
            }
            int intRetries = 10;
            while (true) {
                boolean blnValid;
                if (intRetries == 0) {
                    this.log("? Retries for building cache exhausted, abort");
                    return null;
                }
                long lngCacheFileSizeFromHeader = -1L;
                boolean bl = blnValid = flCache.exists() && flCache.length() > 32L;
                if (blnValid) {
                    RandomAccessFile rafCache = null;
                    try {
                        rafCache = new RandomAccessFile(flCache, "r");
                        lngCacheFileSizeFromHeader = rafCache.readLong();
                        blnValid &= rafCache.readLong() == flLocal.length();
                        blnValid &= rafCache.readLong() == flLocal.lastModified();
                    }
                    catch (IOException e) {
                        this.log("? Error reading cache header", e);
                        blnValid = false;
                    }
                    HelperIO.close(rafCache);
                    if (lngCacheFileSizeFromHeader == -1L || lngCacheFileSizeFromHeader != flCache.length()) {
                        this.wait_ms(150L);
                        if (!this.blnDebug) continue;
                        this.log("D PrecomputetFileContentCache under rebuild");
                        continue;
                    }
                }
                if (blnValid) break block18;
                if (!HelperIO.fileLock(flCache.getPath())) {
                    if (this.blnDebug) {
                        this.log("D Waiting for lock release on " + flCache.getPath());
                    }
                    this.wait_ms(150L);
                    --intRetries;
                    continue;
                }
                int pp = flCache.getPath().lastIndexOf(File.separator);
                if (pp == -1) {
                    this.log("? No slash in cachefilepath: " + flCache.getPath());
                    return null;
                }
                String strCachePath = flCache.getPath().substring(0, pp);
                strCachePath = HelperPath.removeTrailingSlashes(strCachePath);
                new File(strCachePath).mkdirs();
                DataOutputStream dos = null;
                RandomAccessFile rafCache = null;
                FileInputStream fisLocal = null;
                try {
                    if (this.blnDebug) {
                        this.log("D Building cache file " + flCache.getPath());
                    }
                    dos = new DataOutputStream(new FileOutputStream(flCache));
                    dos.writeLong(-1L);
                    dos.writeLong(-1L);
                    dos.writeLong(-1L);
                    fisLocal = new FileInputStream(flLocal);
                    long l = pfcProducer.produce(fisLocal, dos, new byte[this.intCopyBufferSize]);
                    HelperIO.close(fisLocal);
                    HelperIO.close(dos);
                    if (this.blnDebug) {
                        this.log("D Wrote " + l + " bytes to cachefile");
                    }
                    rafCache = new RandomAccessFile(flCache, "rw");
                    rafCache.writeLong(flCache.length());
                    rafCache.writeLong(flLocal.length());
                    rafCache.writeLong(flLocal.lastModified());
                    HelperIO.close(rafCache);
                    if (!this.blnDebug) break;
                    this.log("D Built cached file " + flCache.getPath());
                }
                catch (IOException e) {
                    HelperIO.close(fisLocal);
                    HelperIO.close(dos);
                    HelperIO.close(rafCache);
                    if (this.blnDebug) {
                        this.log("D Cannot create cache for " + flCache.getPath() + " " + e.toString());
                    }
                    flCache.delete();
                    HelperIO.fileUnlock(flCache.getPath());
                    this.wait_ms(150L);
                    --intRetries;
                    continue;
                }
                break;
            }
            HelperIO.fileUnlock(flCache.getPath());
        }
        try {
            if (this.blnDebug) {
                this.log("D Sending cached file " + flCache.getPath());
            }
            this.disContent = new DataInputStream(new FileInputStream(flCache));
            this.disContent.readLong();
            this.disContent.readLong();
            this.disContent.readLong();
            this.lngContentLength = flCache.length() - 24L;
            return this.disContent;
        }
        catch (IOException iOException) {
            HelperIO.close(this.disContent);
            return null;
        }
    }

    public long getContentLength() {
        return this.lngContentLength;
    }

    private void log(String s) {
        if (this.log == null) {
            return;
        }
        this.log.write(s);
    }

    private void log(String s, Throwable t) {
        if (this.log == null) {
            return;
        }
        this.log.write(s, t);
    }

    private void wait_ms(long l) {
        try {
            PrecomputedFileContentCache precomputedFileContentCache = this;
            synchronized (precomputedFileContentCache) {
                this.wait(l);
            }
        }
        catch (InterruptedException interruptedException) {}
    }
}

