/****
 LISTOBJS.CMD v1.0c  R.J.Holmgren  6/3/96
 Command "LISTOBJS ?" for Help
****/

if arg(1)='?'|arg(1)='-?'|arg(1)='/?'|translate(arg(1))='HELP' then do
  say
  say 'LISTOBJS.CMD v1.0c  --  List all Object Titles and IDs in WorkPlace Shell'
  say '			R.J.Holmgren  6/3/96'
  say
  say 'Usage:'
  say '-----'
  say 'listobjs		  - list all Titles + ObjectIDs + Handles'
  say 'listobjs Title_mask	  - case INsensitive search for Titles matching'
  say '			    substring, e.g. "listobjs window"'
  say 'listobjs IDx		  - case sEnSiTiVe search for ObjectIDs matching'
  say '			    substring x, e.g. "listobjs IDREX"'
  say '				N.B.:   Do NOT use "<>" chars in sub$ x'
  say '					The "ID" prefix must be UPPERCASE'
  say 'listobjs /np		  - scroll output (No Paging)'
  say 'listobjs /np > filename	  - redirect output to a file'
  say 'listobjs ?|/?|-?|help	  - this screen'
  exit
  end

args=0 /* Default list */
allhandles0=''
allhandles1=''
allhandles2=''
command=''
np=0
if arg(1)\='' then do
  args=2 /* Get $ in titles */
  command=strip(arg(1))
  if pos('ID',command)=1 then do
    args=1 /* Get $ in ObjectIDs */
    command=substr(command,3)
    end
  if pos('/NP',translate(command))>0 then do
    if translate(command)="/NP" then args=0
    np=1
    end
  if command='' then args=0
  if args=2 then command=translate(command)
  end

say " LISTOBJS.CMD v1.0c - List OS/2 Object Titles and IDs - R.J.Holmgren"
say ' Command "LISTOBJS ?" for Help         'date(L)||' at '||time(N)
say
call charout ," Getting Processes and Titles from OS2.INI (takes awhile) . . . "

if RxFuncQuery("SysLoadFuncs") then do
  call RxFuncAdd "SysLoadFuncs", "REXXUTIL","SysLoadFuncs"
  call SysLoadFuncs
  end

call SysIni 'USER', 'PM_Workplace:Location', 'ALL:', 'objid.'

objects.='undefined object'
do i=1 to objid.0
  handle=SysIni('USER', 'PM_Workplace:Location', objid.i)
  handle=C2X(Reverse(Left(handle,2)))
  handle=strip(handle,'L','0')
  id=objid.i
  objects.id=handle
  objects.handle=id
  end

x=0
ProcTitle.1=''

do i=1 to objid.0 
  id=objid.i
  handle=objects.id

  stuff=SysIni('USER','PM_Abstract:FldrContent',handle)
  do while stuff\=''
    parse var stuff handle 3 5 stuff
    handle=C2X(Reverse(left(handle,2)))
    handle=strip(handle,'L','0')
    val=SysIni('USER','PM_Abstract:Objects',handle)
    if val='ERROR:' then do 
      call addit
      iterate
      end
    val=translate(val,'^','0A'x) /* remove carriage returns */
    val=translate(val,' ','!@><#$%^&*_+-=?')
/*     val=translate(val,'','  ') */
    val=translate(val,Copies('00'x,256),XRange('7F'x,'1F'x)) /* unprintable chars become '00'x */
    val=translate(translate(val,'FF'x,' '),' ','00'x)
    if objects.handle\='' THEN
      objID=objects.handle
    else
      objID=handle
    parse var val 'WPAbstract' objTitle 'WPObject'
    objTitle=strip(translate(objTitle,' ','FF'x))
    objTitle=strip(left(objTitle,Length(objTitle)-1))
    objTitle1=left(objTitle,32)
    call doit
    end
  end

call DumpDupes

say
call charout ," Sorting "||x||" Objects . . . "

y=1
do while x>1
  SortedProc.y=ProcTitle.1
  z=1
  do i=2 to x
    if ProcTitle.i<SortedProc.y then do
      SortedProc.y=ProcTitle.i
      z=i
      end
    end
  ProcTitle.z=ProcTitle.x
  x=x-1
  y=y+1
  end
SortedProc.y=ProcTitle.x

if np=0 then call SysCls
say
say "Process Title			 <ObjectID> and Handle"
say "-------------			 ---------------------"
if y=0 then do
  y=1
  SortedProc.1='None found'
  end
do i=1 to y
  if args=0 then say SortedProc.i
  if args=1 then do
    z=''
    if pos('<',SortedProc.i)=34 then do
      z=right(SortedProc.i,length(SortedProc.i)-34)
      if pos('>',z)>0 then do
        z=left(z,pos('>',z)-1)
        if pos(command,z)>0 then say SortedProc.i
        end
      end
    end
  if args=2 then do
    z=left(translate(SortedProc.i),32)
    if pos(command,z)>0 then say SortedProc.i
    end
  parse value SysCurPos() with row col
  if row=24 then call HitKey
  end

call HitKey
exit

DOIT:
x=x+1
ProcTitle.x=objTitle1' 'objID'	'handle
allhandles0=allhandles0||"+"||handle
call addit
RETURN

ADDIT:
allhandles2=allhandles0||allhandles1
if pos(objects.id,allhandles2)<1 then do
  x=x+1
  ProcTitle.x='Folder:                          'id'	'objects.id
  allhandles1=allhandles1||"+"||objects.id
  end
RETURN

DUMPDUPES:
zap=''
tab=0
do i=1 to x
  if pos('Folder:  ',ProcTitle.i)=1 then do
    tab=pos('	',ProcTitle.i)
    zap=right(ProcTitle.i,length(ProcTitle.i)-tab)
    if pos(zap,AllHandles0)>0 then do
      if i<x then ProcTitle.i=ProcTitle.x
      x=x-1
      i=i-1
      end
    end
  if i=x then leave
  end
RETURN

HITKEY:
if np=0 then do
  call charout ,"		Hit key to continue . . . "
  call SysGetKey 'noecho'
  call SysCls
  end
RETURN

