<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" version="1.0" encoding="UTF-8"/>
	<xsl:template match="/preferences/root">
		<xiss-preferences>
			<xsl:apply-templates select="//node[@name = 'gui']" mode="GUI"/>
			<xsl:apply-templates select="//node[@name != 'gui' and map/entry]" mode="CONFIGURABLE"/>
		</xiss-preferences>
	</xsl:template>
	
	<xsl:template match="node" mode="CONFIGURABLE">
		<configurable>
		  <xsl:attribute name="id">
		     <xsl:apply-templates select="@name"/>
		  </xsl:attribute>
			<xsl:apply-templates select="map/entry"/>
		</configurable>
	</xsl:template>
	
	<xsl:template match="node" mode="GUI">
	   <configurable id="org.xissweb.gui.AboutDialog">
	   	<xsl:apply-templates select="map/entry[starts-with(@key, 'about')]"/>
	   </configurable>
	   <configurable id="org.xissweb.gui.Main">
	   	<xsl:apply-templates select="map/entry[starts-with(@key, 'remind')]"/>
	   </configurable>
	   <configurable id="org.xissweb.gui.XissEditorManager">
	   	<xsl:apply-templates select="map/entry[@key = 'current' or @key = 'documents']"/>
	   </configurable>
	   <configurable id="org.xissweb.gui.XissWeb">
	   	<xsl:apply-templates select="map/entry[starts-with(@key, 'location') or starts-with(@key, 'size') or starts-with(@key, 'slideshow') or @key = 'project']"/>
	   </configurable>
	</xsl:template>
	
	
	<xsl:template match="entry">
		<entry key="{@key}" value="{@value}"/>
	</xsl:template>
	
	
	<xsl:template match="@name">
	   <xsl:choose>
		   <xsl:when test=". = 'basic'">org.xissweb.gui.project.basic.NewProjectDialog</xsl:when>
		   <xsl:when test=". = 'build'">org.xissweb.gui.build.BuildLauncher</xsl:when>
		   <xsl:when test=". = 'content'">org.xissweb.gui.content.ContentEditor</xsl:when>
		   <xsl:when test=". = 'error'">org.xissweb.gui.editor.error.EditorErrorDialog</xsl:when>
		   <xsl:when test=". = 'file'">org.xissweb.gui.file.FileTreeManager</xsl:when>
		   <xsl:when test=". = 'font'">org.xissweb.gui.editor.font.CssFontChooser</xsl:when>
		   <xsl:when test=". = 'layout'">org.xissweb.gui.layout.LayoutEditor</xsl:when>
		   <xsl:when test=". = 'links'">org.xissweb.gui.content.links.ContentLinksDialog</xsl:when>
		   <xsl:when test=". = 'properties'">org.xissweb.gui.properties.PropertiesEditor</xsl:when>
		   <xsl:when test=". = 'repository'">org.xissweb.gui.project.repository.NewRepositoryProjectDialog</xsl:when>
		   <xsl:when test=". = 'simple'">org.xissweb.gui.skin.simple.SkinEditor</xsl:when>
		   <xsl:when test=". = 'skin'">org.xissweb.gui.skin.simple.SkinEditor</xsl:when>
		   <xsl:when test=". = 'sow'">org.xissweb.gui.sow.SowLauncher</xsl:when>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
