﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:import href="translation.xsl"/>
	<xsl:output method="html" encoding="UTF-8" indent="yes"/>
	<xsl:param name="lang">default</xsl:param>
	<xsl:param name="version">@version@</xsl:param>
	<xsl:param name="date">@today@</xsl:param>
	<xsl:template match="/">
		<body style="font-family: arial;">
			<h1 style="font-family: verdana; font-size: 120%; margin: 0 0 0 0;">Version <xsl:value-of select="$version"/></h1>
			<p><xsl:value-of select="$date"/></p>
			<xsl:apply-templates select="release/text[@lang = $lang]"/>
		</body>
	</xsl:template>
	
	<xsl:template match="text">
		<xsl:apply-templates select="*"/>
	</xsl:template>
	
	<xsl:template match="comment">
		<p>
			<xsl:apply-templates select="title"/>
			<xsl:value-of select="text()"/>
		</p>
	</xsl:template>

	<xsl:template match="title">
		<strong><xsl:value-of select="text()"/></strong>
	</xsl:template>
	
	<xsl:template match="enhance | add | bug-fix | update | change">
		<h2 style="font-family: verdana; font-size: 110%; ">
			<xsl:apply-templates select="." mode="TITLE"/>
		</h2>
		<ul>
			<xsl:apply-templates select="item"/>
		</ul>
	</xsl:template>
	
	<xsl:template match="item">
		<li><xsl:apply-templates select="title"/><xsl:value-of select="text()"/></li>
	</xsl:template>
	
</xsl:stylesheet>