﻿<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!--
       Renderer a VERTICAL thumbnail container :
          Builds lines of "range" images 
          the number of lines depends on the number of thumbnails containers.
          Computes the first image number to renderer, iterate from it until
          the number of images for this container isn't done.
   -->
	<xsl:template match="images" mode="VERTICAL_THUMBNAILS">
		<xsl:param name="containerNum"/>    <!-- total number of containers -->
		<xsl:param name="currentContainer"/><!-- number of the current thumbails container -->
		<xsl:param name="range"/>           <!-- range for this container : number of columns -->
		<xsl:param name="animation"/>
		<!-- -->
		<xsl:variable name="imagesNum" select="count(.//image)"/> <!-- total number of images -->
		<!-- if the number of container isn't a multiple of number of image then rest != 0
		      and some containers must have (image number div container number)+1. These container
		      are the first number of rest container. Ex : 20 images for 3 containers : 20 mod 3 = 2
		      then the two first containers have 7 images and the last one 6 images : (7*2)+6 = 20.
		 -->
		<xsl:variable name="rest" select="$imagesNum mod $containerNum"/>
		<xsl:variable name="imagesPerC" select="floor($imagesNum div $containerNum)"/> <!-- nb images per container -->
		<xsl:variable name="imagesCurrC">                                   <!-- nb images in the current container -->
			<xsl:choose>
				<xsl:when test="($rest != 0) and ($currentContainer &gt; $rest)">
					<xsl:value-of select="$imagesPerC + 1"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$imagesPerC"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- compute the first image number for the current thumbnails container -->
		<xsl:variable name="firstImageNumber">
			<xsl:choose>
				<xsl:when test="($rest != 0) and ($currentContainer &lt;= $rest)">
					<xsl:value-of select="1 + (($currentContainer - 1) * $imagesPerC)"/>
				</xsl:when>
				<xsl:when test="($rest != 0) and ($currentContainer &gt; $rest)">
					<xsl:value-of select="1 + ($rest * $imagesPerC) + ( ($currentContainer - $rest - 1) * $imagesCurrC)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="1 + (($currentContainer - 1) * $imagesPerC)"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="lastImageNumber" select="$firstImageNumber + $imagesCurrC -1"/>
		
		<!--xsl:message>V THUMBNAILS <xsl:value-of select="$currentContainer"/>: [<xsl:value-of select="$firstImageNumber"/>, <xsl:value-of select="$lastImageNumber"/>]</xsl:message-->
		
		<!-- Iteration over sections included in the current thubnails container -->
		<xsl:apply-templates select="section[count(image[number(@number) &gt;= $firstImageNumber and number(@number) &lt;= $lastImageNumber]) != 0]"  mode="VERTICAL_THUMBNAIL_RANGE">
			<xsl:with-param name="range" select="$range"/>
			<xsl:with-param name="firstImageNumber" select="$firstImageNumber"/>
			<xsl:with-param name="lastImageNumber" select="$lastImageNumber"/>
			<xsl:with-param name="rest" select="$rest"/>
			<xsl:with-param name="animation" select="$animation"/>
		</xsl:apply-templates>
		
		<!-- -->
		<!-- iteration to build each line of "range" thumbnails in the current thubnails container :
		     select each first image for each line
		<xsl:apply-templates select=".//image[number(@number) &gt;= $firstImageNumber and number(@number) &lt; ($firstImageNumber + $imagesCurrC) and (((number(@number) - 1) mod $range) = 0)]" mode="VERTICAL_THUMBNAIL_RANGE">
			<xsl:with-param name="range" select="$range"/>
			<xsl:with-param name="imagesCurrC" select="$imagesCurrC"/>
			<xsl:with-param name="firstImageNumber" select="$firstImageNumber"/>
			<xsl:with-param name="rest" select="$rest"/>
		</xsl:apply-templates>
		-->
	</xsl:template>
	<!--
	  -->
	<xsl:template match="section" mode="VERTICAL_THUMBNAIL_RANGE">
			<xsl:param name="range"/>
			<xsl:param name="imagesCurrC"/>
			<xsl:param name="firstImageNumber"/>
			<xsl:param name="lastImageNumber"/>
			<xsl:param name="rest"/>
			<xsl:param name="animation"/>
		<!--xsl:message>Section found = <xsl:value-of select="@title"/> image = <xsl:value-of select="image/@number"/>, <xsl:value-of select="$firstImageNumber"/></xsl:message-->
		<!--
		  image offset is the number of images in previous section displayed in the current thumbnails container modulo the range thumbnails in the container
		  the offset is to take into account the section display and corresponding number of images that doen't correspond to the mutiple of range, example:
		  Section 1
		   ____   ____
		  |  1 | | 2  |
		  |____| |____|
		   ____
		  |  3 |
		  |____| offset = 1
		  
		  Section 2
		   ____
		  |  4 |
		  |____| ...		  
		  -->
		<xsl:variable name="imageOffset" select="count(preceding-sibling::section[@title != '']/image) mod $range"/>

      <!--xsl:message>SECTION [<xsl:value-of select="image[1]/@number"/> - <xsl:value-of select="image[position() = last()]/@number"/>] <xsl:value-of select="$imageOffset"/></xsl:message-->
      <!--xsl:message>SECTION <xsl:value-of select="position()"/> offsets <xsl:value-of select="$imageOffset"/></xsl:message-->
	   
	   <xsl:apply-templates select="image[number(@number) &gt;= ($firstImageNumber - $imageOffset) and number(@number) &lt;= $lastImageNumber and (((number(@number) - 1  - $imageOffset) mod $range) = 0)]"  mode="VERTICAL_THUMBNAIL_RANGE">
			<xsl:with-param name="range" select="$range"/>
			<xsl:with-param name="firstImageNumber" select="$firstImageNumber"/>
			<xsl:with-param name="lastImageNumber" select="$lastImageNumber"/>
			<xsl:with-param name="rest" select="$rest"/>
			<xsl:with-param name="animation" select="$animation"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
		Renderer one range for a VERTICAL thumbnail container :
		   build one row with "range" images in the container
    -->
	<xsl:template match="image" mode="VERTICAL_THUMBNAIL_RANGE">
		<xsl:param name="range"/>
		<xsl:param name="firstImageNumber"/>
		<xsl:param name="lastImageNumber"/>
		<xsl:param name="rest"/>
		<xsl:param name="animation"/>
		<xsl:variable name="firstRangeNumber" select="number(@number)"/>
		<!--xsl:message> IMAGE <xsl:value-of select="@number"/></xsl:message-->
		<!--xsl:message>SECTION <xsl:value-of select="../@title"/> : <xsl:value-of select="@number"/></xsl:message-->
		
		<!-- if the first image of the current section is the current image and the section have a title, write the title -->
		<xsl:if test="(../image[1]/@number = current()/@number) and ../@title != ''">
		  <div class="section"><xsl:value-of select="../@title"/></div>
		</xsl:if>

		<!-- apply the template ONE_THUMBNAIL for "range" times : from "image number" to "image number + range" -->
		<div class="thumbnailsRow">
			<xsl:apply-templates select="." mode="ONE_THUMBNAIL">
				<xsl:with-param name="animation" select="$animation"/>
			</xsl:apply-templates>
			
			<xsl:apply-templates select="following-sibling::image[number(@number) &lt; ($firstRangeNumber+$range)]" mode="ONE_THUMBNAIL">
				<xsl:with-param name="animation" select="$animation"/>
			</xsl:apply-templates>
		</div>

	</xsl:template>
	<!--
		 Renderer HORIZONTAL thumbnails container :
		    Build a table with "range" rows
		    the number of columns depends on the number of images for this container.
	 -->
	<xsl:template match="images" mode="HORIZONTAL_THUMBNAILS">
		<xsl:param name="containerNum"/>      <!-- total numbers of containers -->
		<xsl:param name="currentContainer"/>  <!-- number of the current container -->
		<xsl:param name="range"/>             <!-- range of  the current container : number of rows -->
		<xsl:param name="width"/>
		<xsl:param name="animation"/>
		<!-- -->
		<xsl:variable name="imagesNum" select="count(.//image)"/> <!-- total number of images (and thumbnails) -->
		<!-- if the number of container isn't a multiple of number of image then rest != 0
		      and some containers must have (image number div container number)+1. These container
		      are the first number of rest container. Ex : 20 images for 3 containers : 20 mode 3 = 2
		      then the two first containers have 7 images and the last one 6 images : (7*2)+6 = 20.
		 -->
		<xsl:variable name="rest" select="$imagesNum mod $containerNum"/>
		<!--xsl:message>HORIZONTAL THUMBNAILS CONTAINER : total images <xsl:value-of select="$imagesNum"/>, rest <xsl:value-of select="$rest"/></xsl:message-->
		<xsl:variable name="imagesPerC" select="floor($imagesNum div $containerNum)"/> <!-- nb images per container -->
		<xsl:variable name="imagesCurrC">                                       <!-- nb images in the current container -->
			<xsl:choose>
				<xsl:when test="($rest != 0) and ($currentContainer &gt; $rest)">
					<xsl:value-of select="$imagesPerC +1"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$imagesPerC"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- compute the first image number for the current thumbnails container -->
		<xsl:variable name="firstImageNumber">
			<xsl:choose>
				<xsl:when test="($rest != 0) and ($currentContainer &lt;= $rest)">
					<xsl:value-of select="1 + (($currentContainer - 1) * $imagesPerC)"/>
				</xsl:when>
				<xsl:when test="($rest != 0) and ($currentContainer &gt; $rest)">
					<xsl:value-of select="1 + ($rest * $imagesPerC) + ( ($currentContainer - $rest - 1) * $imagesCurrC)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="1 + (($currentContainer - 1) * $imagesPerC)"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="imagesInRange">
		   <xsl:choose>
			   <xsl:when test="($imagesCurrC mod $range) != 0">
			   	<xsl:value-of select="floor($imagesCurrC div $range) + 1"/>
			   </xsl:when>
			   <xsl:otherwise>
			   	<xsl:value-of select="$imagesCurrC div $range"/>
			   </xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!--xsl:message>HORIZONTAL thumbnails, nb images <xsl:value-of select="$imagesPerC"/>, nb images per rows <xsl:value-of select="$imagesInRange"/>, first image <xsl:value-of select="$firstImageNumber"/> in container #<xsl:value-of select="$currentContainer"/></xsl:message-->
		<!-- -->
		<xsl:apply-templates select=".//image[number(@number) &gt;= $firstImageNumber and number(@number) &lt; ($firstImageNumber + $imagesCurrC) and (((number(@number) - $firstImageNumber) mod $imagesInRange) = 0)]" mode="HORIZONTAL_THUMBNAIL_RANGE">
			<xsl:with-param name="imagesInRange" select="$imagesInRange"/>
			<xsl:with-param name="imagesCurrC" select="$imagesCurrC"/>
			<xsl:with-param name="range" select="$range"/>
			<xsl:with-param name="firstImageNumber" select="$firstImageNumber"/>
			<xsl:with-param name="rest" select="$rest"/>
			<xsl:with-param name="animation" select="$animation"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
		Renderer one range for a HORIZONTAL thumbnail container :
		   build one row with "imagesCurrC / range" cells in the table container
    -->
	<xsl:template match="image" mode="HORIZONTAL_THUMBNAIL_RANGE">
		<xsl:param name="imagesInRange"/>      <!-- number of images per range -->
		<xsl:param name="imagesCurrC"/>        <!-- number of images in current row -->
		<xsl:param name="range"/>              <!-- total number of rows -->
		<xsl:param name="firstImageNumber"/>   <!-- number of first image in the current container -->
		<xsl:param name="rest"/>               <!-- rest of number of images per range -->
		<xsl:param name="animation"/>
		<!-- -->
		<!--xsl:message>HORIZONTAL ONE RANGE : first image <xsl:value-of select="@number"/>, last image <xsl:value-of select="(number(@number) + $imagesInRange)"/></xsl:message-->
		<div class="thumbnailsRow">
			<xsl:for-each select="../..//image[(number(@number) &gt;= number(current()/@number)) and (number(@number) &lt; number(current()/@number) + $imagesInRange)]">
		     <xsl:if test="(../image[1]/@number = ./@number) and ../@title != ''">
		        <span class="section"><xsl:value-of select="../@title"/></span>
		     </xsl:if>
			   <xsl:apply-templates select="." mode="ONE_THUMBNAIL">
					<xsl:with-param name="animation" select="$animation"/>
			   </xsl:apply-templates>
			</xsl:for-each>
			<!--xsl:if test="(($imagesCurrC mod $range) != 0) and (($firstImageNumber + $imagesCurrC - ($rest - 1)) = $firstRangeNumber)">
				<td rowspan="{$range - ($imagesCurrC mod $range)}"><![CDATA[&nbsp;]]></td>
			</xsl:if-->
		</div>
	</xsl:template>
	<!--
	      Renderer one thumbnail image
 	 -->
	<xsl:template match="image" mode="ONE_THUMBNAIL">
		<xsl:param name="animation"/>
		<xsl:choose>
			<xsl:when test="@filename != $currentImage">
				<a title="{concat(@number,'. ',@comment)}" class="thumbnailLink" >
					<xsl:choose>
						<xsl:when test="string-length($animation) != 0">
							<xsl:attribute name="style"><xsl:value-of select="'cursor: pointer'"/></xsl:attribute>
							<xsl:attribute name="onclick"><xsl:value-of select="concat('XWgotoImage(',@number,')')"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="href"><xsl:value-of select="concat(@filename, '.html')"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:apply-templates select="." mode="THUMBNAIL_IMG"/>
				</a>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="." mode="THUMBNAIL_IMG">
					<xsl:with-param name="current" select="'true'"/>
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--

   -->
	<xsl:template match="image" mode="THUMBNAIL_IMG">
		<xsl:param name="current" select="'false'"/>
		<xsl:variable name="maxSize">
		   <xsl:choose>
				<xsl:when test="number(thumbnail/@height) &gt; number(thumbnail/@width)"><xsl:value-of select="number(thumbnail/@height)"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="number(thumbnail/@width)"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="vMargin" select="1 + (($maxSize - number(thumbnail/@height)) div 2)"/>
		<xsl:variable name="hMargin" select="1 + (($maxSize - number(thumbnail/@width)) div  2)"/>
		<img src="{concat(../../../images/@thumbnails, '/', @filename, '.', thumbnail/@extention)}" alt="{@number}" width="{thumbnail/@width}" height="{thumbnail/@height}" style="{concat('margin: ',$vMargin,'px ',$hMargin,'px;')}">
			<xsl:if test="$current = 'true'">
				<xsl:attribute name="class">currentThumbnail</xsl:attribute>
			</xsl:if>
		</img>
	</xsl:template>
</xsl:stylesheet>
