<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<!-- FONTS -->
	<xsl:template match="font | meta-data">
      <xsl:if test="@size">font-size: <xsl:value-of select="@size"/><xsl:value-of select="@unit"/>;</xsl:if>
  font-family: <xsl:value-of select="@name"/>;
     <xsl:if test="@style">font-style: <xsl:value-of select="@style"/>;</xsl:if>
	</xsl:template>
	
	<!-- COLORS -->
	<xsl:template match="body-background | page-background | foreground | link-foreground | disabled-foreground | link-hover | color | background | border-color">rgb(<xsl:value-of select="@r"/>,<xsl:value-of select="@g"/>,<xsl:value-of select="@b"/>)</xsl:template>
	
	<!-- LINE -->
	<xsl:template match="normal | hover | current | border">
	   <xsl:choose>
			<xsl:when test="@thin"><xsl:value-of select="@thin"/>px</xsl:when>
			<xsl:otherwise>1px</xsl:otherwise>
	   </xsl:choose>
	  <xsl:value-of select="concat(' ',@line,' ')"/>
	</xsl:template>
	
</xsl:stylesheet>
