﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!--
	 Creation date: 2009-03-04
	 Author: Gleam
	 -->
	<!-- 
		for each scrip generate a dummy comment to avoid a script empty tag because it doesn't supported by navigators event if a
	    src attribute is specified.
	 -->
	<xsl:template match="local-index-google-maps" mode="HEAD">
		<script src="{concat($pathToRoot, '/js/jquery.js')}" type="text/javascript"><xsl:comment>empty</xsl:comment></script>
		<script src="{concat('http://maps.google.com/maps?file=api&amp;v=2&amp;key=', $googleMapsKey)}" type="text/javascript"><xsl:comment>empty</xsl:comment></script>
		<script src="{concat($pathToRoot, '/js/gmaps.js')}" type="text/javascript"><xsl:comment>empty</xsl:comment></script>
		<xsl:if test="@thumbnail-marker = 'true'">
			<script src="markers/gmapsIcons.js" type="text/javascript"><xsl:comment>empty</xsl:comment></script>
		</xsl:if>
	</xsl:template>

	<xsl:template match="image-location-on-map" mode="HEAD">
		<xsl:param name="animation"/>
		<!-- if local-index-google-maps and animation are used some scripts are already inserted -->
		<xsl:if test="not(../local-index-google-maps and animation)">
			<script src="{concat($pathToRoot, '/js/jquery.js')}" type="text/javascript"><xsl:comment>empty</xsl:comment></script>
			<script src="{concat('http://maps.google.com/maps?file=api&amp;v=2&amp;key=', $googleMapsKey)}" type="text/javascript"><xsl:comment>empty</xsl:comment></script>
			<script src="{concat($pathToRoot, '/js/gmaps.js')}" type="text/javascript"><xsl:comment>empty</xsl:comment></script>
			<xsl:if test="@thumbnail-marker = 'true'">
				<script src="markers/gmapsIcons.js" type="text/javascript"><xsl:comment>empty</xsl:comment></script>
			</xsl:if>
		</xsl:if>
		<script src="{concat($pathToRoot, '/js/mapBox.js')}" type="text/javascript"><xsl:comment>empty</xsl:comment></script>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="local-index-google-maps" mode="ON-LOAD">
		<xsl:param name="animation"/>
		<xsl:variable name="mkr"><xsl:apply-templates select="@thumbnail-marker" mode="BOOL_TO_INT"/></xsl:variable>
		<xsl:variable name="zoom"><xsl:apply-templates select="@zoom-control" mode="BOOL_TO_INT"/></xsl:variable>
		<xsl:variable name="map"><xsl:apply-templates select="@map-control" mode="BOOL_TO_INT"/></xsl:variable>
		<xsl:variable name="overview"><xsl:apply-templates select="@overview-control" mode="BOOL_TO_INT"/></xsl:variable>
		<xsl:choose>
			<xsl:when test="string-length($animation) = 0">
				<xsl:value-of select="concat('XWMapInitAndLoad(', $mkr, ', ', @map-type, ', ', $zoom, ', ', $map, ', ', $overview, ', -1, 10);')"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat('XWMapInit(', $mkr, ', ', @map-type, ', ', $zoom, ', ', $map, ', ', $overview, ', -1, 10);')"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="image-location-on-map" mode="ON-LOAD">
		<xsl:variable name="mkr"><xsl:apply-templates select="@thumbnail-marker" mode="BOOL_TO_INT"/></xsl:variable>
		<xsl:variable name="zoom"><xsl:apply-templates select="@zoom-control" mode="BOOL_TO_INT"/></xsl:variable>
		<xsl:variable name="map"><xsl:apply-templates select="@map-control" mode="BOOL_TO_INT"/></xsl:variable>
		<xsl:variable name="overview"><xsl:apply-templates select="@overview-control" mode="BOOL_TO_INT"/></xsl:variable>
		<xsl:variable name="i"><xsl:value-of select="$contentDoc//image[@filename = $currentImage]/@number"/></xsl:variable>
		<xsl:variable name="f"><xsl:choose><xsl:when test="@fading"><xsl:value-of select="@fading"/></xsl:when><xsl:otherwise>none</xsl:otherwise></xsl:choose></xsl:variable>
		<xsl:variable name="z"><xsl:choose><xsl:when test="@zoom-level"><xsl:value-of select="@zoom-level"/></xsl:when><xsl:otherwise>10</xsl:otherwise></xsl:choose></xsl:variable>
		<xsl:value-of select="concat('XWInitMapBox(', $mkr, ', ', @map-type, ', ', $zoom, ', ', $map, ', ', $overview, ', ', $i, ', ', $z, ', &quot;', $f, '&quot;)')"/>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="@*" mode="BOOL_TO_INT">
		<xsl:choose>
			<xsl:when test=". = 'true'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	 -->
</xsl:stylesheet>
