﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!--
	 Creation date: 2004-12-23
	 Author: Gleam
	 This style sheet generates the HTML tages for the built with icon in the footer of an HTML page.
	 -->
	<xsl:template name="built-with">
		<xsl:param name="builtwith"/>
		<xsl:param name="builtwith-icon-path"/>
		<xsl:param name="builtwith-icon-type"/>
		<xsl:param name="page">global</xsl:param>
		<!--xsl:message><xsl:value-of select="$builtwith-icon-type"/></xsl:message-->
		<xsl:choose>
			<xsl:when test="($builtwith = 'all') or ($builtwith = 'global index' and $page = 'global') or ($builtwith = 'indexes' and ($page = 'global' or $page='index')) or ($builtwith = 'local index' and page = 'index')">
			<xsl:call-template name="built-with-link">
				<xsl:with-param name="icon-path" select="$builtwith-icon-path"/>
				<xsl:with-param name="icon-type" select="$builtwith-icon-type"/>
			</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!--
	 -->
	<xsl:template name="built-with-link">
	   <xsl:param name="icon-path"/>
	   <xsl:param name="icon-type"/>
	   <xsl:variable name="icon-name">
	   	<xsl:choose>
				<xsl:when test="$icon-type = 'normal'">BuiltWith.gif</xsl:when>
				<xsl:when test="$icon-type = 'negative'">negBuiltWith.gif</xsl:when>
			</xsl:choose>
	   </xsl:variable>
		<a href="http://xissweb.free.fr/" class="icon">
		   <xsl:attribute name="title">
		   	<xsl:call-template name="properties">
		   		<xsl:with-param name="lang" select="$lang"/>
		   		<xsl:with-param name="key">built-with.title</xsl:with-param>
		   	</xsl:call-template>
		   </xsl:attribute>
			<img src="{concat($icon-path,'/',$icon-name)}" alt="Built with Xiss Web" width="88" height="31"/>
		</a>
	</xsl:template>
	<!--
	 -->
</xsl:stylesheet>
