﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!--
	 Creation date: 2009-03-03
	 Author: Gleam
	-->
	<xsl:output method="xml" version="1.0" indent="no"/>
	<xsl:param name="icon-marker">false</xsl:param>
	<xsl:param name="thumbDir">thumbnails</xsl:param>
	<xsl:param name="animation">false</xsl:param>
	<!-- -->
	<xsl:template match="/">
		<markers>
			<xsl:apply-templates select="//image[meta-data/@latitude]"/>
		</markers>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="image">
		<marker>
			<xsl:attribute name="number"><xsl:value-of select="@number"/></xsl:attribute>
			<xsl:choose>
				<xsl:when test="$animation = 'false'">
					<xsl:attribute name="link"><xsl:value-of select="concat(@filename,'.html')"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="click"><xsl:value-of select="concat('XWgotoImage(',@number,')')"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:attribute name="thumbnail"><xsl:value-of select="concat($thumbDir, '/', @filename, '.', thumbnail/@extention)"/></xsl:attribute>
			<xsl:attribute name="latitude"><xsl:apply-templates select="meta-data/@latitude"/></xsl:attribute>
			<xsl:attribute name="longitude"><xsl:apply-templates select="meta-data/@longitude"/></xsl:attribute>
			<div>
				<xsl:choose>
					<xsl:when test="@comment"><xsl:value-of select="@comment"/></xsl:when>
					<xsl:otherwise><xsl:copy-of select="htmlComment/node()"/></xsl:otherwise>
				</xsl:choose>
			</div>
	   </marker>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="@latitude">
		<xsl:call-template name="to-degrees">
			<xsl:with-param name="value" select="substring-after(current(), ' ')"/>
			<xsl:with-param name="negRef" select="starts-with(current(), 'S')"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	 -->	
	<xsl:template match="@longitude">
		<xsl:call-template name="to-degrees">
			<xsl:with-param name="value" select="substring-after(current(), ' ')"/>
			<xsl:with-param name="negRef" select="starts-with(current(), 'W')"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	 -->	
	<xsl:template name="to-degrees">
		<xsl:param name="value"/>
		<xsl:param name="negRef"/>
		<xsl:param name="deg" select="substring-before($value, ' ')"/>
		<xsl:param name="minsec" select="substring-after($value, ' ')"/>
		<xsl:param name="min" select="substring-before($minsec, ' ')"/>
		<xsl:param name="sec" select="substring-after($minsec, ' ')"/>
		<xsl:param name="numValue" select="number($deg) + (number($min) div 60.0) + (number($sec) div 3600.0)"/>
		<xsl:choose>
			<xsl:when test="$negRef = 'true'"><xsl:value-of select="number(-1 * $numValue)"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$numValue"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- 
	 -->
	<xsl:template match="marker" mode="LATITUDE">
		<latitude value="{@latitude}"/>
	</xsl:template>
</xsl:stylesheet>
