﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!--
	 -->
	<xsl:import href="doc2html.xsl"/>
	<!--
	 -->
	<xsl:param name="lang" select="'fr'"/>
	<xsl:param name="images-base">rsrc/images/</xsl:param>
	<!--
	 -->
	<xsl:template match="/doc">
		<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="{$lang}">
			<head>
				<title><xsl:apply-templates select="doc-title"/></title>
  <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
  <meta name="author" content="Gleam" />
  <meta name="keywords" content="générateur de diaporama, XHTML, HTML, CSS, site internet, présentation, W3C, standard, standards" />
  <meta name="description" content="Xiss web (XML Interactive Slide Show) un générateur de pages XHTML pour diaporamas basé sur les standards du W3C" />
  <link href="../../css/default.css" rel="stylesheet" media="screen" type="text/css" />
  <link href="../../css/doc.css" rel="stylesheet" media="screen" type="text/css" />
  <link rel="shortcut icon" type="image/x-icon" href="../../favicon.ico" />
</head>
<body>
<div id="acces">[<a href="#menu">aller au menu</a> | <a href="#content">aller au contenu</a>]</div>
<div id="page">
	<div id="header">
	    <a href=".."><img src="../../images/logo.png" width="96" height="50" alt="Xiss web logo" title="Accueil"/></a>
	</div>
   <div id="menu">
      <ul>
         <li id="menu-begin"><span>Début du menu</span></li>
         <li><a id="lang" href="../../documentation"><span class="lang">&gt; EN</span><span class="info-lang">English<br />version</span></a></li>
         <li><a id="features" href="../features/"><span class="info">Voir les fonctionnalités</span></a></li>
         <li><a id="download" href="../downloads/"><span class="info">Télécharger les paquetages</span></a></li>
         <li id="current-doc"><span>Voir la documentation</span></li>
         <li><a id="examples" href="../examples/"><span class="info">Voir des exemples de diaporamas</span></a></li>
         <li><a id="mailing" href="../mailingList/"><span class="info">S'inscrire à la liste de diffusion</span></a></li>
         <li id="menu-end"><span>Fin du menu</span></li>
      </ul>
   </div>
	<div id="content">
		<h1>Librairies Xiss web</h1>
		
		<p><strong>Librairie Fichier</strong><br/>
		Librairie permettant l'exécution de traitements lors de l'exploration d'une hiérarchie de répertoires. Voir l'<a href="../../lib-api/file" class="dashed">API</a> (en Anglais).</p>
     
		<p><strong>Libarairie <i>Worker</i></strong><br/>
		Cette librairie permet de contrôler (arrêt, pause, ...) de long processus (une adaptation de <a href="http://java.sun.com/products/jfc/tsc/articles/threads/threads2.html" class="dashed">celui de Sun</a>). Voir <a href="../../lib-api/worker" class="dashed">API</a> (en Anglais).</p>
     
		<p><strong>Libarairie Préférences</strong><br/>
		Librairie gestion de préférences utilisant seulement des fichiers pour rendre les préférences persistantes. Cette librairie n'a pas exactement les mêmes fonctionnalités que celles des préférences Java. Voir l'<a href="../../lib-api/prefs" class="dashed">API</a> (en Anglais).</p>

	<!-- CALLING THE DOC GENERATION -->
	<xsl:apply-templates select="content"/>

	</div> <!-- content div -->
		
	</div>

		<div id="footer">&#169; 2004 - 2012 Xiss web</div>

		<div id="valid"><p>[<a href="http://validator.w3.org/check?uri=referer" title="Call the W3C HTML validator" class="conform">XHTML 1.1</a>]
		[<a href="http://jigsaw.w3.org/css-validator/check/referer" title="Call the W3C CSS validator" class="conform">CSS</a>]
		[<a href="http://www.w3.org/WAI/WCAG1AAA-Conformance" title="Explanation of Level Triple-A Conformance" class="conform">AAA</a>]</p>
		</div>
<div id="goto-top"><a title="Aller en haut de la page." href="#acces"/></div>
<script type="text/javascript" src="../../js/jquery.js"><xsl:comment>empty</xsl:comment></script>
<script type="text/javascript" src="../../js/doc.js"><xsl:comment>empty</xsl:comment></script>
	   </body>
		</html>
	</xsl:template>
	<!--
	-->
	<xsl:template name="i18n">
		<xsl:param name="key"/>
		<xsl:choose>
			<xsl:when test="$lang = 'en'">
				<xsl:choose>
					<xsl:when test="$key = 'skip.intro.toc'">Skip intro and table of content</xsl:when>
					<xsl:when test="$key = 'go.to.toc'">Go to table of content</xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$lang = 'fr'">
				<xsl:choose>
					<xsl:when test="$key = 'skip.intro.toc'">Passer l'intro et la table des matières</xsl:when>
					<xsl:when test="$key = 'go.to.toc'">Table des matières</xsl:when>
				</xsl:choose>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
