﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!--
	 -->
	<xsl:import href="doc2html.xsl"/>
	<!--
	 -->
	<xsl:param name="lang" select="'en'"/>
	<xsl:param name="images-base">rsrc/images/</xsl:param>
	<!--
	 -->
	<xsl:template match="/doc">
		<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="{$lang}">
			<head>
				<title><xsl:apply-templates select="doc-title"/></title>
				<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
				<meta name="author" content="Gleam" />
				<meta name="keywords" content="Slide show generator, slide show, generator, XHTML, HTML, CSS, web site, presentation, photo, photos, photography, picture, pictures, W3C, standard, standards" />
				<meta name="description" content="Xiss web (XML Interactive Slide Show) a generator of XHTML pages for slide show presentation based on W3C standards" />
				<link href="../css/default.css" rel="stylesheet" media="screen" type="text/css" />
				<link href="../css/doc.css" rel="stylesheet" media="screen" type="text/css" />
				<link rel="shortcut icon" type="image/x-icon" href="../favicon.ico" />
			</head>
		<body>
<div id="acces">[<a href="#menu">go to menu</a> | <a href="#content">go to content</a>]</div>
<div id="page">
	<div id="header">
	    <a href=".."><img src="../images/logo.png" width="96" height="50" alt="Xiss web logo" title="Home"/></a>
	</div>
   <div id="menu">
      <ul>
         <li id="menu-begin"><span>Menu begin</span></li>
         <li><a id="lang" href="../fr/documentation"><span class="lang">&gt; FR</span><span class="info-lang">Version<br />française</span></a></li>
         <li><a id="features" href="../features/"><span class="info">See the Xiss web's features</span></a></li>
         <li><a id="download" href="../downloads/"><span class="info">Download the Xiss web's packages</span></a></li>
         <li id="current-doc"><span>See the detailed documentation</span></li>
         <li><a id="examples" href="../examples/"><span class="info">See examples of slideshows</span></a></li>
         <li><a id="mailing" href="../mailingList/"><span class="info">Subscribe to the mailing list</span></a></li>
         <li id="menu-end"><span>Menu end</span></li>
      </ul>
   </div>
	<div id="content">
		<h1>Xiss web libraries</h1>
		
		<p><strong>File library</strong><br/>
		This library enables process run along a hierarchy of directories exploration. See <a href="../lib-api/file" class="dashed">API</a>.</p>
		
		<p><strong>Worker library</strong><br/>
		Swing worker to control (stop, pause, ...) long process (a customization of the <a href="http://java.sun.com/products/jfc/tsc/articles/threads/threads2.html" class="dashed">Sun's one</a>). See <a href="../lib-api/worker" class="dashed">API</a></p>
     
		<p><strong>Preferences library</strong><br/>
		This library uses only files to make preferences persistent. It has not exactly the
		same functionalities as the Java's preferences. See <a href="../lib-api/prefs" class="dashed">API</a>.</p>

		<xsl:apply-templates select="content"/>

		</div> <!-- content div -->
		
</div>

<div id="footer">&#169; 2004 - 2012 Xiss web</div>

<div id="valid"><p>[<a href="http://validator.w3.org/check?uri=referer" title="Call the W3C HTML validator" class="conform">XHTML 1.1</a>]
	[<a href="http://jigsaw.w3.org/css-validator/check/referer" title="Call the W3C CSS validator" class="conform">CSS</a>]
	[<a href="http://www.w3.org/WAI/WCAG1AAA-Conformance" title="Explanation of Level Triple-A Conformance" class="conform">AAA</a>]</p>
</div>

<div id="goto-top"><a title="Goto the top of the page." href="#acces"/></div>
<script type="text/javascript" src="../js/jquery.js"><xsl:comment>empty</xsl:comment></script>
<script type="text/javascript" src="../js/doc.js"><xsl:comment>empty</xsl:comment></script>
</body>
</html>
	</xsl:template>
	<!--
	-->
	<xsl:template name="i18n">
		<xsl:param name="key"/>
		<xsl:choose>
			<xsl:when test="$lang = 'en'">
				<xsl:choose>
					<xsl:when test="$key = 'skip.intro.toc'">Skip intro and table of content</xsl:when>
					<xsl:when test="$key = 'go.to.toc'">Go to table of content</xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$lang = 'fr'">
				<xsl:choose>
					<xsl:when test="$key = 'skip.intro.toc'">Passer l'intro et la table des matières</xsl:when>
					<xsl:when test="$key = 'go.to.toc'">Table des matières</xsl:when>
				</xsl:choose>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
