/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.file;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.xissweb.file.DirectoryObserver;
import org.xissweb.file.DirectoryVisitor;

public class SteppedDirectoryVisitor
extends DirectoryVisitor {
    private List allContexts = new ArrayList();

    public SteppedDirectoryVisitor(DirectoryObserver observer) {
        super(observer);
    }

    public SteppedDirectoryVisitor(DirectoryObserver observer, FileFilter observerFilter) {
        super(observer, observerFilter);
    }

    public SteppedDirectoryVisitor(DirectoryObserver observer, FileFilter visitorFilter, FileFilter observerFilter) {
        super(observer, visitorFilter, observerFilter);
    }

    public void visitInitialization(File directory) {
        this.allContexts.clear();
        this.addContext(directory);
    }

    public boolean step() {
        Context ctx = this.getCurrentContext();
        if (ctx == null) {
            return false;
        }
        if (ctx.dirsToVisit == null && ctx.index == -1 && ctx.observerInProgress) {
            ctx.observerInProgress = this.notifyInVisitToObserver(ctx.directory);
            if (!ctx.observerInProgress) {
                ctx.dirsToVisit = this.getNextDirs(ctx.directory);
                ++ctx.index;
                ctx.observerInProgress = true;
            }
        } else if (ctx.dirsToVisit == null && ctx.index == 0 || ctx.dirsToVisit.length == ctx.index && ctx.observerInProgress) {
            ctx.observerInProgress = this.notifyOutVisitToObserver(ctx.directory);
            if (!ctx.observerInProgress) {
                this.removeCurrentContext();
            }
        } else {
            this.addContext(ctx.dirsToVisit[ctx.index++]);
        }
        return true;
    }

    public boolean performStep() {
        return this.step();
    }

    public synchronized void stop() {
        this.allContexts.clear();
    }

    private void addContext(File dir) {
        this.allContexts.add(0, new Context(dir));
    }

    private Context getCurrentContext() {
        return this.allContexts.isEmpty() ? null : (Context)this.allContexts.get(0);
    }

    private void removeCurrentContext() {
        this.allContexts.remove(0);
    }

    private class Context {
        File directory;
        File[] dirsToVisit = null;
        int index = -1;
        boolean observerInProgress = true;

        Context(File dir) {
            this.directory = dir;
        }
    }
}

