/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.file;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import org.xissweb.file.DirectoryObserver;
import org.xissweb.file.FileHelper;

public class DirectoryVisitor {
    private DirectoryObserver observer;
    private FileFilter observerFilter;
    private FileFilter vistFilter;

    public DirectoryVisitor(DirectoryObserver observer) {
        this(observer, FileHelper.onlyDirectory, FileHelper.onlyDirectory);
    }

    public DirectoryVisitor(DirectoryObserver observer, FileFilter observerFilter) {
        this(observer, FileHelper.onlyDirectory, observerFilter);
    }

    public DirectoryVisitor(DirectoryObserver observer, FileFilter visitFilter, FileFilter observerFilter) {
        this.observer = observer;
        this.vistFilter = visitFilter;
        this.observerFilter = observerFilter;
    }

    public void visit(File dir) {
        this.notifyInVisitToObserver(dir);
        File[] files = this.getNextDirs(dir);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                this.visit(files[i]);
            }
        }
        this.notifyOutVisitToObserver(dir);
    }

    protected File[] getNextDirs(File directory) {
        Object[] files = directory.listFiles(this.vistFilter);
        if (files != null) {
            Arrays.sort(files);
        }
        return files;
    }

    protected boolean notifyInVisitToObserver(File directory) {
        return this.observerFilter.accept(directory) ? this.observer.inDirectory(directory) : false;
    }

    protected boolean notifyOutVisitToObserver(File directory) {
        return this.observerFilter.accept(directory) ? this.observer.outDirectory(directory) : false;
    }
}

