/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.i18n;

import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTabbedPane;
import org.xissweb.i18n.LangChangedOberver;

public class TextDisplayer
implements LangChangedOberver {
    private Hashtable allText = new Hashtable();
    private Hashtable allToolTip = new Hashtable();
    private Hashtable allTitle = new Hashtable();
    private Hashtable allComboBox = new Hashtable();
    private Hashtable allList = new Hashtable();
    private Hashtable allTabbedPane = new Hashtable();
    private Class managed;
    static /* synthetic */ Class class$java$lang$String;

    public TextDisplayer(Class managed) {
        this.managed = managed;
    }

    public static String getString(String key, Class aClass) {
        return ResourceBundle.getBundle(aClass.getName()).getString(key);
    }

    public String getString(String key) {
        return TextDisplayer.getString(key, this.managed);
    }

    public void register(JComponent textElement, String key) {
        this.allText.put(textElement, key);
        this.resetText(textElement);
    }

    public void registerList(JList list, String[] keys) {
        this.allList.put(list, keys);
        this.resetList(list);
    }

    public void resetList(JList list) {
        String[] keys = (String[])this.allList.get(list);
        String[] data = new String[keys.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.getString(keys[i]);
        }
        this.setListData(list, data);
    }

    public void registerTabbedPane(JTabbedPane tabbedPane, String[] titles) {
        this.allTabbedPane.put(tabbedPane, titles);
        this.resetTabbedPane(tabbedPane);
    }

    public void unregisterTabbedPane(JTabbedPane tabbedPane) {
        this.allTabbedPane.remove(tabbedPane);
    }

    public void resetTabbedPane(JTabbedPane tabbedPane) {
        String[] titles = (String[])this.allTabbedPane.get(tabbedPane);
        for (int i = 0; i < titles.length; ++i) {
            tabbedPane.setTitleAt(i, this.getString(titles[i]));
        }
    }

    public void unregister(JComponent component) {
        String key = (String)this.allText.remove(component);
        if (key != null) {
            this.setText(component, " ");
        }
    }

    public void resetText(JComponent component) {
        this.setText(component, this.getString((String)this.allText.get(component)));
    }

    public void registerToolTip(JComponent component, String key) {
        this.allToolTip.put(component, key);
        this.resetToolTip(component);
    }

    public void resetToolTip(JComponent component) {
        this.setToolTip(component, this.getString((String)this.allToolTip.get(component)));
    }

    public void registerTitle(Object component, String key) {
        this.allTitle.put(component, key);
        this.resetTitle(component);
    }

    public void resetTitle(Object component) {
        this.setTitle(component, this.getString((String)this.allTitle.get(component)));
    }

    public void registerCombo(JComboBox combo, String[] values) {
        this.allComboBox.put(combo, values);
        this.resetCombo(combo);
    }

    private void setToolTip(JComponent component, String text) {
        component.setToolTipText(text);
    }

    private void setText(JComponent component, String text) {
        Class<?> compClass = component.getClass();
        Class[] args = new Class[]{class$java$lang$String == null ? (class$java$lang$String = TextDisplayer.class$("java.lang.String")) : class$java$lang$String};
        Method setTextMethod = null;
        try {
            setTextMethod = compClass.getMethod("setText", args);
            Object[] textArg = new String[]{text};
            setTextMethod.invoke((Object)component, textArg);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void setListData(JList list, String[] data) {
        list.setListData(data);
    }

    private void setTitle(Object component, String title) {
        Class<?> compClass = component.getClass();
        Class[] args = new Class[]{class$java$lang$String == null ? (class$java$lang$String = TextDisplayer.class$("java.lang.String")) : class$java$lang$String};
        Method setTitleMethod = null;
        try {
            setTitleMethod = compClass.getMethod("setTitle", args);
            Object[] textArg = new String[]{title};
            setTitleMethod.invoke(component, textArg);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void resetCombo(JComboBox combo) {
        String[] keys = (String[])this.allComboBox.get(combo);
        int index = combo.getSelectedIndex();
        combo.setEnabled(false);
        combo.removeAllItems();
        for (int i = 0; i < keys.length; ++i) {
            combo.addItem(this.getString(keys[i]));
        }
        combo.setSelectedIndex(index);
        combo.setEnabled(true);
    }

    public void langChanged() {
        this.resetAllText();
    }

    public void resetAllText() {
        Iterator i = this.allText.keySet().iterator();
        while (i.hasNext()) {
            this.resetText((JComponent)i.next());
        }
        i = this.allTitle.keySet().iterator();
        while (i.hasNext()) {
            this.resetTitle(i.next());
        }
        i = this.allToolTip.keySet().iterator();
        while (i.hasNext()) {
            this.resetToolTip((JComponent)i.next());
        }
        i = this.allComboBox.keySet().iterator();
        while (i.hasNext()) {
            JComboBox combo = (JComboBox)i.next();
            this.resetCombo(combo);
        }
        i = this.allList.keySet().iterator();
        while (i.hasNext()) {
            JList list = (JList)i.next();
            this.resetList(list);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

