/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.util.tree;

import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeHelper {
    public static DefaultMutableTreeNode getNode(JTree tree, MouseEvent event) {
        return TreeHelper.getNode(tree, event.getX(), event.getY());
    }

    public static DefaultMutableTreeNode getNode(JTree tree, int x, int y) {
        int row = tree.getRowForLocation(x, y);
        if (row >= 0) {
            TreePath path = tree.getClosestPathForLocation(x, y);
            return (DefaultMutableTreeNode)path.getLastPathComponent();
        }
        return null;
    }

    public static DefaultMutableTreeNode getSelectedNode(JTree tree) {
        TreePath p = tree.getSelectionPath();
        if (p == null) {
            return null;
        }
        return (DefaultMutableTreeNode)p.getLastPathComponent();
    }

    public static ArrayList getSelectedNodes(JTree tree) {
        TreePath[] p = tree.getSelectionPaths();
        if (p == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < p.length; ++i) {
            list.add(p[i].getLastPathComponent());
        }
        return list;
    }

    public static Object getUserObject(JTree tree, MouseEvent event) {
        return TreeHelper.getUserObject(tree, event.getX(), event.getY());
    }

    public static Object getUserObject(JTree tree, int x, int y) {
        DefaultMutableTreeNode node = TreeHelper.getNode(tree, x, y);
        if (node != null) {
            return node.getUserObject();
        }
        return null;
    }

    public static void expandRoot(JTree tree) {
        TreeHelper.expandNode(tree, (DefaultMutableTreeNode)tree.getModel().getRoot());
    }

    public static void expandNode(JTree tree, DefaultMutableTreeNode node) {
        tree.expandPath(new TreePath(node.getPath()));
    }

    public static void expandAll(JTree tree) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getModel().getRoot();
        Enumeration<TreeNode> nodes = node.depthFirstEnumeration();
        while (nodes.hasMoreElements()) {
            DefaultMutableTreeNode noeudCourant = (DefaultMutableTreeNode)nodes.nextElement();
            tree.expandPath(new TreePath(noeudCourant.getPath()));
        }
    }

    public static void selectNode(JTree tree, DefaultMutableTreeNode node) {
        tree.setSelectionPath(new TreePath(node.getPath()));
    }

    public static void selectNode(JTree tree, DefaultMutableTreeNode node, boolean expand) {
        if (node != null) {
            TreePath path = new TreePath(node.getPath());
            tree.setSelectionPath(path);
            if (expand) {
                tree.expandPath(path);
            }
        }
    }

    public void unselect(JTree tree) {
        tree.setSelectionPath(null);
    }
}

