/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.skin.simple;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.xissweb.data.skin.LineInfo;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.editor.number.IntegerValueChecker;
import org.xissweb.gui.skin.simple.SkinEditor;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;

public class SkinLinePanel
extends JPanel {
    private static final long serialVersionUID = -3953424689219046899L;
    private static final String[] linetypes = new String[]{"line.type.none", "line.type.dotted", "line.type.dashed", "line.type.solid"};
    private LineInfo lineInfo;
    private TextDisplayer textDisplayer = TextDisplayManager.createTextDisplayFor(class$org$xissweb$gui$skin$simple$SkinLinePanel == null ? (class$org$xissweb$gui$skin$simple$SkinLinePanel = SkinLinePanel.class$("org.xissweb.gui.skin.simple.SkinLinePanel")) : class$org$xissweb$gui$skin$simple$SkinLinePanel);
    private SkinEditor editor;
    private JLabel titleLabel = null;
    private JTextField thinTextField = null;
    JComboBox typeComboBox = null;
    private JLabel errorLabel = null;
    static /* synthetic */ Class class$org$xissweb$gui$skin$simple$SkinLinePanel;

    public SkinLinePanel() {
        this.initialize();
    }

    public void setEditor(SkinEditor editor) {
        this.editor = editor;
    }

    public void setLineInfo(LineInfo lineInfo) {
        this.lineInfo = lineInfo;
        this.fillFields();
    }

    public JLabel getTitleLabel() {
        return this.titleLabel;
    }

    void thinChanged() {
        if (this.editor != null) {
            String text = this.thinTextField.getText();
            int check = IntegerValueChecker.checkValue(text);
            if (check == 2 || check == 3) {
                this.errorLabel.setVisible(false);
                int value = Integer.parseInt(text);
                if (value != this.lineInfo.getThin()) {
                    this.lineInfo.setThin(value);
                    this.editor.elementEdited(this.lineInfo);
                }
            } else {
                this.errorLabel.setText(IntegerValueChecker.getMessage(check));
                this.errorLabel.setVisible(true);
            }
        }
    }

    void typeChanged() {
        if (this.editor != null && this.lineInfo != null) {
            String value = null;
            switch (this.typeComboBox.getSelectedIndex()) {
                case 0: {
                    value = "none";
                    break;
                }
                case 1: {
                    value = "dotted";
                    break;
                }
                case 2: {
                    value = "dashed";
                    break;
                }
                case 3: {
                    value = "solid";
                }
            }
            if (value != null && !this.lineInfo.getType().equals(value)) {
                this.lineInfo.setType(value);
                this.editor.elementEdited(this.lineInfo);
            }
        }
    }

    public void fillFields() {
        this.thinTextField.setText(Integer.toString(this.lineInfo.getThin()));
        if (this.lineInfo.getType().equals("none")) {
            this.typeComboBox.setSelectedIndex(0);
        } else if (this.lineInfo.getType().equals("dotted")) {
            this.typeComboBox.setSelectedIndex(1);
        } else if (this.lineInfo.getType().equals("dashed")) {
            this.typeComboBox.setSelectedIndex(2);
        } else if (this.lineInfo.getType().equals("solid")) {
            this.typeComboBox.setSelectedIndex(3);
        }
    }

    private void initialize() {
        GridBagConstraints titleLabelConstraints = new GridBagConstraints();
        titleLabelConstraints.gridx = 0;
        titleLabelConstraints.gridy = 0;
        titleLabelConstraints.insets = new Insets(5, 5, 5, 5);
        GridBagConstraints thinTextFieldConstraints = new GridBagConstraints();
        thinTextFieldConstraints.gridx = 1;
        thinTextFieldConstraints.gridy = 0;
        thinTextFieldConstraints.insets = new Insets(5, 5, 5, 5);
        GridBagConstraints typeComboBoxConstraints = new GridBagConstraints();
        typeComboBoxConstraints.gridx = 2;
        typeComboBoxConstraints.gridy = 0;
        typeComboBoxConstraints.insets = new Insets(5, 5, 5, 5);
        GridBagConstraints errorLabelConstraints = new GridBagConstraints();
        errorLabelConstraints.gridx = 0;
        errorLabelConstraints.gridy = 1;
        errorLabelConstraints.gridheight = 1;
        errorLabelConstraints.gridwidth = 3;
        errorLabelConstraints.insets = new Insets(5, 5, 5, 5);
        this.errorLabel = new JLabel();
        this.errorLabel.setText("");
        this.errorLabel.setIcon(XissWebUI.getIcon("/images/common/error.png"));
        this.errorLabel.setVisible(false);
        this.titleLabel = new JLabel();
        this.textDisplayer.register(this.titleLabel, "thin.label");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.titleLabel, titleLabelConstraints);
        this.add((Component)this.getThinTextField(), thinTextFieldConstraints);
        this.add((Component)this.getTypeComboBox(), typeComboBoxConstraints);
        this.add((Component)this.errorLabel, errorLabelConstraints);
    }

    private JTextField getThinTextField() {
        if (this.thinTextField == null) {
            this.thinTextField = new JTextField();
            this.thinTextField.setPreferredSize(new Dimension(25, 20));
            this.thinTextField.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    SkinLinePanel.this.thinChanged();
                }
            });
            this.thinTextField.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    SkinLinePanel.this.thinChanged();
                }
            });
        }
        return this.thinTextField;
    }

    private JComboBox getTypeComboBox() {
        if (this.typeComboBox == null) {
            this.typeComboBox = new JComboBox();
            this.typeComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (SkinLinePanel.this.typeComboBox.isEnabled()) {
                        SkinLinePanel.this.typeChanged();
                    }
                }
            });
            this.textDisplayer.registerCombo(this.typeComboBox, linetypes);
        }
        return this.typeComboBox;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

