/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.project.basic;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.tree.DefaultMutableTreeNode;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.project.AbstractNewProjectDialog;
import org.xissweb.gui.project.FileNewProjectTreeModel;
import org.xissweb.gui.project.ProjectAnalyzer;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;

public class NewProjectDialog
extends AbstractNewProjectDialog {
    private static final long serialVersionUID = 1L;
    public static final int SET_AS_SRC_DIRECTORY_OPTION = 10;
    public static final int CREATE_MOVE_IN_SRC_DIRCTORY_OPTION = 11;
    public static final int REPOSITORY_FOR_NEW_PROJECT_OPTION = 12;
    public static final int NEW_PROJECT_REPOSITORY_OPTION = 13;
    private ButtonGroup optionGroup = new ButtonGroup();
    private TextDisplayer textDisplayer = TextDisplayManager.createTextDisplayFor(this.getClass());
    private JPanel mainPanel = null;
    private JPanel optionsPanel = null;
    private JRadioButton createSrcDirRadioButton = null;
    private JRadioButton moveInSrcDirRadioButton = null;
    private JRadioButton noOptionRadioButton = null;
    private JRadioButton setAsSrcDirRadioButton = null;
    private JRadioButton locationForRepositoryRadioButton = null;
    private JRadioButton newRepositoryProjectRadioButton = null;

    public NewProjectDialog(Frame owner) {
        super(owner);
        this.initialize();
        this.getFileTree().setModel(new FileNewProjectTreeModel());
        this.applyPreferences();
        this.imageViewLocationRegistration();
    }

    public int showDialog(File directory) {
        if (directory != null) {
            this.performProjectLocation(directory);
        }
        return super.showDialog();
    }

    protected String getHelpTag() {
        return "newbasicproject";
    }

    protected void choosedLocationAnalysed(ProjectAnalyzer currentAnalyser) {
        this.analyzer = currentAnalyser;
        this.projectLocation = this.analyzer.getLocation();
        this.srcDirectory = new File(this.projectLocation, "src");
        super.displayCurrentChoice(true);
        this.displayAnalyseResult();
        if (!this.isAnalyseOK()) {
            this.displayOptions(true);
        }
    }

    protected void displayCurrentChoice(boolean display) {
        super.displayCurrentChoice(display);
        this.displayOptions(display);
    }

    private void displayAnalyseResult() {
        StringBuffer buff = new StringBuffer();
        if (this.analyzer.getImageCount() == 0) {
            this.getImageNumberTextField().setText(this.textDisplayer.getString("project.no.image.found"));
            buff.append(this.textDisplayer.getString("project.no.image.found"));
        } else {
            this.getImageNumberTextField().setText(this.analyzer.getImageCount() + " " + this.textDisplayer.getString("project.nb.images.found"));
            if (this.analyzer.getImageMinDeep() < 2 || !this.analyzer.hasOnePossibleSrcDir()) {
                buff.append(' ').append(this.textDisplayer.getString("project.images.wrong.organization"));
                if (this.analyzer.hasDirectoyHierarchy()) {
                    buff.append(' ').append(this.textDisplayer.getString("project.image.no.src.dir"));
                } else {
                    buff.append(' ').append(this.textDisplayer.getString("project.image.no.dir.hierarchy"));
                }
            } else if (this.analyzer.getImageMinDeep() >= 2 && this.analyzer.hasOnePossibleSrcDir() && !this.srcDirectory.exists()) {
                buff.append(this.textDisplayer.getString("project.possible.src.dir.1"));
                buff.append(this.analyzer.getPossibleSrcDir().getName());
                buff.append(this.textDisplayer.getString("project.possible.src.dir.2"));
            }
        }
        this.getAnalyseLabel().setText(buff.toString());
        this.getAnalyseLabel().setIcon(this.isAnalyseOK() ? null : XissWebUI.getIcon("/images/common/warning.png"));
        this.getFileTree().setModel(new FileNewProjectTreeModel(this.projectLocation));
        this.getOkButton().setEnabled(this.isAnalyseOK());
    }

    private boolean isAnalyseOK() {
        return this.analyzer.getImageMinDeep() >= 2 && this.analyzer.hasOnePossibleSrcDir() && this.srcDirectory.exists();
    }

    protected JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.textDisplayer.registerTitle(this, "title");
            GridBagConstraints optionsPanelConstraints = new GridBagConstraints();
            optionsPanelConstraints.anchor = 18;
            optionsPanelConstraints.gridx = 0;
            optionsPanelConstraints.gridy = 2;
            optionsPanelConstraints.insets = new Insets(2, 5, 2, 5);
            GridBagConstraints imageNumConstraints = new GridBagConstraints();
            imageNumConstraints.fill = 2;
            imageNumConstraints.gridx = 1;
            imageNumConstraints.gridy = 1;
            imageNumConstraints.weightx = 1.3;
            imageNumConstraints.insets = new Insets(2, 5, 2, 5);
            GridBagConstraints analyseInfoConstraints = new GridBagConstraints();
            analyseInfoConstraints.fill = 2;
            analyseInfoConstraints.gridwidth = 3;
            analyseInfoConstraints.gridx = 0;
            analyseInfoConstraints.gridy = 3;
            analyseInfoConstraints.insets = new Insets(5, 5, 5, 5);
            analyseInfoConstraints.weightx = 1.0;
            GridBagConstraints waitingConstaintes = new GridBagConstraints();
            waitingConstaintes.fill = 1;
            waitingConstaintes.gridx = 1;
            waitingConstaintes.gridy = 2;
            waitingConstaintes.weightx = 1.3;
            waitingConstaintes.weighty = 1.0;
            waitingConstaintes.insets = new Insets(5, 5, 5, 5);
            GridBagConstraints fileTreeConstaints = new GridBagConstraints();
            fileTreeConstaints.fill = 1;
            fileTreeConstaints.gridx = 1;
            fileTreeConstaints.gridy = 2;
            fileTreeConstaints.weightx = 1.3;
            fileTreeConstaints.weighty = 1.0;
            fileTreeConstaints.insets = new Insets(5, 5, 5, 5);
            GridBagConstraints projLocationConstraints = new GridBagConstraints();
            projLocationConstraints.anchor = 17;
            projLocationConstraints.gridx = 2;
            projLocationConstraints.insets = new Insets(2, 5, 2, 15);
            projLocationConstraints.gridy = 0;
            GridBagConstraints helpLabelConstraints = new GridBagConstraints();
            helpLabelConstraints.anchor = 11;
            helpLabelConstraints.gridx = 0;
            helpLabelConstraints.insets = new Insets(2, 5, 2, 15);
            helpLabelConstraints.gridy = 1;
            GridBagConstraints showImgViewerConstraints = new GridBagConstraints();
            showImgViewerConstraints.anchor = 17;
            showImgViewerConstraints.gridx = 2;
            showImgViewerConstraints.insets = new Insets(2, 5, 2, 15);
            showImgViewerConstraints.gridy = 1;
            GridBagConstraints projTextFieldConstraints = new GridBagConstraints();
            projTextFieldConstraints.fill = 2;
            projTextFieldConstraints.gridy = 0;
            projTextFieldConstraints.weightx = 1.0;
            projTextFieldConstraints.insets = new Insets(2, 5, 2, 5);
            projTextFieldConstraints.gridx = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(5, 15, 5, 5);
            gridBagConstraints.gridy = 0;
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.setSize(new Dimension(254, 524));
            this.mainPanel.add((Component)this.getProjectLocationLabel(), gridBagConstraints);
            this.mainPanel.add((Component)this.getProjectLocationTextField(), projTextFieldConstraints);
            this.mainPanel.add((Component)this.getProjectLocationButton(), projLocationConstraints);
            this.mainPanel.add((Component)this.getShowImageViewerCheckBox(), showImgViewerConstraints);
            this.mainPanel.add((Component)this.getHelpLabel(), helpLabelConstraints);
            this.mainPanel.add((Component)this.getWaitPanel(), waitingConstaintes);
            this.mainPanel.add(this.getFileTreeContainer(), fileTreeConstaints);
            this.mainPanel.add((Component)this.getAnalyseLabel(), analyseInfoConstraints);
            this.mainPanel.add((Component)this.getImageNumberTextField(), imageNumConstraints);
            this.mainPanel.add((Component)this.getOptionsPanel(), optionsPanelConstraints);
            this.getWaitPanel().setVisible(false);
        }
        return this.mainPanel;
    }

    private void hideAllOptions() {
        this.setAsSrcDirRadioButton.setVisible(false);
        this.createSrcDirRadioButton.setVisible(false);
        this.moveInSrcDirRadioButton.setVisible(false);
        this.locationForRepositoryRadioButton.setVisible(false);
        this.newRepositoryProjectRadioButton.setVisible(false);
    }

    private void displayOptions(boolean display) {
        if (!display) {
            this.hideAllOptions();
        } else {
            this.hideAllOptions();
            this.optionGroup.remove(this.setAsSrcDirRadioButton);
            this.optionGroup.remove(this.createSrcDirRadioButton);
            this.optionGroup.remove(this.moveInSrcDirRadioButton);
            this.optionGroup.remove(this.locationForRepositoryRadioButton);
            this.optionGroup.remove(this.newRepositoryProjectRadioButton);
            if (this.projectLocation != null) {
                if (this.analyzer.getImageMinDeep() >= 1 && this.srcDirectory.exists()) {
                    this.optionGroup.add(this.moveInSrcDirRadioButton);
                    this.moveInSrcDirRadioButton.setVisible(true);
                }
                if (this.analyzer.getImageMinDeep() >= 1 && !this.srcDirectory.exists()) {
                    this.optionGroup.add(this.createSrcDirRadioButton);
                    this.createSrcDirRadioButton.setVisible(true);
                }
                if (this.analyzer.getImageMinDeep() >= 2 && this.analyzer.hasOnePossibleSrcDir() && !this.srcDirectory.exists()) {
                    this.optionGroup.add(this.setAsSrcDirRadioButton);
                    this.setAsSrcDirRadioButton.setText(this.textDisplayer.getString("option.set.as.src.dir.1") + this.analyzer.getPossibleSrcDir().getName() + this.textDisplayer.getString("option.set.as.src.dir.2"));
                    this.setAsSrcDirRadioButton.setVisible(true);
                }
                if (this.analyzer.getImageMinDeep() >= 1) {
                    this.optionGroup.add(this.locationForRepositoryRadioButton);
                    this.locationForRepositoryRadioButton.setVisible(true);
                }
                if (this.analyzer.getImageCount() == 0) {
                    this.optionGroup.add(this.newRepositoryProjectRadioButton);
                    this.newRepositoryProjectRadioButton.setVisible(true);
                }
            }
            this.getNoOptionRadioButton().setSelected(true);
            this.getOptionsPanel().setVisible(display);
            this.ignoreButton.setVisible(display && this.projectLocation != null);
        }
    }

    void performOptionSelection(int option) {
        this.srcDirectory = null;
        this.option = option;
        switch (this.option) {
            case 10: {
                this.srcDirectory = this.analyzer.getPossibleSrcDir();
                break;
            }
            case 11: {
                this.srcDirectory = new File(this.projectLocation, "src");
            }
        }
        if (this.analyzer.getPossibleSrcDir() != null) {
            FileNewProjectTreeModel treeModel = (FileNewProjectTreeModel)this.getFileTree().getModel();
            DefaultMutableTreeNode node = treeModel.getNodeFromUserObject(this.analyzer.getPossibleSrcDir());
            treeModel.nodeChanged(node);
        }
        this.getOkButton().setEnabled(true);
    }

    private JPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel();
            this.optionsPanel.setVisible(false);
            this.optionsPanel.setLayout(new BoxLayout(this.getOptionsPanel(), 3));
            this.optionsPanel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.optionsPanel.add((Component)this.getSetAsSrcDirRadioButton(), null);
            this.optionsPanel.add((Component)this.getCreateSrcDirRadioButton(), null);
            this.optionsPanel.add((Component)this.getMoveInSrcDirRadioButton(), null);
            this.optionsPanel.add((Component)this.getLocationForRepositoryRadioButton(), null);
            this.optionsPanel.add((Component)this.getNewRepositoryProjectRadioButton(), null);
            this.getNoOptionRadioButton().setVisible(false);
        }
        return this.optionsPanel;
    }

    private JRadioButton getCreateSrcDirRadioButton() {
        if (this.createSrcDirRadioButton == null) {
            this.createSrcDirRadioButton = new JRadioButton();
            this.createSrcDirRadioButton.setHorizontalTextPosition(2);
            this.createSrcDirRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NewProjectDialog.this.performOptionSelection(11);
                }
            });
            this.textDisplayer.register(this.createSrcDirRadioButton, "option.create.src.dir");
            this.textDisplayer.registerToolTip(this.createSrcDirRadioButton, "option.tooltip.create.src.dir");
        }
        return this.createSrcDirRadioButton;
    }

    private JRadioButton getMoveInSrcDirRadioButton() {
        if (this.moveInSrcDirRadioButton == null) {
            this.moveInSrcDirRadioButton = new JRadioButton();
            this.moveInSrcDirRadioButton.setHorizontalTextPosition(2);
            this.moveInSrcDirRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NewProjectDialog.this.performOptionSelection(11);
                }
            });
            this.textDisplayer.register(this.moveInSrcDirRadioButton, "option.move.in.src.dir");
            this.textDisplayer.registerToolTip(this.moveInSrcDirRadioButton, "option.tooltip.move.in.src.dir");
        }
        return this.moveInSrcDirRadioButton;
    }

    private JRadioButton getNoOptionRadioButton() {
        if (this.noOptionRadioButton == null) {
            this.noOptionRadioButton = new JRadioButton();
            this.noOptionRadioButton.setHorizontalTextPosition(2);
            this.optionGroup.add(this.noOptionRadioButton);
        }
        return this.noOptionRadioButton;
    }

    private JRadioButton getSetAsSrcDirRadioButton() {
        if (this.setAsSrcDirRadioButton == null) {
            this.setAsSrcDirRadioButton = new JRadioButton();
            this.setAsSrcDirRadioButton.setHorizontalTextPosition(2);
            this.setAsSrcDirRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NewProjectDialog.this.performOptionSelection(10);
                }
            });
            this.textDisplayer.registerToolTip(this.setAsSrcDirRadioButton, "option.tooltip.set.as.src.dir");
        }
        return this.setAsSrcDirRadioButton;
    }

    private JRadioButton getLocationForRepositoryRadioButton() {
        if (this.locationForRepositoryRadioButton == null) {
            this.locationForRepositoryRadioButton = new JRadioButton();
            this.locationForRepositoryRadioButton.setHorizontalTextPosition(2);
            this.locationForRepositoryRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NewProjectDialog.this.performOptionSelection(12);
                }
            });
            this.textDisplayer.register(this.locationForRepositoryRadioButton, "option.location.for.repository");
            this.textDisplayer.registerToolTip(this.locationForRepositoryRadioButton, "option.tooltip.location.for.repository");
        }
        return this.locationForRepositoryRadioButton;
    }

    private JRadioButton getNewRepositoryProjectRadioButton() {
        if (this.newRepositoryProjectRadioButton == null) {
            this.newRepositoryProjectRadioButton = new JRadioButton();
            this.newRepositoryProjectRadioButton.setHorizontalTextPosition(2);
            this.newRepositoryProjectRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NewProjectDialog.this.performOptionSelection(13);
                }
            });
            this.textDisplayer.register(this.newRepositoryProjectRadioButton, "option.new.repository.project");
            this.textDisplayer.registerToolTip(this.newRepositoryProjectRadioButton, "option.tooltip.new.repository.project");
        }
        return this.newRepositoryProjectRadioButton;
    }
}

