/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.prefs;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.editor.Editor;
import org.xissweb.gui.editor.EditorsContainer;
import org.xissweb.gui.editor.ValidProcessHandler;
import org.xissweb.gui.prefs.PreferenceTreeCellEditor;
import org.xissweb.gui.prefs.PreferencesEditionManager;
import org.xissweb.gui.prefs.PreferencesTreeCellRenderer;
import org.xissweb.gui.prefs.PreferencesTreeModel;
import org.xissweb.gui.prefs.data.PreferenceElement;
import org.xissweb.gui.prefs.data.PreferenceInfo;
import org.xissweb.gui.util.tree.TreeHelper;
import org.xissweb.i18n.TextDisplayer;

public class PreferencesEditor
extends JScrollPane
implements Editor {
    private static final long serialVersionUID = -2920763669963690374L;
    private static final String PREFERENCES_ICON = "/images/preferences/preferences.png";
    private Hashtable changes = new Hashtable();
    private PreferencesTreeModel treeModel = null;
    private JTree prefsTree = null;
    DefaultMutableTreeNode editingNode = null;
    EditorsContainer editorsContainer;
    private PreferencesEditionManager preferencesManager;

    public PreferencesEditor() {
        this.initialize();
        this.initPrefsTree();
    }

    private void initialize() {
        this.setViewportView(this.getPrefsTree());
    }

    public void modified(boolean error) {
    }

    void notifyPreferenceChanges() {
        Iterator i = this.changes.keySet().iterator();
        while (i.hasNext()) {
            PreferenceInfo pInfo = (PreferenceInfo)i.next();
            this.preferencesManager.notifyPreferenceChanged(pInfo, this.changes.get(pInfo));
        }
    }

    Object getPreferenceValue(PreferenceInfo prefInfo) {
        Object value = this.changes.get(prefInfo);
        if (value == null) {
            value = this.preferencesManager.getPreferenceValue(prefInfo);
        }
        return value;
    }

    String getDefaultValue(PreferenceInfo prefInfo) {
        return this.preferencesManager.getPreferenceDefault(prefInfo);
    }

    boolean isEdited(PreferenceElement prefElt) {
        return this.changes.get(prefElt) != null;
    }

    private void initPrefsTree() {
        if (this.treeModel == null) {
            this.treeModel = new PreferencesTreeModel();
            this.getPrefsTree().setModel(this.treeModel);
            this.getPrefsTree().setCellRenderer(new PreferencesTreeCellRenderer(this));
            this.getPrefsTree().setCellEditor(new PreferenceTreeCellEditor(this.getPrefsTree(), new DefaultTreeCellRenderer(), this));
            this.getPrefsTree().setEditable(true);
            this.getPrefsTree().setRootVisible(false);
        }
    }

    private JTree getPrefsTree() {
        if (this.prefsTree == null) {
            this.prefsTree = new JTree();
            this.prefsTree.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    PreferencesEditor.this.onTreeMouseCliked(e);
                }
            });
        }
        return this.prefsTree;
    }

    void onTreeMouseCliked(MouseEvent e) {
        DefaultMutableTreeNode node = TreeHelper.getNode(this.prefsTree, e);
        if (node != null && node.getUserObject() instanceof PreferenceInfo && this.editingNode == null) {
            this.editingNode = node;
            this.prefsTree.startEditingAtPath(new TreePath(node.getPath()));
        }
    }

    void endPreferenceEdition(PreferenceInfo preferenceInfo, Object newValue) {
        Object value = this.preferencesManager.getPreferenceValue(preferenceInfo);
        if (!value.equals(newValue)) {
            this.changes.put(preferenceInfo, newValue);
        } else {
            this.changes.remove(preferenceInfo);
        }
        if (this.changes.isEmpty()) {
            this.editorsContainer.editorStatusChange(this, 2);
        } else {
            this.editorsContainer.editorStatusChange(this, 1);
        }
    }

    public void setEditorsContainer(EditorsContainer editorsContainer) {
        this.editorsContainer = editorsContainer;
    }

    public void setEditedDocument(Object document) {
        this.preferencesManager = (PreferencesEditionManager)document;
    }

    public Object getEditedDocument() {
        return this.preferencesManager;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void edit() {
        this.treeModel = new PreferencesTreeModel(this.preferencesManager);
        this.prefsTree.setModel(this.treeModel);
        TreeHelper.expandAll(this.prefsTree);
        this.editorsContainer.editorStatusChange(this, 0);
    }

    public void edit(Object arg) {
        this.edit();
    }

    public boolean isDocumentValid() {
        return true;
    }

    public void setValidProcessHandler(ValidProcessHandler handler) {
    }

    public ValidProcessHandler getValidProcessHandler() {
        return null;
    }

    public int save() {
        Iterator i = this.changes.keySet().iterator();
        while (i.hasNext()) {
            PreferenceInfo preferenceInfo = (PreferenceInfo)i.next();
            this.preferencesManager.setPreferenceValue(preferenceInfo, this.changes.get(preferenceInfo));
        }
        this.notifyPreferenceChanges();
        this.changes.clear();
        this.editorsContainer.editorStatusChange(this, 3);
        return 0;
    }

    public void cancel() {
        ArrayList keys = new ArrayList(this.changes.keySet());
        this.changes.clear();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            this.treeModel.nodeChanged(this.treeModel.getNodeFromUserObject(i.next()));
        }
        this.editorsContainer.editorStatusChange(this, 2);
    }

    public void reload() {
        this.treeModel = new PreferencesTreeModel(this.preferencesManager);
        this.prefsTree.setModel(this.treeModel);
        TreeHelper.expandAll(this.prefsTree);
    }

    public String getDocumentName() {
        return TextDisplayer.getString("document.name", this.getClass());
    }

    public boolean hasDocumentModified() {
        return !this.changes.isEmpty();
    }

    public Component getEditorGuiComponent() {
        return this;
    }

    public Icon getIcon() {
        return XissWebUI.getIcon(PREFERENCES_ICON);
    }

    public JMenuItem[] getMenuItems() {
        return null;
    }
}

