/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.prefs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.prefs.PreferencesEditionManager;
import org.xissweb.gui.prefs.PreferencesEditor;
import org.xissweb.gui.prefs.data.PreferenceInfo;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;

public class PreferenceTreeCellEditor
extends DefaultTreeCellEditor {
    private int integerSliderWidth = 100;
    private PreferencesEditor editor;
    private DefaultMutableTreeNode currentNode;
    private JPanel editorComponent;
    private JLabel labelComponent;
    private JTextField textComponent;
    private JComboBox comboBooleanComponent;
    private JComboBox comboEnumComponent;
    private JButton selectAFileButton;
    private JButton setToDefaultButton;
    private TextDisplayer textDisplayer;
    private JSlider integerSlider;
    static /* synthetic */ Class class$org$xissweb$gui$prefs$PreferenceTreeCellEditor;

    public PreferenceTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer, PreferencesEditor editor) {
        super(tree, renderer);
        this.editor = editor;
        this.textDisplayer = TextDisplayManager.createTextDisplayFor(class$org$xissweb$gui$prefs$PreferenceTreeCellEditor == null ? (class$org$xissweb$gui$prefs$PreferenceTreeCellEditor = PreferenceTreeCellEditor.class$("org.xissweb.gui.prefs.PreferenceTreeCellEditor")) : class$org$xissweb$gui$prefs$PreferenceTreeCellEditor);
        this.initialize();
    }

    private void initialize() {
        this.comboBooleanComponent = new JComboBox();
        this.comboBooleanComponent.addItem(new Boolean(false));
        this.comboBooleanComponent.addItem(new Boolean(true));
        this.comboBooleanComponent.setFont(XissWebUI.boldFont);
        this.comboBooleanComponent.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent arg0) {
                PreferenceTreeCellEditor.this.stopCellEditing();
            }
        });
        this.comboEnumComponent = new JComboBox();
        this.comboEnumComponent.setFont(XissWebUI.boldFont);
        this.comboEnumComponent.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent arg0) {
                PreferenceTreeCellEditor.this.stopCellEditing();
            }
        });
        this.selectAFileButton = new JButton();
        this.selectAFileButton.setFont(XissWebUI.boldFont);
        this.selectAFileButton.setMargin(new Insets(0, 3, 0, 7));
        this.selectAFileButton.setText("...");
        this.textDisplayer.registerToolTip(this.selectAFileButton, "select.file.tooltip");
        this.selectAFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                PreferenceTreeCellEditor.this.selectAFile();
                PreferenceTreeCellEditor.this.stopCellEditing();
            }
        });
        this.setToDefaultButton = new JButton();
        this.textDisplayer.register(this.setToDefaultButton, "set.to.default");
        this.setToDefaultButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                PreferenceTreeCellEditor.this.setDefaultValue();
                PreferenceTreeCellEditor.this.stopCellEditing();
            }
        });
        this.labelComponent = new JLabel();
        this.labelComponent.setFont(XissWebUI.boldFont);
        this.textComponent = new JTextField();
        this.textComponent.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PreferenceTreeCellEditor.this.stopCellEditing();
                }
            }
        });
        this.integerSlider = new JSlider();
        this.integerSlider.setPaintTicks(true);
        this.integerSlider.setPaintLabels(true);
        this.integerSlider.setPaintTrack(true);
        this.integerSlider.setMinorTickSpacing(1);
        this.integerSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PreferenceTreeCellEditor.this.integerSliderValueChanged();
            }
        });
        FlowLayout layout = new FlowLayout();
        layout.setHgap(5);
        layout.setVgap(0);
        layout.setAlignment(0);
        this.editorComponent = new JPanel(layout);
        this.editorComponent.add(this.labelComponent);
    }

    void selectAFile() {
        JFileChooser webExplorerChooser = new JFileChooser();
        webExplorerChooser.setFileSelectionMode(0);
        int result = webExplorerChooser.showOpenDialog(this.editor);
        if (result == 0) {
            File file = webExplorerChooser.getSelectedFile();
            this.textComponent.setText(file.getAbsolutePath());
        }
    }

    public Component getTreeCellEditorComponent(JTree tree, Object node, boolean arg2, boolean arg3, boolean arg4, int arg5) {
        this.currentNode = (DefaultMutableTreeNode)node;
        PreferenceInfo preferenceInfo = (PreferenceInfo)this.currentNode.getUserObject();
        Object value = this.editor.getPreferenceValue(preferenceInfo);
        String strValue = null;
        switch (preferenceInfo.getType()) {
            case 0: {
                this.labelComponent.setText(PreferencesEditionManager.displayLabel(preferenceInfo) + " =");
                Boolean bool = (Boolean)value;
                if (bool.booleanValue()) {
                    this.comboBooleanComponent.setSelectedIndex(1);
                } else {
                    this.comboBooleanComponent.setSelectedIndex(0);
                }
                this.editorComponent.add(this.comboBooleanComponent);
                strValue = value.toString();
                break;
            }
            case 4: {
                this.labelComponent.setText(PreferencesEditionManager.displayLabel(preferenceInfo) + " =");
                strValue = (String)value;
                this.textComponent.setText(strValue);
                this.textComponent.setColumns(strValue.length() + 3);
                this.editorComponent.add(this.textComponent);
                break;
            }
            case 1: {
                this.labelComponent.setText(PreferencesEditionManager.displayLabel(preferenceInfo) + " =");
                strValue = (String)value;
                this.textComponent.setText(strValue);
                this.editorComponent.add(this.textComponent);
                if (preferenceInfo.getValues() == null) break;
                int min = Integer.parseInt(preferenceInfo.getValues()[0]);
                int max = Integer.parseInt(preferenceInfo.getValues()[1]);
                this.integerSlider.setMinimum(min);
                this.integerSlider.setMaximum(max);
                this.integerSlider.setMajorTickSpacing(max - min);
                this.integerSlider.setValue(Integer.parseInt(strValue));
                this.editorComponent.add(this.integerSlider);
                this.integerSlider.setPreferredSize(new Dimension(this.integerSliderWidth, this.integerSlider.getPreferredSize().height));
                this.textComponent.setEditable(false);
                this.textComponent.setColumns(3);
                break;
            }
            case 5: {
                this.comboEnumComponent.removeAllItems();
                String[] values = preferenceInfo.getValues();
                for (int i = 0; i < values.length; ++i) {
                    this.comboEnumComponent.addItem(values[i]);
                }
                this.labelComponent.setText(PreferencesEditionManager.displayLabel(preferenceInfo) + " =");
                this.comboEnumComponent.setSelectedItem(value);
                this.editor.add(this.comboEnumComponent);
                strValue = (String)value;
                break;
            }
            case 6: {
                this.labelComponent.setText(PreferencesEditionManager.displayLabel(preferenceInfo) + " =");
                strValue = (String)value;
                this.textComponent.setText(strValue);
                this.textComponent.setColumns(strValue.length());
                this.editorComponent.add(this.textComponent);
                this.editorComponent.add(this.selectAFileButton);
                break;
            }
        }
        String defaultValue = this.editor.getDefaultValue(preferenceInfo);
        if (defaultValue != null) {
            this.editorComponent.add(this.setToDefaultButton);
            this.setToDefaultButton.setEnabled(!defaultValue.equals(strValue));
        }
        return this.editorComponent;
    }

    void integerSliderValueChanged() {
        this.textComponent.setText(Integer.toString(this.integerSlider.getValue()));
    }

    void setDefaultValue() {
        PreferenceInfo prefInfo = (PreferenceInfo)this.currentNode.getUserObject();
        String value = this.editor.getDefaultValue(prefInfo);
        switch (prefInfo.getType()) {
            case 0: {
                boolean bool;
                this.labelComponent.setText(PreferencesEditionManager.displayLabel(prefInfo) + " =");
                boolean bl = bool = value.equals("true");
                if (bool) {
                    this.comboBooleanComponent.setSelectedIndex(1);
                    break;
                }
                this.comboBooleanComponent.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.labelComponent.setText(PreferencesEditionManager.displayLabel(prefInfo) + " =");
                this.textComponent.setText(value);
                break;
            }
            case 4: {
                this.labelComponent.setText(PreferencesEditionManager.displayLabel(prefInfo) + " =");
                this.textComponent.setText(value);
                break;
            }
            case 5: {
                this.comboEnumComponent.removeAllItems();
                this.labelComponent.setText(PreferencesEditionManager.displayLabel(prefInfo) + " =");
                this.comboEnumComponent.setSelectedItem(value);
                break;
            }
            case 6: {
                this.labelComponent.setText(PreferencesEditionManager.displayLabel(prefInfo) + " =");
                this.textComponent.setText(value);
                this.textComponent.setColumns(value.length());
                break;
            }
        }
    }

    public Object getCellEditorValue() {
        PreferenceInfo prefInfo = (PreferenceInfo)this.currentNode.getUserObject();
        this.editor.editingNode = null;
        switch (prefInfo.getType()) {
            case 0: {
                this.editorComponent.remove(this.comboBooleanComponent);
                this.editor.endPreferenceEdition(prefInfo, this.comboBooleanComponent.getSelectedItem());
                break;
            }
            case 1: {
                this.textComponent.setEditable(true);
                this.editorComponent.remove(this.integerSlider);
                this.editorComponent.remove(this.textComponent);
                this.editor.endPreferenceEdition(prefInfo, this.textComponent.getText());
                break;
            }
            case 4: {
                this.editorComponent.remove(this.textComponent);
                this.editor.endPreferenceEdition(prefInfo, this.textComponent.getText());
                break;
            }
            case 5: {
                this.editorComponent.remove(this.comboEnumComponent);
                this.editor.endPreferenceEdition(prefInfo, this.comboEnumComponent.getSelectedItem());
                break;
            }
            case 6: {
                this.editorComponent.remove(this.textComponent);
                this.editorComponent.remove(this.selectAFileButton);
                this.editor.endPreferenceEdition(prefInfo, this.textComponent.getText());
                break;
            }
        }
        this.editorComponent.remove(this.setToDefaultButton);
        return prefInfo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

