/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.layout.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.xissweb.data.layout.SkinInfo;
import org.xissweb.file.FileHelper;
import org.xissweb.gui.Main;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.layout.LayoutEditor;
import org.xissweb.gui.layout.editor.AbstractLayoutElementEditor;
import org.xissweb.gui.util.skin.SkinHelper;
import org.xissweb.i18n.LangChangedOberver;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.project.SlideShowProperties;

public class SkinEditor
extends AbstractLayoutElementEditor
implements LangChangedOberver {
    private static final long serialVersionUID = 3883688144223766966L;
    private static final String lookManagement = "look";
    private SkinInfo skin;
    private JLabel skinNameLabel = null;
    JComboBox skinNameComboBox = null;
    private JCheckBox defaultPathCheckBox = null;
    private JTextField pathTextField = null;
    private JButton pathButton = null;
    private JFileChooser pathChooser = null;

    public SkinEditor(LayoutEditor mainEditor) {
        super(mainEditor);
        this.textDisplayer = TextDisplayManager.createTextDisplayFor(this.getClass());
        this.initialize();
    }

    protected void initEdition() {
        this.defaultPathCheckBox.setSelected(this.skin.getPath() == null);
        this.pathTextField.setText(this.skin.getPath() == null ? Main.get().getCurrentProject().getProperties().getSkinsPath() : this.skin.getPath());
        this.fillSkinNameComboBox();
        this.skinNameComboBox.setSelectedItem(this.skin.getSkinName());
    }

    public void modified(boolean error) {
        if (!this.initializing) {
            boolean bl = this.isModified = !this.skin.getSkinName().equals(this.skinNameComboBox.getSelectedItem()) || !this.getSkinDir(this.skin.getPath()).equals(this.getSkinDir());
            if (this.isModified) {
                this.save();
            }
        }
    }

    private File getSkinDir() {
        return this.getSkinDir(this.pathTextField.getText());
    }

    private File getSkinDir(String path) {
        File dir = new File(path != null ? path : Main.get().getCurrentProject().getProperties().getSkinsPath());
        if (!dir.exists()) {
            dir = new File(SlideShowProperties.getXissWebHomeDir(), path);
        }
        if (!dir.exists()) {
            dir = new File(Main.get().getCurrentProject().getLocation(), path);
        }
        return dir;
    }

    void defaultPathStateChanged() {
        String name = (String)this.skinNameComboBox.getSelectedItem();
        this.pathButton.setEnabled(!this.defaultPathCheckBox.isSelected());
        if (this.defaultPathCheckBox.isSelected()) {
            this.pathTextField.setText(Main.get().getCurrentProject().getProperties().getSkinsPath());
            this.fillSkinNameComboBox();
        } else {
            File projectSkins = new File(Main.get().getCurrentProject().getLocation(), "skins");
            if (projectSkins.exists()) {
                String fullPath = projectSkins.getAbsolutePath();
                String path = FileHelper.relativePath(Main.get().getCurrentProject().getLocation(), projectSkins);
                this.pathTextField.setText(fullPath.length() <= path.length() ? fullPath : path);
                this.fillSkinNameComboBox(projectSkins);
            }
        }
        this.skinNameComboBox.setSelectedItem(name);
    }

    private void fillSkinNameComboBox() {
        this.fillSkinNameComboBox(this.getSkinDir());
    }

    private void fillSkinNameComboBox(File skinsDir) {
        this.skinNameComboBox.removeAllItems();
        File[] files = SkinHelper.skins(skinsDir);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                this.skinNameComboBox.addItem(files[i].getName());
            }
        }
    }

    void choosePath() {
        File p;
        if (this.pathChooser == null) {
            this.pathChooser = new JFileChooser();
            this.pathChooser.setFileSelectionMode(1);
        }
        File path = new File(this.pathTextField.getText());
        this.pathChooser.setCurrentDirectory(path);
        int returnVal = this.pathChooser.showOpenDialog(this);
        if (returnVal == 0 && !path.equals(p = this.pathChooser.getSelectedFile())) {
            this.pathTextField.setText(p.getAbsolutePath());
            String name = (String)this.skinNameComboBox.getSelectedItem();
            this.fillSkinNameComboBox();
            this.skinNameComboBox.setSelectedItem(name);
        }
    }

    public void setEditedDocument(Object document) {
        this.skin = (SkinInfo)document;
    }

    public Object getEditedDocument() {
        return this.skin;
    }

    protected void doSave() {
        this.skin.setSkinName((String)this.skinNameComboBox.getSelectedItem());
        this.skin.setPath(this.defaultPathCheckBox.isSelected() ? null : this.pathTextField.getText());
    }

    public void cancel() {
        this.initEdition();
        this.modified(false);
    }

    public void reload() {
        this.initEdition();
    }

    public String getDocumentName() {
        return this.textDisplayer.getString("editor.title");
    }

    public boolean hasDocumentModified() {
        return this.isModified;
    }

    public Component getEditorGuiComponent() {
        return this;
    }

    public Icon getIcon() {
        return null;
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.fill = 2;
        gridBagConstraints11.gridx = 1;
        gridBagConstraints11.gridy = 1;
        gridBagConstraints11.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints11.weightx = 200.0;
        this.skinNameLabel = new JLabel();
        this.skinNameLabel.setText("skin.name.label");
        this.textDisplayer.register(this.skinNameLabel, "skin.name.label");
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.anchor = 18;
        gridBagConstraints7.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints7.gridwidth = 1;
        gridBagConstraints7.gridx = 1;
        gridBagConstraints7.gridy = 2;
        gridBagConstraints7.weightx = 0.0;
        gridBagConstraints7.fill = 0;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.anchor = 12;
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 2;
        gridBagConstraints6.weighty = 2000.0;
        gridBagConstraints6.insets = new Insets(7, 30, 7, 5);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints5.gridy = 1;
        gridBagConstraints5.weightx = 200.0;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.gridx = 2;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.gridwidth = 1;
        gridBagConstraints4.gridx = -1;
        gridBagConstraints4.gridy = -1;
        gridBagConstraints4.weightx = 2.0;
        gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(5, 25, 5, 5);
        this.addTitle(3, lookManagement);
        this.add((Component)this.getDefaultPathCheckBox(), gridBagConstraints2);
        this.add((Component)this.getPathTextField(), gridBagConstraints11);
        this.add((Component)this.getPathButton(), gridBagConstraints5);
        this.add((Component)this.skinNameLabel, gridBagConstraints6);
        this.add((Component)this.getTypeComboBox(), gridBagConstraints7);
    }

    private JComboBox getTypeComboBox() {
        if (this.skinNameComboBox == null) {
            this.skinNameComboBox = new JComboBox();
            this.skinNameComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent event) {
                    if (SkinEditor.this.skinNameComboBox.getItemCount() > 0) {
                        SkinEditor.this.modified(SkinEditor.this.onError);
                    }
                }
            });
        }
        return this.skinNameComboBox;
    }

    private JCheckBox getDefaultPathCheckBox() {
        if (this.defaultPathCheckBox == null) {
            this.defaultPathCheckBox = new JCheckBox();
            this.defaultPathCheckBox.setText("default.path");
            this.defaultPathCheckBox.setHorizontalTextPosition(2);
            this.textDisplayer.register(this.defaultPathCheckBox, "default.path");
            this.defaultPathCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    SkinEditor.this.defaultPathStateChanged();
                }
            });
        }
        return this.defaultPathCheckBox;
    }

    private JTextField getPathTextField() {
        if (this.pathTextField == null) {
            this.pathTextField = new JTextField();
            this.pathTextField.setEditable(false);
            this.pathTextField.setDisabledTextColor(XissWebUI.darkColor);
            this.pathTextField.setEnabled(false);
            this.pathTextField.setColumns(20);
            this.pathTextField.setPreferredSize(new Dimension(200, 20));
        }
        return this.pathTextField;
    }

    private JButton getPathButton() {
        if (this.pathButton == null) {
            this.pathButton = new JButton();
            this.pathButton.setText("choose.path");
            this.textDisplayer.register(this.pathButton, "choose.path");
            this.pathButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SkinEditor.this.choosePath();
                }
            });
        }
        return this.pathButton;
    }

    public void langChanged() {
        this.pathChooser = null;
    }
}

